/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.world.biome.normal;

import azmalent.terraincognita.TIConfig;
import azmalent.terraincognita.common.registry.ModSurfaceBuilders;
import azmalent.terraincognita.common.world.ModFlowerFeatures;
import azmalent.terraincognita.common.world.ModTreeFeatures;
import azmalent.terraincognita.common.world.biome.NormalBiomeEntry;
import azmalent.terraincognita.common.world.surfacebuilder.LushPlainsSurfaceBuilder;
import azmalent.terraincognita.util.WorldGenUtil;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;

public class LushPlainsBiome
extends NormalBiomeEntry {
    public LushPlainsBiome(String id, Supplier<Integer> spawnWeight) {
        super(id, spawnWeight);
    }

    @Override
    protected Biome.Category getCategory() {
        return Biome.Category.PLAINS;
    }

    @Override
    protected Biome.Climate getClimate() {
        return new Biome.Climate(Biome.RainType.RAIN, 0.8f, Biome.TemperatureModifier.NONE, 0.4f);
    }

    @Override
    protected float getDepth() {
        return 0.125f;
    }

    @Override
    protected float getScale() {
        return 0.05f;
    }

    @Override
    protected BiomeAmbience getAmbience() {
        return new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_242539_d(LushPlainsBiome.getSkyColorWithTemperatureModifier(0.8f)).func_242541_f(10209830).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_();
    }

    @Override
    protected ConfiguredSurfaceBuilder<?> getSurfaceBuilder() {
        return ((LushPlainsSurfaceBuilder)ModSurfaceBuilders.LUSH_PLAINS.get()).func_242929_a((ISurfaceBuilderConfig)SurfaceBuilder.field_215425_v);
    }

    @Override
    protected BiomeManager.BiomeType getBiomeType() {
        return BiomeManager.BiomeType.WARM;
    }

    @Override
    protected List<BiomeDictionary.Type> getBiomeDictionaryTypes() {
        return Lists.newArrayList((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.LUSH});
    }

    @Override
    protected MobSpawnInfo.Builder initSpawns() {
        MobSpawnInfo.Builder spawns = new MobSpawnInfo.Builder();
        DefaultBiomeFeatures.func_243739_d((MobSpawnInfo.Builder)spawns);
        return spawns;
    }

    @Override
    public void initFeatures(BiomeGenerationSettingsBuilder builder) {
        this.initDefaultFeatures((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)builder);
        builder.func_242516_a(StructureFeatures.field_244159_y);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243711_Y((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243704_R((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243717_aa((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)builder);
        if (TIConfig.Trees.apple.get().booleanValue()) {
            WorldGenUtil.addVegetation(builder, ModTreeFeatures.EXTRA_APPLE_TREE);
        }
        WorldGenUtil.addVegetation(builder, ModTreeFeatures.LUSH_PLAINS_OAK, ModTreeFeatures.OAK_SHRUB, ModFlowerFeatures.LUSH_PLAINS_FLOWERS);
    }
}

