/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.world.biome.normal;

import azmalent.terraincognita.common.registry.ModSurfaceBuilders;
import azmalent.terraincognita.common.world.ModConfiguredFeatures;
import azmalent.terraincognita.common.world.ModDefaultFeatures;
import azmalent.terraincognita.common.world.ModTreeFeatures;
import azmalent.terraincognita.common.world.biome.NormalBiomeEntry;
import azmalent.terraincognita.common.world.surfacebuilder.MuskegSurfaceBuilder;
import azmalent.terraincognita.util.WorldGenUtil;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;

public class MuskegBiome
extends NormalBiomeEntry {
    public MuskegBiome(String id, Supplier<Integer> spawnWeight) {
        super(id, spawnWeight);
    }

    @Override
    protected Biome.Category getCategory() {
        return Biome.Category.SWAMP;
    }

    @Override
    protected Biome.Climate getClimate() {
        return new Biome.Climate(Biome.RainType.RAIN, 0.25f, Biome.TemperatureModifier.NONE, 0.8f);
    }

    @Override
    protected float getDepth() {
        return -0.15f;
    }

    @Override
    protected float getScale() {
        return 0.05f;
    }

    @Override
    protected BiomeAmbience getAmbience() {
        return new BiomeAmbience.Builder().func_235246_b_(7893856).func_235248_c_(2302743).func_235239_a_(12638463).func_242539_d(MuskegBiome.getSkyColorWithTemperatureModifier(0.25f)).func_242540_e(6975545).func_242537_a(BiomeAmbience.GrassColorModifier.SWAMP).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_();
    }

    @Override
    protected ConfiguredSurfaceBuilder<?> getSurfaceBuilder() {
        return ((MuskegSurfaceBuilder)ModSurfaceBuilders.MUSKEG.get()).func_242929_a((ISurfaceBuilderConfig)SurfaceBuilder.field_215425_v);
    }

    @Override
    protected BiomeManager.BiomeType getBiomeType() {
        return BiomeManager.BiomeType.ICY;
    }

    @Override
    protected List<BiomeDictionary.Type> getBiomeDictionaryTypes() {
        return Lists.newArrayList((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS});
    }

    @Override
    protected MobSpawnInfo.Builder initSpawns() {
        MobSpawnInfo.Builder spawns = new MobSpawnInfo.Builder();
        DefaultBiomeFeatures.func_243714_a((MobSpawnInfo.Builder)spawns);
        DefaultBiomeFeatures.func_243734_b((MobSpawnInfo.Builder)spawns);
        DefaultBiomeFeatures.func_243735_b((MobSpawnInfo.Builder)spawns, (int)95, (int)5, (int)50);
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200750_ap, 50, 4, 4));
        return spawns;
    }

    @Override
    public void initFeatures(BiomeGenerationSettingsBuilder builder) {
        this.initDefaultFeatures((BiomeGenerationSettings.Builder)builder);
        builder.func_242516_a(StructureFeatures.field_244144_j).func_242516_a(StructureFeatures.field_244135_a).func_242516_a(StructureFeatures.field_244136_b).func_242516_a(StructureFeatures.field_244131_B);
        DefaultBiomeFeatures.func_243755_o((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243723_ag((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243721_ae((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243707_U((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243706_T((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243757_q((BiomeGenerationSettings.Builder)builder);
        ModDefaultFeatures.withArcticFlowers(builder);
        ModDefaultFeatures.withCaribouMoss(builder);
        ModDefaultFeatures.withSourBerries(builder);
        WorldGenUtil.addVegetation(builder, Features.field_243810_aI, Features.field_243965_y, ModTreeFeatures.MUSKEG_TREES);
        WorldGenUtil.addModification(builder, ModConfiguredFeatures.MUSKEG_LOG);
    }
}

