/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.world.feature;

import azmalent.terraincognita.common.block.plants.CaribouMossWallBlock;
import azmalent.terraincognita.common.registry.ModBlocks;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class CaribouMossFeature
extends Feature<NoFeatureConfig> {
    public CaribouMossFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean generate(@Nonnull ISeedReader reader, @Nonnull ChunkGenerator generator, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull NoFeatureConfig config) {
        boolean success = false;
        if (reader.func_175623_d(pos) && ModBlocks.CARIBOU_MOSS.getBlock().func_176223_P().func_196955_c((IWorldReader)reader, pos)) {
            int x = 4 + rand.nextInt(6);
            int z = 4 + rand.nextInt(6);
            int count = (int)((double)(x * z) * (rand.nextDouble() + rand.nextDouble() + 2.0));
            BlockPos.Mutable nextPos = new BlockPos.Mutable();
            for (int i = 0; i < count; ++i) {
                nextPos.func_239621_a_((Vector3i)pos, rand.nextInt(x) - rand.nextInt(x), rand.nextInt(2) - rand.nextInt(2), rand.nextInt(z) - rand.nextInt(z));
                if (!reader.func_175623_d((BlockPos)nextPos)) continue;
                success |= CaribouMossFeature.tryPlaceMoss(reader, (BlockPos)nextPos, rand);
            }
        }
        return success;
    }

    public static boolean tryPlaceMoss(ISeedReader reader, BlockPos pos, Random rand) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState state = (BlockState)ModBlocks.CARIBOU_MOSS_WALL.getDefaultState().func_206870_a((Property)CaribouMossWallBlock.FACING, (Comparable)direction);
            if (!rand.nextBoolean() || !state.func_196955_c((IWorldReader)reader, pos)) continue;
            reader.func_180501_a(pos, state, 2);
            return true;
        }
        BlockState state = ModBlocks.CARIBOU_MOSS.getBlock().func_176223_P();
        if (state.func_196955_c((IWorldReader)reader, pos)) {
            reader.func_180501_a(pos, state, 2);
            return true;
        }
        return false;
    }
}

