/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.mixin.compat.quark;

import azmalent.terraincognita.TIConfig;
import azmalent.terraincognita.common.registry.ModBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vazkii.quark.content.world.gen.FairyRingGenerator;
import vazkii.quark.content.world.module.FairyRingsModule;

@Mixin(value={FairyRingGenerator.class})
public class FairyRingGeneratorMixin {
    @Inject(method={"generateChunk"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void generateChunk(WorldGenRegion worldIn, ChunkGenerator generator, Random rand, BlockPos corner, CallbackInfo ci) {
        int x = corner.func_177958_n() + rand.nextInt(16);
        int z = corner.func_177952_p() + rand.nextInt(16);
        BlockPos center = new BlockPos(x, 128, z);
        Biome biome = worldIn.func_225523_d_().func_226836_a_(center);
        Biome.Category category = biome.func_201856_r();
        double chance = 0.0;
        if (category == Biome.Category.FOREST) {
            chance = FairyRingsModule.forestChance;
        } else if (category == Biome.Category.PLAINS) {
            chance = FairyRingsModule.plainsChance;
        } else if (category == Biome.Category.SAVANNA) {
            chance = TIConfig.Integration.Quark.savannaFairyRingChance.get();
        }
        if (rand.nextDouble() < chance) {
            BlockPos pos = center;
            BlockState state = worldIn.func_180495_p(pos);
            while (state.func_185904_a() != Material.field_151577_b && pos.func_177956_o() > 30) {
                pos = pos.func_177977_b();
                state = worldIn.func_180495_p(pos);
            }
            if (state.func_185904_a() == Material.field_151577_b) {
                FairyRingGenerator.spawnFairyRing((IWorld)worldIn, (BlockPos)pos.func_177977_b(), (Random)rand);
            }
        }
        ci.cancel();
    }

    @Redirect(method={"spawnFairyRing"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/Block;getDefaultState()Lnet/minecraft/block/BlockState;"))
    private static BlockState selectFlower(Block self, IWorld world, BlockPos pos, Random rand) {
        if (world.func_226691_t_(pos).func_201856_r() == Biome.Category.SAVANNA && TIConfig.Flora.savannaFlowers.get().booleanValue()) {
            return ModBlocks.MARIGOLD.getBlock().func_176223_P();
        }
        return self.func_176223_P();
    }
}

