/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;

public class DyeHelper {
    private static final HashMap<String, Collection<Item>> TAGS = new HashMap();
    private static final HashMap<String, DyeColor> DYES = new HashMap();
    private static final HashSet<String> NON_DYES = new HashSet();

    public static String getDyeName(ItemStack stack) {
        return stack.func_190926_b() ? "" : DyeHelper.getDyeName(stack.func_77973_b());
    }

    public static String getDyeName(Item item) {
        if (item != null) {
            DyeColor dyeColor = DyeHelper.getDyeColor(item);
            return dyeColor == null ? "" : dyeColor.func_176762_d();
        }
        return "";
    }

    public static DyeColor getDyeColor(ItemStack stack) {
        return stack.func_190926_b() ? null : DyeHelper.getDyeColor(stack.func_77973_b());
    }

    public static DyeColor getDyeColor(Item item) {
        if (item != null) {
            String id = item.getRegistryName().toString();
            if (DYES.containsKey(id)) {
                return DYES.get(id);
            }
            if (!NON_DYES.contains(id)) {
                if (TAGS.isEmpty()) {
                    DyeHelper.generate();
                }
                for (DyeColor dyeColor : DyeColor.values()) {
                    String dyeName = dyeColor.func_176762_d();
                    if (!TAGS.get(dyeName).contains(item)) continue;
                    DYES.put(id, dyeColor);
                    return dyeColor;
                }
            }
            NON_DYES.add(id);
        }
        return null;
    }

    public static boolean isDye(ItemStack stack) {
        return !stack.func_190926_b() && DyeHelper.isDye(stack.func_77973_b());
    }

    public static boolean isDye(Item item) {
        if (item != null) {
            String id = item.getRegistryName().toString();
            if (DYES.containsKey(id)) {
                return true;
            }
            if (!NON_DYES.contains(id)) {
                if (TAGS.isEmpty()) {
                    DyeHelper.generate();
                }
                return TAGS.get("all").contains(item);
            }
            NON_DYES.add(id);
        }
        return false;
    }

    private static void generate() {
        TAGS.put("all", ItemTags.func_199901_a((String)"forge:dyes").func_230236_b_());
        for (DyeColor dyeColor : DyeColor.values()) {
            TAGS.put(dyeColor.func_176762_d(), ItemTags.func_199901_a((String)("forge:dyes/" + dyeColor.func_176762_d())).func_230236_b_());
        }
    }
}

