/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.inventory;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.items.wrapper.InvWrapper;

public interface ISidedWrapper {
    public SidedWrapper getSidedWrapper();

    public static class SidedWrapper {
        private List<InvWrapper> invWrappers = new ArrayList<InvWrapper>();
        byte[] indexSide = new byte[]{-1, -1, -1, -1, -1, -1};
        byte defaultIndex = (byte)-1;

        public SidedWrapper(int defaultIndex, InvWrapper ... wrappers) {
            this.invWrappers.clear();
            if (wrappers != null) {
                for (InvWrapper wrapper : wrappers) {
                    if (wrapper == null || this.invWrappers.contains(wrapper)) continue;
                    this.invWrappers.add(wrapper);
                }
            }
            this.defaultIndex = this.trim(defaultIndex);
        }

        public void setFaceIndex(Direction facing, int index) {
            if (facing != null) {
                this.indexSide[facing.func_176745_a()] = this.trim(index);
            }
        }

        private byte trim(int index) {
            return (byte)(index > -1 && index < this.invWrappers.size() ? index : -1);
        }

        public byte[] getIndexes() {
            return this.indexSide;
        }

        public InvWrapper getWrapper(Direction blockFacing, Direction side) {
            try {
                if (blockFacing != null && side != null) {
                    if (side.func_176740_k() != Direction.Axis.Y) {
                        switch (blockFacing) {
                            case NORTH: {
                                return this.invWrappers.get(this.indexSide[side.func_176734_d().func_176745_a()]);
                            }
                            case WEST: {
                                return this.invWrappers.get(this.indexSide[side.func_176735_f().func_176745_a()]);
                            }
                            case EAST: {
                                return this.invWrappers.get(this.indexSide[side.func_176746_e().func_176745_a()]);
                            }
                        }
                    }
                    return this.invWrappers.get(this.indexSide[side.func_176745_a()]);
                }
                return this.invWrappers.get(this.defaultIndex);
            }
            catch (Exception ignored) {
                return null;
            }
        }

        public int getWrapperCount() {
            return this.invWrappers.size();
        }

        public void writeToNBT(CompoundNBT nbtTag) {
            nbtTag.func_74773_a("sidedWrapper", this.indexSide);
        }

        public void readFromNBT(CompoundNBT nbtTag) {
            byte[] indexes;
            if (nbtTag.func_74764_b("sidedWrapper") && (indexes = nbtTag.func_74770_j("sidedWrapper")).length == 6) {
                this.indexSide = indexes;
            }
        }
    }
}

