/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal;

import com.google.common.base.Strings;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CauldronBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import shetiphian.core.Configuration;
import shetiphian.core.common.DyeHelper;
import shetiphian.core.common.Function;
import shetiphian.core.common.IBonemealable;
import shetiphian.core.common.rgb16.IRGB16_Block;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.RGB16StackHelper;
import shetiphian.core.internal.network.NetworkHandler;
import shetiphian.core.internal.network.PacketConfig;

public class EventHandler {
    private Random rand = new Random();

    @SubscribeEvent
    public void onApplyBonemeal(BonemealEvent event) {
        BlockPos pos;
        World world;
        IBonemealable bonemealable;
        BlockState state = event.getBlock();
        if (state != null && state.func_177230_c() instanceof IBonemealable && (bonemealable = (IBonemealable)state.func_177230_c()).canGrow(world = event.getWorld(), pos = event.getPos(), state, world.field_72995_K)) {
            if (!world.field_72995_K && bonemealable.canUseBonemeal(world, world.field_73012_v, pos, state)) {
                bonemealable.grow(world, world.field_73012_v, pos, state);
            }
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void itemCrafted(PlayerEvent.ItemCraftedEvent event) {
        IRGB16_Item rgb16Item;
        ItemStack result = event.getCrafting();
        if (!result.func_190926_b() && result.func_77973_b() instanceof IRGB16_Item && (rgb16Item = (IRGB16_Item)result.func_77973_b()).enableDyeRecipe(result) && rgb16Item.dyeUseChance(result)) {
            this.rand.setSeed(RGB16StackHelper.readColorTag(result));
            int counter = 0;
            IInventory inv = event.getInventory();
            for (int index = 0; index < inv.func_70302_i_(); ++index) {
                ItemStack invStack = inv.func_70301_a(index);
                if (invStack.func_190926_b() || !invStack.func_77985_e() || !DyeHelper.isDye(invStack) || invStack.hasContainerItem()) continue;
                double chance = rgb16Item.getDyeUseChance(result, invStack, counter);
                ++counter;
                if (!(chance < 1.0) || chance != 0.0 && !(this.rand.nextDouble() >= chance)) continue;
                invStack.func_190917_f(1);
            }
        }
    }

    @SubscribeEvent
    public void playerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack heldStack;
        Item item;
        int level;
        String dyeName;
        PlayerEntity player = event.getPlayer();
        if (player == null || event.getItemStack().func_190926_b()) {
            return;
        }
        BlockState state = player.func_130014_f_().func_180495_p(event.getPos());
        Block block = state.func_177230_c();
        if (block instanceof IRGB16_Block && !Strings.isNullOrEmpty((String)(dyeName = DyeHelper.getDyeName(event.getItemStack())))) {
            Vector3d hitVec;
            RayTraceResult result = Function.getMovingObjectPosition(player.func_130014_f_(), (Entity)player, true, 64.0);
            Vector3d vector3d = hitVec = result != null ? result.func_216347_e() : new Vector3d(0.5, 0.5, 0.5);
            if (((IRGB16_Block)block).recolorBlock(state, (IWorld)player.func_130014_f_(), event.getPos(), player, event.getHand(), event.getFace(), hitVec, dyeName)) {
                event.setCanceled(true);
                event.setCancellationResult(ActionResultType.SUCCESS);
            }
        }
        if (block instanceof CauldronBlock && (level = ((Integer)state.func_177229_b((Property)CauldronBlock.field_176591_a)).intValue()) > 0 && (item = (heldStack = event.getItemStack()).func_77973_b()) instanceof IRGB16_Item && ((IRGB16_Item)item).enableDyeRecipe(heldStack) && RGB16StackHelper.getRGB16Index(heldStack) != ((IRGB16_Item)item).getStartingIndex(heldStack)) {
            ItemStack washedStack = heldStack.func_77946_l();
            washedStack.func_190920_e(1);
            IRGB16_Item itemRGB16 = (IRGB16_Item)item;
            short baseColor = itemRGB16.getStartingIndex(washedStack);
            if (itemRGB16.setRGB16(washedStack, baseColor)) {
                heldStack.func_190918_g(1);
                if (!event.getPlayer().field_71075_bZ.field_75098_d) {
                    ((CauldronBlock)block).func_176590_a(player.func_130014_f_(), event.getPos(), state, level - 1);
                }
                if (heldStack.func_190926_b()) {
                    player.func_184611_a(event.getHand(), washedStack);
                } else if (!player.field_71071_by.func_70441_a(washedStack)) {
                    player.func_71019_a(washedStack, false);
                } else if (player instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)player).func_71120_a((Container)player.field_71069_bz);
                }
                event.setCanceled(true);
                event.setCancellationResult(ActionResultType.SUCCESS);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onEntityJoinedWorld(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K && event.getEntity() instanceof PlayerEntity) {
            Minecraft.func_71410_x().execute(() -> NetworkHandler.sendToServer(new PacketConfig((Boolean)Configuration.GENERAL.useColorBlendMode.get())));
        }
    }
}

