/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.guide;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import joptsimple.internal.Strings;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.ModList;
import shetiphian.core.ShetiPhianCore;
import shetiphian.core.common.Function;
import shetiphian.guide.GuidePage;

public class GuideLoader {
    private static final GuideLoader INSTANCE = new GuideLoader();
    private Map<String, Map<String, GuidePage>> modpages = new LinkedHashMap<String, Map<String, GuidePage>>();
    private Collection<String> modkeys = new TreeSet<Object>(Collator.getInstance());
    private Map<String, String> guideFiles = new LinkedHashMap<String, String>();
    private boolean[] notices;

    static String[] getModKeys() {
        return GuideLoader.INSTANCE.modkeys.toArray(new String[GuideLoader.INSTANCE.modkeys.size()]);
    }

    static Map<String, GuidePage> getModPages(String modId) {
        return GuideLoader.INSTANCE.modpages.get(modId);
    }

    static void reloadGuideFiles() {
        GuideLoader.INSTANCE.modpages.clear();
        GuideLoader.INSTANCE.modkeys.clear();
        for (Map.Entry<String, String> entry : GuideLoader.INSTANCE.guideFiles.entrySet()) {
            INSTANCE.loadFile(entry.getKey(), entry.getValue());
        }
    }

    public static boolean loadGuideFile(String modId, String filename) {
        if (INSTANCE.loadFile(modId, filename)) {
            GuideLoader.INSTANCE.guideFiles.put(modId, filename);
            return true;
        }
        return false;
    }

    private boolean loadFile(String modId, String filename) {
        this.notices = new boolean[]{false, false};
        if (!this.modpages.containsKey(modId)) {
            try {
                this.readFile(modId, filename);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile(String modId, String filename) throws IOException {
        filename = "/assets/shetiphianguide/" + filename;
        ShetiPhianCore.LOGGER.info("Loading GuideFile: " + filename);
        InputStream is = this.getClass().getResourceAsStream(filename);
        if (is != null && !this.modpages.containsKey(modId)) {
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(is, "UTF-8"));
            Map<String, GuidePage> pages = null;
            try {
                pages = this.parseJSON(reader);
            }
            finally {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
            if (pages != null) {
                this.modpages.put(modId, pages);
                this.modkeys.add(modId);
            }
        }
    }

    private Map<String, GuidePage> parseJSON(JsonReader reader) throws IOException {
        LinkedHashMap<String, GuidePage> pages = new LinkedHashMap<String, GuidePage>();
        reader.beginArray();
        while (reader.hasNext()) {
            try {
                GuidePage page = this.parseObject(reader);
                if (page == null) continue;
                pages.put(page.getId(), page);
            }
            catch (MalformedJsonException e) {
                ShetiPhianCore.LOGGER.info("MalformedJsonException! Nothing else from the file can be loaded");
                ShetiPhianCore.LOGGER.error(e.toString().replace("Use JsonReader.setLenient(true) to accept m", "M"));
                return pages;
            }
        }
        reader.endArray();
        return pages;
    }

    private GuidePage parseObject(JsonReader reader) throws IOException {
        String requiredMod = "";
        String stackToFind = "";
        GuidePage page = new GuidePage();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("id")) {
                page.setId(reader.nextString());
                continue;
            }
            if (name.equals("title")) {
                page.setTitle(reader.nextString());
                continue;
            }
            if (name.equals("required_mod")) {
                requiredMod = reader.nextString();
                continue;
            }
            if (name.equals("type")) {
                page.setType(reader.nextString());
                continue;
            }
            if (name.equals("linkback")) {
                page.setLinkBack(reader.nextString());
                continue;
            }
            if (name.equals("linknext")) {
                page.setLinkNext(reader.nextString());
                continue;
            }
            if (name.equals("text")) {
                page.setText(reader.nextString());
                continue;
            }
            if (name.equals("background")) {
                page.setBackground(reader.nextString());
                continue;
            }
            if (name.equals("output") || name.equals("craftoutput")) {
                stackToFind = reader.nextString();
                continue;
            }
            if (name.equals("linklist") && reader.peek() != JsonToken.NULL) {
                page.setLinkList(this.getStringList(reader));
                continue;
            }
            if (name.equals("image") && reader.peek() != JsonToken.NULL) {
                page.setImage(this.getImageData(reader));
                continue;
            }
            reader.skipValue();
            if (name.startsWith("_") || name.equals("craftinput")) continue;
            ShetiPhianCore.LOGGER.error("Unknown name encountered '" + name + "' while parsing page tag");
            if (this.notices[0]) continue;
            ShetiPhianCore.LOGGER.info("Valid names are: 'id', 'title', 'required_mod', 'type', 'linkback', 'linknext', 'text', 'background', 'output', 'linklist', and 'image'");
            this.notices[0] = true;
        }
        reader.endObject();
        if (!Strings.isNullOrEmpty((String)requiredMod) && !ModList.get().isLoaded(requiredMod)) {
            ShetiPhianCore.LOGGER.info("Skipping GuidePage: [id:" + page.getId() + "] as the required mod [" + requiredMod + "] is not loaded");
            return null;
        }
        if (!Strings.isNullOrEmpty((String)stackToFind)) {
            page.setCraftOutput(this.findStack(stackToFind));
        }
        return page.validate() ? page : null;
    }

    private List<String> getStringList(JsonReader reader) throws IOException {
        ArrayList<String> stringList = new ArrayList<String>();
        reader.beginArray();
        while (reader.hasNext()) {
            stringList.add(reader.nextString());
        }
        reader.endArray();
        return stringList;
    }

    private ItemStack findStack(String name) {
        ItemStack stack = null;
        if (!Strings.isNullOrEmpty((String)name) && !name.equals("null")) {
            String[] split = name.split(":");
            if (split.length >= 2) {
                stack = Function.findItemStack(split[0], split[1]);
                if (!stack.func_190926_b()) {
                    if (split.length >= 3) {
                        // empty if block
                    }
                    if (split.length >= 4) {
                        try {
                            stack.func_190920_e(Integer.valueOf(split[3]).intValue());
                        }
                        catch (NumberFormatException e) {
                            ShetiPhianCore.LOGGER.error("Amount Value Error: " + split[3] + " defaulting to 1, wrong amount will likely be displayed");
                        }
                    }
                } else {
                    ShetiPhianCore.LOGGER.error("Could not find Item: " + name + " recheck spelling and capitalization");
                }
            } else {
                ShetiPhianCore.LOGGER.error("Invalid ItemStack Format; Expected: mod:item or mod:item:meta or mod:item:meta:amount Got: " + name);
            }
        }
        return stack;
    }

    private ImageData getImageData(JsonReader reader) throws IOException {
        String file = "";
        int width = 0;
        int height = 0;
        double scale = 1.0;
        int minU = 0;
        int minV = 0;
        int maxU = Integer.MAX_VALUE;
        int maxV = Integer.MAX_VALUE;
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("file")) {
                file = reader.nextString();
                continue;
            }
            if (name.equals("width")) {
                width = reader.nextInt();
                continue;
            }
            if (name.equals("height")) {
                height = reader.nextInt();
                continue;
            }
            if (name.equals("scale")) {
                scale = reader.nextDouble();
                continue;
            }
            if (name.equals("minu")) {
                minU = reader.nextInt();
                continue;
            }
            if (name.equals("minv")) {
                minV = reader.nextInt();
                continue;
            }
            if (name.equals("maxu")) {
                maxU = reader.nextInt();
                continue;
            }
            if (name.equals("maxv")) {
                maxV = reader.nextInt();
                continue;
            }
            reader.skipValue();
            if (name.startsWith("_")) continue;
            ShetiPhianCore.LOGGER.error("Unknown name encountered '" + name + "' while parsing image tag");
            if (this.notices[1]) continue;
            ShetiPhianCore.LOGGER.info("Valid names are: 'file', 'width', 'height', 'scale', 'minu', 'minv', 'maxu', and 'maxv'");
            this.notices[1] = true;
        }
        reader.endObject();
        ImageData image = new ImageData(file, width, height, scale, minU, minV, maxU, maxV);
        return image.isValid() ? image : null;
    }

    static class ImageData {
        private final ResourceLocation texture;
        private final int width;
        private final int height;
        private final double scale;
        private final int minU;
        private final int minV;
        private final int maxU;
        private final int maxV;

        ImageData(String file, int width, int height, double scale, int minU, int minV, int maxU, int maxV) {
            this.texture = new ResourceLocation("shetiphianguide", file);
            this.width = width;
            this.height = height;
            this.scale = scale;
            minU = MathHelper.func_76125_a((int)minU, (int)0, (int)this.width);
            minV = MathHelper.func_76125_a((int)minV, (int)0, (int)this.height);
            maxU = MathHelper.func_76125_a((int)maxU, (int)0, (int)this.width);
            maxV = MathHelper.func_76125_a((int)maxV, (int)0, (int)this.height);
            this.minU = Math.min(minU, maxU);
            this.minV = Math.min(minV, maxV);
            this.maxU = Math.max(minU, maxU);
            this.maxV = Math.max(minV, maxV);
        }

        boolean isValid() {
            return this.texture != null && this.width > 0 && this.height > 0;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public double getScale() {
            return this.scale;
        }

        int getMinU() {
            return this.minU;
        }

        int getMinV() {
            return this.minV;
        }

        public int getMaxU() {
            return this.maxU;
        }

        public int getMaxV() {
            return this.maxV;
        }

        int getSizeU() {
            return this.maxU - this.minU;
        }

        int getSizeV() {
            return this.maxV - this.minV;
        }
    }
}

