/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterstrongholds.world;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.betterstrongholds.BetterStrongholds;
import com.yungnickyoung.minecraft.betterstrongholds.config.BSConfig;
import com.yungnickyoung.minecraft.betterstrongholds.world.jigsaw.JigsawConfig;
import com.yungnickyoung.minecraft.betterstrongholds.world.jigsaw.JigsawManager;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BetterStrongholdStructure
extends Structure<NoFeatureConfig> {
    public BetterStrongholdStructure(Codec<NoFeatureConfig> p_i231996_1_) {
        super(p_i231996_1_);
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.STRONGHOLDS;
    }

    public String func_143025_a() {
        return "Better Stronghold";
    }

    protected boolean func_230363_a_(ChunkGenerator chunkGenerator, BiomeProvider biomeProvider, long seed, SharedSeedRandom chunkRandom, int xChunk, int zChunk, Biome biome, ChunkPos chunkPos, NoFeatureConfig featureConfig) {
        int ringThickness = 96;
        int distanceToFirstRing = 80;
        int chunkDistance = (int)Math.sqrt(xChunk * xChunk + zChunk * zChunk);
        int shiftedChunkDistance = chunkDistance + (ringThickness - distanceToFirstRing);
        int ringSection = shiftedChunkDistance / ringThickness;
        return ringSection % 2 == 1;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void func_230364_a_(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn, NoFeatureConfig config) {
            int x = (chunkX << 4) + 7;
            int z = (chunkZ << 4) + 7;
            int minY = (Integer)BSConfig.general.strongholdStartMinY.get();
            int maxY = (Integer)BSConfig.general.strongholdStartMaxY.get();
            int y = this.field_214631_d.nextInt(maxY - minY) + minY;
            BlockPos blockpos = new BlockPos(x, y, z);
            JigsawConfig villageConfig = new JigsawConfig(() -> (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(new ResourceLocation("betterstrongholds", "starts")), (Integer)BSConfig.general.strongholdSize.get());
            JigsawManager.assembleJigsawStructure(dynamicRegistryManager, villageConfig, chunkGenerator, templateManagerIn, blockpos, this.field_75075_a, (Random)this.field_214631_d, false, false);
            this.func_202500_a();
            BetterStrongholds.LOGGER.debug("Better Stronghold at {} {} {}", (Object)((StructurePiece)this.field_75075_a.get((int)0)).func_74874_b().field_78897_a, (Object)((StructurePiece)this.field_75075_a.get((int)0)).func_74874_b().field_78895_b, (Object)((StructurePiece)this.field_75075_a.get((int)0)).func_74874_b().field_78896_c);
        }
    }
}

