/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curiouselytra;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import top.theillusivec4.caelus.api.CaelusApi;
import top.theillusivec4.caelus.api.RenderElytraEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curiouselytra.CurioElytra;
import top.theillusivec4.curiouselytra.integration.NetheritePlusIntegration;
import top.theillusivec4.curiouselytra.integration.SilentGearIntegration;

@Mod(value="curiouselytra")
public class CuriousElytra {
    public static final String MODID = "curiouselytra";
    public static boolean isNetheritePlusLoaded = false;
    public static boolean isSilentGearLoaded = false;

    public CuriousElytra() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::enqueue);
        eventBus.addListener(this::clientSetup);
        eventBus.addListener(this::setup);
        isNetheritePlusLoaded = ModList.get().isLoaded("netherite_plus");
        isSilentGearLoaded = ModList.get().isLoaded("silentgear");
    }

    private void setup(FMLCommonSetupEvent evt) {
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, this::attachCapabilities);
        MinecraftForge.EVENT_BUS.addListener(this::playerTick);
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        MinecraftForge.EVENT_BUS.addListener(this::renderElytra);
    }

    private void enqueue(InterModEnqueueEvent evt) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BACK.getMessageBuilder().build());
    }

    private void playerTick(TickEvent.PlayerTickEvent evt) {
        PlayerEntity player = evt.player;
        ModifiableAttributeInstance attributeInstance = player.func_110148_a((Attribute)CaelusApi.ELYTRA_FLIGHT.get());
        if (attributeInstance != null) {
            attributeInstance.func_111124_b(CurioElytra.ELYTRA_CURIO_MODIFIER);
            if (!attributeInstance.func_180374_a(CurioElytra.ELYTRA_CURIO_MODIFIER)) {
                CuriosApi.getCuriosHelper().findEquippedCurio(stack -> CaelusApi.canElytraFly((LivingEntity)player, (ItemStack)stack), (LivingEntity)player).ifPresent(triple -> attributeInstance.func_233767_b_(CurioElytra.ELYTRA_CURIO_MODIFIER));
            }
        }
    }

    private void attachCapabilities(AttachCapabilitiesEvent<ItemStack> evt) {
        ItemStack stack = (ItemStack)evt.getObject();
        if (stack.func_77973_b() instanceof ElytraItem || isNetheritePlusLoaded && NetheritePlusIntegration.isNetheriteElytra(stack.func_77973_b())) {
            final LazyOptional elytraCurio = LazyOptional.of(() -> new CurioElytra(stack));
            evt.addCapability(CuriosCapability.ID_ITEM, new ICapabilityProvider(){

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return CuriosCapability.ITEM.orEmpty(cap, elytraCurio);
                }
            });
            evt.addListener(() -> ((LazyOptional)elytraCurio).invalidate());
        }
    }

    private void renderElytra(RenderElytraEvent evt) {
        PlayerEntity playerEntity = evt.getPlayer();
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)playerEntity).ifPresent(handler -> {
            Set tags = CuriosApi.getCuriosHelper().getCurioTags(Items.field_185160_cR);
            for (String id : tags) {
                handler.getStacksHandler(id).ifPresent(stacksHandler -> {
                    IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                    for (int i = 0; i < stackHandler.getSlots(); ++i) {
                        ItemStack stack = stackHandler.getStackInSlot(i);
                        if (!CaelusApi.isElytra((ItemStack)stack) || !((Boolean)stacksHandler.getRenders().get(i)).booleanValue()) continue;
                        evt.setRender(true);
                        ResourceLocation rl = stack.func_77973_b().getRegistryName();
                        if (rl != null) {
                            if (rl.equals((Object)new ResourceLocation("enderitemod:enderite_elytra_seperated"))) {
                                evt.setResourceLocation(new ResourceLocation("minecraft:textures/entity/enderite_elytra.png"));
                            } else if (rl.equals((Object)new ResourceLocation("netherite_plus:netherite_elytra"))) {
                                evt.setResourceLocation(new ResourceLocation("netherite_plus:textures/entity/netherite_elytra.png"));
                            } else if (isSilentGearLoaded && SilentGearIntegration.isSilentGearElytra(stack)) {
                                evt.setResourceLocation(SilentGearIntegration.getElytraTexture());
                                evt.setColor(SilentGearIntegration.getElytraColor(stack));
                            } else if (rl.equals((Object)new ResourceLocation("mana-and-artifice:spectral_elytra"))) {
                                evt.setResourceLocation(new ResourceLocation("mana-and-artifice:textures/entity/elytra.png"));
                                evt.setEnchanted(true);
                            }
                        }
                        if (!stack.func_77948_v()) continue;
                        evt.setEnchanted(true);
                    }
                });
            }
        });
    }
}

