/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.leobeliik.extremesoundmuffler.interfaces.ISoundLists;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Config {
    static final ForgeConfigSpec CLIENT_CONFIG;
    private static final String CATEGORY_GENERAL = "general";
    private static final ForgeConfigSpec.Builder CLIENT_BUILDER;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> forbiddenSounds;
    private static final ForgeConfigSpec.BooleanValue disableInventoryButton;
    private static final ForgeConfigSpec.BooleanValue disableAnchors;
    private static final ForgeConfigSpec.BooleanValue leftButtons;
    private static final ForgeConfigSpec.DoubleValue defaultMuteVolume;
    private static ForgeConfigSpec.BooleanValue showTip;
    private static ForgeConfigSpec.BooleanValue useDarkTheme;
    private static ForgeConfigSpec.BooleanValue isClientSide;

    static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
        ISoundLists.forbiddenSounds.addAll((Collection)forbiddenSounds.get());
    }

    static boolean getDisableInventoryButton() {
        return (Boolean)disableInventoryButton.get();
    }

    public static boolean getDisableAchors() {
        return (Boolean)disableAnchors.get();
    }

    public static float getDefaultMuteVolume() {
        return ((Double)defaultMuteVolume.get()).floatValue();
    }

    public static boolean getLeftButtons() {
        return (Boolean)leftButtons.get();
    }

    public static boolean getShowTip() {
        return (Boolean)showTip.get();
    }

    public static void setShowTip(boolean showTip) {
        Config.showTip.set((Object)showTip);
    }

    static boolean useDarkTheme() {
        return (Boolean)useDarkTheme.get();
    }

    public static boolean isClientSide() {
        return (Boolean)isClientSide.get();
    }

    static {
        CLIENT_BUILDER = new ForgeConfigSpec.Builder();
        CLIENT_BUILDER.comment("general settings").push(CATEGORY_GENERAL);
        forbiddenSounds = CLIENT_BUILDER.comment("Blacklisted Sounds - add the name of the sounds to blacklist, separated with comma").defineList("forbiddenSounds", Arrays.asList("ui.", "music.", "ambient."), o -> o instanceof String);
        disableInventoryButton = CLIENT_BUILDER.comment("Disable the Muffle button in the player inventory?").define("disableInventoryButton", false);
        disableAnchors = CLIENT_BUILDER.comment("Disable the Anchors?").define("disableAnchors", false);
        defaultMuteVolume = CLIENT_BUILDER.comment("Volume set when pressed the mute button by default").defineInRange("defaultMuteVolume", 0.0, 0.0, 0.9);
        leftButtons = CLIENT_BUILDER.comment("Set to true to move the muffle and play buttons to the left side of the GUI").define("leftButtons", false);
        showTip = CLIENT_BUILDER.comment("Show a message the first time a sound is muffled indicating that you can change the volume").define("showTip", true);
        useDarkTheme = CLIENT_BUILDER.comment("Whether or not use the dark theme").define("useDarkTheme", false);
        isClientSide = CLIENT_BUILDER.comment("Set to true if this mod wont be present in the server; it will load and save the Anchors in ESM -> ServerWorld").define("isClientSide", false);
        CLIENT_BUILDER.pop();
        CLIENT_CONFIG = CLIENT_BUILDER.build();
    }
}

