/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler.utils;

import com.leobeliik.extremesoundmuffler.interfaces.IAnchorList;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

public class Anchor {
    private final int id;
    private BlockPos anchorPos;
    private String name;
    private ResourceLocation dimension;
    private int Radius;
    private SortedMap<String, Float> muffledSounds = new TreeMap<String, Float>();

    public Anchor(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public Anchor(int id, String name, BlockPos anchorPos, ResourceLocation dimension, int Radius, SortedMap<String, Float> muffledSounds) {
        this.id = id;
        this.name = name;
        this.anchorPos = anchorPos;
        this.dimension = dimension;
        this.Radius = Radius;
        this.muffledSounds = muffledSounds;
    }

    public BlockPos getAnchorPos() {
        return this.anchorPos;
    }

    private void setAnchorPos(BlockPos anchorPos) {
        this.anchorPos = anchorPos;
    }

    public int getAnchorId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getRadius() {
        return this.Radius;
    }

    public void setRadius(int Radius) {
        this.Radius = Radius;
    }

    private void setName(String name) {
        this.name = name;
    }

    public SortedMap<ResourceLocation, Float> getMuffledSounds() {
        TreeMap<ResourceLocation, Float> temp = new TreeMap<ResourceLocation, Float>();
        this.muffledSounds.forEach((R, F) -> temp.put(new ResourceLocation(R), (Float)F));
        return temp;
    }

    public void setMuffledSounds(SortedMap<ResourceLocation, Float> muffledSounds) {
        muffledSounds.forEach((R, F) -> this.muffledSounds.put(R.toString(), (Float)F));
    }

    public void addSound(ResourceLocation sound, float volume) {
        this.muffledSounds.put(sound.toString(), Float.valueOf(volume));
    }

    public void replaceSound(ResourceLocation sound, float volume) {
        this.muffledSounds.replace(sound.toString(), Float.valueOf(volume));
    }

    public String getX() {
        return this.anchorPos != null ? String.valueOf(this.anchorPos.func_177958_n()) : "";
    }

    public String getY() {
        return this.anchorPos != null ? String.valueOf(this.anchorPos.func_177956_o()) : "";
    }

    public String getZ() {
        return this.anchorPos != null ? String.valueOf(this.anchorPos.func_177952_p()) : "";
    }

    public ResourceLocation getDimension() {
        return this.dimension;
    }

    private void setDimension(ResourceLocation dimension) {
        this.dimension = dimension;
    }

    public void removeSound(ResourceLocation sound) {
        this.muffledSounds.remove(sound.toString());
    }

    public void setAnchor() {
        ClientPlayerEntity player = Objects.requireNonNull(Minecraft.func_71410_x().field_71439_g);
        this.setAnchorPos(player.func_233580_cy_());
        this.setDimension(player.field_213837_d.func_234923_W_().func_240901_a_());
        this.setRadius(this.getRadius() == 0 ? 32 : this.getRadius());
    }

    public void deleteAnchor() {
        this.setName("Anchor: " + this.getAnchorId());
        this.setAnchorPos(null);
        this.setDimension(null);
        this.setRadius(0);
        this.muffledSounds.clear();
    }

    public void editAnchor(String title, int Radius) {
        this.setName(title);
        this.setRadius(Radius);
    }

    public static Anchor getAnchor(ISound sound) {
        BlockPos soundPos = new BlockPos(sound.func_147649_g(), sound.func_147654_h(), sound.func_147651_i());
        for (Anchor anchor : IAnchorList.anchorList) {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (anchor.getAnchorPos() == null || world == null || !world.func_234923_W_().func_240901_a_().equals((Object)anchor.getDimension()) || !soundPos.func_218141_a((Vector3i)anchor.getAnchorPos(), (double)anchor.getRadius()) || !anchor.getMuffledSounds().containsKey(sound.func_147650_b())) continue;
            return anchor;
        }
        return null;
    }
}

