/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.leobeliik.extremesoundmuffler.Config;
import com.leobeliik.extremesoundmuffler.interfaces.IAnchorList;
import com.leobeliik.extremesoundmuffler.interfaces.ISoundLists;
import com.leobeliik.extremesoundmuffler.network.Network;
import com.leobeliik.extremesoundmuffler.network.PacketDataServer;
import com.leobeliik.extremesoundmuffler.utils.Anchor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.IntStream;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class DataManager
implements IAnchorList,
ISoundLists {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final String soundsMuffledFile = "ESM/soundsMuffled.dat";
    private static final String anchorFile = "ESM/ServerWorld/Anchors.dat";

    public static void loadData() {
        if (muffledSounds.isEmpty()) {
            DataManager.loadMuffledMap().forEach((R, F) -> ISoundLists.muffledSounds.put(new ResourceLocation(R), (Float)F));
        }
        if (!Config.isClientSide()) {
            return;
        }
        if (DataManager.loadAnchors() == null || Objects.requireNonNull(DataManager.loadAnchors()).isEmpty()) {
            DataManager.setAnchors();
        } else {
            anchorList.addAll((Collection)Objects.requireNonNull(DataManager.loadAnchors()));
        }
    }

    public static void saveData() {
        DataManager.saveMuffledMap();
        if (Config.isClientSide()) {
            DataManager.saveAnchors();
        } else {
            CompoundNBT anchorNBT = new CompoundNBT();
            IntStream.rangeClosed(0, 9).forEach(i -> anchorNBT.func_218657_a("anchor" + i, (INBT)DataManager.serializeNBT((Anchor)anchorList.get(i))));
            Network.sendToServer(new PacketDataServer(anchorNBT));
        }
    }

    public static void setAnchors() {
        IntStream.rangeClosed(0, 9).forEach(i -> anchorList.add(i, new Anchor(i, "Anchor: " + i)));
    }

    private static CompoundNBT serializeNBT(Anchor anchor) {
        CompoundNBT anchorNBT = new CompoundNBT();
        CompoundNBT muffledNBT = new CompoundNBT();
        anchorNBT.func_74768_a("ID", anchor.getAnchorId());
        anchorNBT.func_74778_a("NAME", anchor.getName());
        if (anchor.getAnchorPos() == null) {
            return anchorNBT;
        }
        anchorNBT.func_218657_a("POS", (INBT)NBTUtil.func_186859_a((BlockPos)anchor.getAnchorPos()));
        anchorNBT.func_74778_a("DIM", anchor.getDimension().toString());
        anchorNBT.func_74768_a("RAD", anchor.getRadius());
        anchor.getMuffledSounds().forEach((R, F) -> muffledNBT.func_74776_a(R.toString(), F.floatValue()));
        anchorNBT.func_218657_a("MUFFLED", (INBT)muffledNBT);
        return anchorNBT;
    }

    public static Anchor deserializeNBT(CompoundNBT nbt) {
        TreeMap<String, Float> muffledSounds = new TreeMap<String, Float>();
        CompoundNBT muffledNBT = nbt.func_74775_l("MUFFLED");
        for (String key : muffledNBT.func_150296_c()) {
            muffledSounds.put(key, Float.valueOf(muffledNBT.func_74760_g(key)));
        }
        if (!nbt.func_74764_b("POS")) {
            return new Anchor(nbt.func_74762_e("ID"), nbt.func_74779_i("NAME"));
        }
        return new Anchor(nbt.func_74762_e("ID"), nbt.func_74779_i("NAME"), NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("POS")), new ResourceLocation(nbt.func_74779_i("DIM")), nbt.func_74762_e("RAD"), muffledSounds);
    }

    private static void saveMuffledMap() {
        new File("ESM/").mkdir();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(soundsMuffledFile), StandardCharsets.UTF_8);){
            writer.write(gson.toJson(ISoundLists.muffledSounds));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Float> loadMuffledMap() {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(soundsMuffledFile), StandardCharsets.UTF_8);){
            Map map = (Map)gson.fromJson(new JsonReader((Reader)reader), new TypeToken<Map<String, Float>>(){}.getType());
            return map;
        }
        catch (JsonSyntaxException | IOException e) {
            return new HashMap<String, Float>();
        }
    }

    private static void saveAnchors() {
        Throwable throwable;
        OutputStreamWriter writer2;
        new File("ESM/ServerWorld/").mkdir();
        try {
            writer2 = new OutputStreamWriter((OutputStream)new FileOutputStream("ESM/ServerWorld/What is this.txt"), StandardCharsets.UTF_8);
            throwable = null;
            try {
                writer2.write(new Gson().toJson((Object)"This is where Extreme sound muffler saves the Anchors for Server Worlds, when the mod is only loaded clientside"));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (writer2 != null) {
                    if (throwable != null) {
                        try {
                            ((Writer)writer2).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((Writer)writer2).close();
                    }
                }
            }
        }
        catch (Exception writer2) {
            // empty catch block
        }
        try {
            writer2 = new OutputStreamWriter((OutputStream)new FileOutputStream(anchorFile), StandardCharsets.UTF_8);
            throwable = null;
            try {
                writer2.write(gson.toJson(IAnchorList.anchorList));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (writer2 != null) {
                    if (throwable != null) {
                        try {
                            ((Writer)writer2).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ((Writer)writer2).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<Anchor> loadAnchors() {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(anchorFile), StandardCharsets.UTF_8);){
            List list = (List)gson.fromJson(new JsonReader((Reader)reader), new TypeToken<List<Anchor>>(){}.getType());
            return list;
        }
        catch (JsonSyntaxException | IOException ignored) {
            return null;
        }
    }
}

