/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.registry;

import architectury_inject_architectury_common_9cb7286195b84688b9282b7095db691c.PlatformMethods;
import java.util.function.Consumer;
import me.shedaniel.architectury.annotations.ExpectPlatform;
import me.shedaniel.architectury.registry.menu.ExtendedMenuProvider;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public final class MenuRegistry {
    private MenuRegistry() {
    }

    public static void openExtendedMenu(ServerPlayerEntity player, final INamedContainerProvider provider, final Consumer<PacketBuffer> bufWriter) {
        MenuRegistry.openExtendedMenu(player, new ExtendedMenuProvider(){

            @Override
            public void saveExtraData(PacketBuffer buf) {
                bufWriter.accept(buf);
            }

            public ITextComponent func_145748_c_() {
                return provider.func_145748_c_();
            }

            @Nullable
            public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
                return provider.createMenu(i, inventory, player);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void openExtendedMenu(ServerPlayerEntity player, ExtendedMenuProvider provider) {
        void var1_1;
        PlatformMethods.platform("openExtendedMenu", (ServerPlayerEntity)player, (ExtendedMenuProvider)var1_1);
    }

    public static void openMenu(ServerPlayerEntity player, INamedContainerProvider provider) {
        player.func_213829_a(provider);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends Container> ContainerType<T> of(SimpleMenuTypeFactory<T> factory) {
        return PlatformMethods.platform("of", factory);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends Container> ContainerType<T> ofExtended(ExtendedMenuTypeFactory<T> factory) {
        return PlatformMethods.platform("ofExtended", factory);
    }

    /*
     * WARNING - void declaration
     */
    @OnlyIn(value=Dist.CLIENT)
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <H extends Container, S extends Screen> void registerScreenFactory(ContainerType<? extends H> type, ScreenFactory<H, S> factory) {
        void var1_1;
        PlatformMethods.platform("registerScreenFactory", type, (ScreenFactory)var1_1);
    }

    @FunctionalInterface
    public static interface ExtendedMenuTypeFactory<T extends Container> {
        public T create(int var1, PlayerInventory var2, PacketBuffer var3);
    }

    @FunctionalInterface
    public static interface SimpleMenuTypeFactory<T extends Container> {
        public T create(int var1, PlayerInventory var2);
    }

    @FunctionalInterface
    @OnlyIn(value=Dist.CLIENT)
    public static interface ScreenFactory<H extends Container, S extends Screen> {
        public S create(H var1, PlayerInventory var2, ITextComponent var3);
    }
}

