/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats;

import com.github.alexthe666.rats.ConfigHolder;
import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.client.ClientProxy;
import com.github.alexthe666.rats.server.CommonProxy;
import com.github.alexthe666.rats.server.entity.RatsEntityRegistry;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.github.alexthe666.rats.server.message.MessageAutoCurdlerFluid;
import com.github.alexthe666.rats.server.message.MessageCheeseStaffRat;
import com.github.alexthe666.rats.server.message.MessageCheeseStaffSync;
import com.github.alexthe666.rats.server.message.MessageDancingRat;
import com.github.alexthe666.rats.server.message.MessageIncreaseRatRecipe;
import com.github.alexthe666.rats.server.message.MessageRatCommand;
import com.github.alexthe666.rats.server.message.MessageRatDismount;
import com.github.alexthe666.rats.server.message.MessageSwingArm;
import com.github.alexthe666.rats.server.message.MessageSyncRatTag;
import com.github.alexthe666.rats.server.message.MessageSyncThrownBlock;
import com.github.alexthe666.rats.server.message.MessageUpdateRatFluid;
import com.github.alexthe666.rats.server.message.MessageUpdateTileSlots;
import com.github.alexthe666.rats.server.misc.TabRatlantis;
import com.github.alexthe666.rats.server.potion.PotionConfitByaldi;
import com.github.alexthe666.rats.server.potion.PotionPlague;
import com.github.alexthe666.rats.server.world.RatsWorldRegistry;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="rats")
@Mod.EventBusSubscriber(modid="rats")
public class RatsMod {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "rats";
    public static final SimpleChannel NETWORK_WRAPPER;
    private static final String PROTOCOL_VERSION;
    public static ItemGroup TAB;
    public static ItemGroup TAB_UPGRADES;
    public static CommonProxy PROXY;
    public static Effect CONFIT_BYALDI_POTION;
    public static Effect PLAGUE_POTION;
    public static boolean ICEANDFIRE_LOADED;
    public static boolean RATLANTIS_LOADED;
    private static int packetsRegistered;
    private static ItemGroup ratlantisTab;

    public RatsMod() {
        RATLANTIS_LOADED = ModList.get().isLoaded("ratlantis");
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupClient);
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, ConfigHolder.CLIENT_SPEC);
        modLoadingContext.registerConfig(ModConfig.Type.COMMON, ConfigHolder.SERVER_SPEC);
        MinecraftForge.EVENT_BUS.addListener(this::onBiomeLoadFromJSON);
        PROXY.init();
        RatsWorldRegistry.init();
    }

    public static <MSG> void sendMSGToServer(MSG message) {
        NETWORK_WRAPPER.sendToServer(message);
    }

    public static <MSG> void sendMSGToAll(MSG message) {
        for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
            RatsMod.sendNonLocal(message, player);
        }
    }

    public static <MSG> void sendNonLocal(MSG msg, ServerPlayerEntity player) {
        if (player.field_71133_b.func_71262_S() || !player.func_200200_C_().equals(player.field_71133_b.func_71214_G())) {
            NETWORK_WRAPPER.sendTo(msg, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static ItemGroup getRatlantisTab() {
        ItemGroup itemGroup = RATLANTIS_LOADED ? (ratlantisTab == null ? (ratlantisTab = new TabRatlantis()) : ratlantisTab) : TAB;
        return itemGroup;
    }

    @SubscribeEvent
    public void onBiomeLoadFromJSON(BiomeLoadingEvent event) {
        if (event.getName() != null) {
            RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)event.getName());
            if (RatConfig.spawnRats && BiomeDictionary.hasType((RegistryKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.OVERWORLD) && !BiomeDictionary.hasType((RegistryKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.WATER) && !BiomeDictionary.hasType((RegistryKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) {
                if (RatConfig.ratsSpawnLikeMonsters) {
                    event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners(RatsEntityRegistry.RAT_SPAWNER, RatConfig.ratSpawnRate, 1, 3));
                } else {
                    event.getSpawns().getSpawner(EntityClassification.CREATURE).add(new MobSpawnInfo.Spawners(RatsEntityRegistry.RAT, RatConfig.ratSpawnRate, 1, 3));
                }
            }
            if (RatConfig.spawnPiper && BiomeDictionary.hasType((RegistryKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.OVERWORLD) && !BiomeDictionary.hasType((RegistryKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.WATER) && !BiomeDictionary.hasType((RegistryKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) {
                event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners(RatsEntityRegistry.PIED_PIPER, RatConfig.piperSpawnRate, 1, 1));
            }
            if (RatConfig.spawnDemonRats && BiomeDictionary.hasType((RegistryKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
                event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners(RatsEntityRegistry.DEMON_RAT, 15, 1, 2));
            }
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        NETWORK_WRAPPER.registerMessage(packetsRegistered++, MessageAutoCurdlerFluid.class, MessageAutoCurdlerFluid::write, MessageAutoCurdlerFluid::read, MessageAutoCurdlerFluid.Handler::handle);
        NETWORK_WRAPPER.registerMessage(packetsRegistered++, MessageCheeseStaffRat.class, MessageCheeseStaffRat::write, MessageCheeseStaffRat::read, MessageCheeseStaffRat.Handler::handle);
        NETWORK_WRAPPER.registerMessage(packetsRegistered++, MessageCheeseStaffSync.class, MessageCheeseStaffSync::write, MessageCheeseStaffSync::read, MessageCheeseStaffSync.Handler::handle);
        NETWORK_WRAPPER.registerMessage(packetsRegistered++, MessageDancingRat.class, MessageDancingRat::write, MessageDancingRat::read, MessageDancingRat.Handler::handle);
        NETWORK_WRAPPER.registerMessage(packetsRegistered++, MessageIncreaseRatRecipe.class, MessageIncreaseRatRecipe::write, MessageIncreaseRatRecipe::read, MessageIncreaseRatRecipe.Handler::handle);
        NETWORK_WRAPPER.registerMessage(packetsRegistered++, MessageRatCommand.class, MessageRatCommand::write, MessageRatCommand::read, MessageRatCommand.Handler::handle);
        NETWORK_WRAPPER.registerMessage(packetsRegistered++, MessageRatDismount.class, MessageRatDismount::write, MessageRatDismount::read, MessageRatDismount.Handler::handle);
        NETWORK_WRAPPER.registerMessage(packetsRegistered++, MessageSwingArm.class, MessageSwingArm::write, MessageSwingArm::read, MessageSwingArm.Handler::handle);
        NETWORK_WRAPPER.registerMessage(packetsRegistered++, MessageSyncThrownBlock.class, MessageSyncThrownBlock::write, MessageSyncThrownBlock::read, MessageSyncThrownBlock.Handler::handle);
        NETWORK_WRAPPER.registerMessage(packetsRegistered++, MessageUpdateRatFluid.class, MessageUpdateRatFluid::write, MessageUpdateRatFluid::read, MessageUpdateRatFluid.Handler::handle);
        NETWORK_WRAPPER.registerMessage(packetsRegistered++, MessageUpdateTileSlots.class, MessageUpdateTileSlots::write, MessageUpdateTileSlots::read, MessageUpdateTileSlots.Handler::handle);
        NETWORK_WRAPPER.registerMessage(packetsRegistered++, MessageSyncRatTag.class, MessageSyncRatTag::write, MessageSyncRatTag::read, MessageSyncRatTag.Handler::handle);
    }

    private void setupClient(FMLClientSetupEvent event) {
        PROXY.preInit();
    }

    static {
        PROTOCOL_VERSION = Integer.toString(1);
        TAB = new ItemGroup(MODID){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)RatsItemRegistry.CHEESE);
            }
        };
        TAB_UPGRADES = new ItemGroup("rats.upgrades"){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)RatsItemRegistry.RAT_UPGRADE_BASIC);
            }
        };
        PROXY = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
        CONFIT_BYALDI_POTION = new PotionConfitByaldi();
        PLAGUE_POTION = new PotionPlague();
        RATLANTIS_LOADED = false;
        packetsRegistered = 0;
        ratlantisTab = null;
        NetworkRegistry.ChannelBuilder channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(MODID, "main_channel"));
        String version = PROTOCOL_VERSION;
        version.getClass();
        channel = channel.clientAcceptedVersions(version::equals);
        version = PROTOCOL_VERSION;
        version.getClass();
        NETWORK_WRAPPER = channel.serverAcceptedVersions(version::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    }
}

