/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.gui;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.tile.TileEntityAutoCurdler;
import com.github.alexthe666.rats.server.inventory.ContainerAutoCurdler;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class GuiAutoCurdler
extends ContainerScreen<ContainerAutoCurdler> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("rats:textures/gui/auto_curdler.png");
    private final PlayerInventory playerInventory;
    private final IInventory tileFurnace;
    public ITextComponent name;

    public GuiAutoCurdler(ContainerAutoCurdler container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.playerInventory = inv;
        this.tileFurnace = container.tileRatCraftingTable;
        this.name = name;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack p_230430_1_, float p_230450_2_, int p_230450_3_, int p_230450_4_) {
        this.func_230446_a_(p_230430_1_);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        int i = (this.field_230708_k_ - this.field_146999_f) / 2;
        int j = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(p_230430_1_, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        int l = ((ContainerAutoCurdler)this.field_147002_h).getCookProgressionScaled();
        this.func_238474_b_(p_230430_1_, i + 63, j + 35, 176, 0, l + 1, 16);
        if (RatsMod.PROXY.getRefrencedTE() instanceof TileEntityAutoCurdler && ((TileEntityAutoCurdler)RatsMod.PROXY.getRefrencedTE()).tank.getFluid() != null) {
            FluidTank tank = ((TileEntityAutoCurdler)RatsMod.PROXY.getRefrencedTE()).tank;
            int textureYPos = (int)(57.0f * ((float)tank.getFluidAmount() / (float)tank.getCapacity()));
            GuiAutoCurdler.renderFluidStack(i + 29, j + 15 - textureYPos + 57, 24, textureYPos, 0.0f, tank.getFluid());
            this.getMinecraft().func_110434_K().func_110577_a(TEXTURE);
        }
        this.func_238474_b_(p_230430_1_, i + 29, j + 15, 0, 166, 24, 58);
        this.func_230451_b_(p_230430_1_, p_230450_3_, p_230450_4_);
    }

    public static void renderFluidStack(int x, int y, int width, int height, float depth, FluidStack fluidStack) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(fluidStack.getFluid().getAttributes().getStillTexture());
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        float u1 = sprite.func_94209_e();
        float v1 = sprite.func_94206_g();
        do {
            int currentHeight = Math.min(sprite.func_94216_b(), height);
            height -= currentHeight;
            float v2 = sprite.func_94207_b((double)((float)(16 * currentHeight) / (float)sprite.func_94216_b()));
            int x2 = x;
            int width2 = width;
            do {
                int currentWidth = Math.min(sprite.func_94211_a(), width2);
                width2 -= currentWidth;
                float u2 = sprite.func_94214_a((double)((float)(16 * currentWidth) / (float)sprite.func_94211_a()));
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                bufferbuilder.func_225582_a_((double)x2, (double)y, (double)depth).func_225583_a_(u1, v1).func_181675_d();
                bufferbuilder.func_225582_a_((double)x2, (double)(y + currentHeight), (double)depth).func_225583_a_(u1, v2).func_181675_d();
                bufferbuilder.func_225582_a_((double)(x2 + currentWidth), (double)(y + currentHeight), (double)depth).func_225583_a_(u2, v2).func_181675_d();
                bufferbuilder.func_225582_a_((double)(x2 + currentWidth), (double)y, (double)depth).func_225583_a_(u2, v1).func_181675_d();
                tessellator.func_78381_a();
                x2 += currentWidth;
            } while (width2 > 0);
            y += currentHeight;
        } while (height > 0);
    }

    protected void func_230451_b_(MatrixStack stackIn, int mouseX, int mouseY) {
        String s = this.func_231171_q_().getString();
        int screenW = (this.field_230708_k_ - this.field_146999_f) / 2;
        int screenH = (this.field_230709_l_ - this.field_147000_g) / 2;
        if (RatsMod.PROXY.getRefrencedTE() instanceof TileEntityAutoCurdler && ((TileEntityAutoCurdler)RatsMod.PROXY.getRefrencedTE()).tank.getFluid() != null && mouseX > screenW + 29 && mouseX < screenW + 53 && mouseY > screenH + 15 && mouseY < screenH + 73) {
            String fluidName = TextFormatting.BLUE.toString() + ((TileEntityAutoCurdler)RatsMod.PROXY.getRefrencedTE()).tank.getFluid().getDisplayName().getString();
            String fluidSize = TextFormatting.GRAY.toString() + ((TileEntityAutoCurdler)RatsMod.PROXY.getRefrencedTE()).tank.getFluidAmount() + " " + I18n.func_135052_a((String)"container.auto_curdler.mb", (Object[])new Object[0]);
            List<StringTextComponent> list = Arrays.asList(new StringTextComponent(fluidName), new StringTextComponent(fluidSize));
            this.func_238654_b_(stackIn, Lists.transform(list, ITextComponent::func_241878_f), mouseX, mouseY);
        }
    }
}

