/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render;

import com.github.alexthe666.rats.server.items.ItemRatNuggetOre;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NuggetColorRegister {
    public static final ItemStack FALLBACK_STACK = new ItemStack((IItemProvider)Items.field_151042_j);
    public static Map<String, Integer> TEXTURES_TO_COLOR = new HashMap<String, Integer>();

    public static int getNuggetColor(ItemStack stack) {
        ItemStack poopStack = ItemRatNuggetOre.getIngot(stack, FALLBACK_STACK, null);
        String poopName = poopStack.func_200301_q().getString();
        if (TEXTURES_TO_COLOR.get(poopName) != null) {
            return TEXTURES_TO_COLOR.get(poopName);
        }
        Inventory iinventory = new Inventory(new ItemStack[]{poopStack});
        FurnaceRecipe irecipe = Minecraft.func_71410_x().field_71441_e.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)iinventory, (World)Minecraft.func_71410_x().field_71441_e).orElse(null);
        ItemStack burntItem = poopStack;
        if (irecipe != null && !irecipe.func_77571_b().func_190926_b()) {
            burntItem = irecipe.func_77571_b().func_77946_l();
        }
        Object texture = null;
        int color = 0xFFFFFF;
        try {
            Color texColour = NuggetColorRegister.getAverageColour(NuggetColorRegister.getTextureAtlas(burntItem));
            color = texColour.getRGB();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        TEXTURES_TO_COLOR.put(poopName, color);
        return color;
    }

    private static Color getAverageColour(TextureAtlasSprite image) {
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        float count = 0.0f;
        int uMax = image.func_94211_a();
        int vMax = image.func_94216_b();
        for (float i = 0.0f; i < (float)uMax; i += 1.0f) {
            for (float j = 0.0f; j < (float)vMax; j += 1.0f) {
                int alpha = image.getPixelRGBA(0, (int)i, (int)j) >> 24 & 0xFF;
                if (alpha != 255) continue;
                red += (float)(image.getPixelRGBA(0, (int)i, (int)j) >> 0 & 0xFF);
                green += (float)(image.getPixelRGBA(0, (int)i, (int)j) >> 8 & 0xFF);
                blue += (float)(image.getPixelRGBA(0, (int)i, (int)j) >> 16 & 0xFF);
                count += 1.0f;
            }
        }
        return new Color((int)(red / count), (int)(green / count), (int)(blue / count));
    }

    private static TextureAtlasSprite getTextureAtlas(ItemStack oreStack) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_199934_a((IItemProvider)oreStack.func_77973_b());
    }
}

