/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.entity;

import com.github.alexthe666.rats.client.model.ModelStaticRat;
import com.github.alexthe666.rats.server.entity.EntityRatShot;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.LightType;

public class RenderRatShot
extends EntityRenderer<EntityRatShot> {
    private static final RenderType TEXTURE_EYES = RenderType.func_228652_i_((ResourceLocation)new ResourceLocation("rats:textures/entity/rat/rat_eye_glow.png"));
    private static final RenderType TEXTURE_0 = RenderType.func_228640_c_((ResourceLocation)new ResourceLocation("rats:textures/entity/rat/rat_blue.png"));
    private static final RenderType TEXTURE_1 = RenderType.func_228640_c_((ResourceLocation)new ResourceLocation("rats:textures/entity/rat/rat_black.png"));
    private static final RenderType TEXTURE_2 = RenderType.func_228640_c_((ResourceLocation)new ResourceLocation("rats:textures/entity/rat/rat_brown.png"));
    private static final RenderType TEXTURE_3 = RenderType.func_228640_c_((ResourceLocation)new ResourceLocation("rats:textures/entity/rat/rat_green.png"));
    private static final ModelStaticRat MODEL_STATIC_RAT = new ModelStaticRat(0);

    public RenderRatShot() {
        super(Minecraft.func_71410_x().func_175598_ae());
    }

    public void render(EntityRatShot entity, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        RenderType resLoc;
        long roundedTime = entity.field_70170_p.func_72820_D() % 24000L;
        boolean night = roundedTime >= 13000L && roundedTime <= 22000L;
        BlockPos ratPos = entity.getLightPosition();
        int brightI = entity.field_70170_p.func_226658_a_(LightType.SKY, ratPos);
        int brightJ = entity.field_70170_p.func_226658_a_(LightType.BLOCK, ratPos);
        int brightness = night ? brightJ : Math.max(brightI, brightJ);
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227862_a_(0.6f, -0.6f, 0.6f);
        float yaw = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTicks;
        float pitch = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks;
        matrixStackIn.func_227861_a_(0.0, -1.5, 0.0);
        matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, yaw - 180.0f, true));
        matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229178_a_, pitch, true));
        switch (entity.getColorVariant()) {
            case 1: {
                resLoc = TEXTURE_1;
                break;
            }
            case 2: {
                resLoc = TEXTURE_2;
                break;
            }
            case 3: {
                resLoc = TEXTURE_3;
                break;
            }
            default: {
                resLoc = TEXTURE_0;
            }
        }
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(resLoc);
        float f = ((float)entity.field_70173_aa + partialTicks) * 0.5f;
        float f1 = 1.0f;
        MODEL_STATIC_RAT.func_225597_a_(entity, f, f1, (float)entity.field_70173_aa + partialTicks, 0.0f, 0.0f);
        MODEL_STATIC_RAT.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.func_229201_a_((int)OverlayTexture.func_229199_a_((float)0.0f), (int)OverlayTexture.func_229202_a_((boolean)false)), 1.0f, 1.0f, 1.0f, 1.0f);
        if (brightness < 7) {
            IVertexBuilder iGlowBuffer = bufferIn.getBuffer(TEXTURE_EYES);
            MODEL_STATIC_RAT.func_225598_a_(matrixStackIn, iGlowBuffer, packedLightIn, OverlayTexture.func_229201_a_((int)OverlayTexture.func_229199_a_((float)0.0f), (int)OverlayTexture.func_229202_a_((boolean)false)), 1.0f, 1.0f, 1.0f, 1.0f);
        }
        matrixStackIn.func_227865_b_();
        super.func_225623_a_((Entity)entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    private float interpolateValue(float start, float end, float pct) {
        return start + (end - start) * pct;
    }

    @Nullable
    public ResourceLocation getEntityTexture(EntityRatShot entity) {
        return null;
    }
}

