/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.blocks;

import com.github.alexthe666.rats.server.blocks.IUsesTEISR;
import com.github.alexthe666.rats.server.blocks.IWearableBlock;
import com.github.alexthe666.rats.server.blocks.RatlantisBlockRegistry;
import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.entity.ratlantis.EntityRatlanteanAutomaton;
import com.github.alexthe666.rats.server.entity.ratlantis.RatlantisEntityRegistry;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatlanteanAutomatonHead;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.pattern.BlockMaterialMatcher;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.block.pattern.BlockPatternBuilder;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockMarbledCheeseRatHead
extends ContainerBlock
implements IUsesTEISR,
IWearableBlock {
    public static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    private static final com.google.common.base.Predicate<BlockState> IS_MARBLE = new com.google.common.base.Predicate<BlockState>(){

        public boolean apply(@Nullable BlockState p_apply_1_) {
            return p_apply_1_ != null && (p_apply_1_.func_177230_c() == RatsBlockRegistry.MARBLED_CHEESE_RAW || p_apply_1_.func_177230_c() == RatlantisBlockRegistry.MARBLED_CHEESE || p_apply_1_.func_177230_c() == RatlantisBlockRegistry.MARBLED_CHEESE_PILLAR || p_apply_1_.func_177230_c() == RatlantisBlockRegistry.MARBLED_CHEESE_TILE || p_apply_1_.func_177230_c() == RatlantisBlockRegistry.MARBLED_CHEESE_CHISELED || p_apply_1_.func_177230_c() == RatlantisBlockRegistry.MARBLED_CHEESE_BRICK || p_apply_1_.func_177230_c() == RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_CHISELED || p_apply_1_.func_177230_c() == RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_MOSSY || p_apply_1_.func_177230_c() == RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_CRACKED);
        }
    };
    private BlockPattern golemBasePattern;
    private BlockPattern golemPattern;

    public BlockMarbledCheeseRatHead() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d).func_235838_a_(p -> 5).func_226896_b_().func_208770_d().func_200948_a(2.5f, 0.0f));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
        this.setRegistryName("rats", "marbled_cheese_rat_head");
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public boolean isOpaqueCube(BlockState state) {
        return false;
    }

    public boolean isFullCube(BlockState state) {
        return false;
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.func_177230_c() != state.func_177230_c()) {
            this.trySpawnGolem(worldIn, pos);
        }
    }

    public boolean canDispenserPlace(World worldIn, BlockPos pos) {
        return this.getGolemBasePattern().func_177681_a((IWorldReader)worldIn, pos) != null;
    }

    private void trySpawnGolem(World worldIn, BlockPos pos) {
        BlockPattern.PatternHelper blockpattern$patternhelper = this.getGolemPattern().func_177681_a((IWorldReader)worldIn, pos);
        if (blockpattern$patternhelper != null) {
            for (int j = 0; j < this.getGolemPattern().func_177684_c(); ++j) {
                for (int k = 0; k < this.getGolemPattern().func_177685_b(); ++k) {
                    worldIn.func_180501_a(blockpattern$patternhelper.func_177670_a(j, k, 0).func_177508_d(), Blocks.field_150350_a.func_176223_P(), 2);
                }
            }
            BlockPos blockpos = blockpattern$patternhelper.func_177670_a(1, 2, 0).func_177508_d();
            EntityRatlanteanAutomaton entityirongolem = new EntityRatlanteanAutomaton(RatlantisEntityRegistry.RATLANTEAN_AUTOMATON, worldIn);
            entityirongolem.func_70012_b((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.05, (double)blockpos.func_177952_p() + 0.5, 0.0f, 0.0f);
            worldIn.func_217376_c((Entity)entityirongolem);
            for (ServerPlayerEntity serverplayerentity1 : worldIn.func_217357_a(ServerPlayerEntity.class, entityirongolem.func_174813_aQ().func_186662_g(5.0))) {
                CriteriaTriggers.field_192133_m.func_192229_a(serverplayerentity1, (Entity)entityirongolem);
            }
            for (int i1 = 0; i1 < this.getGolemPattern().func_177684_c(); ++i1) {
                for (int j1 = 0; j1 < this.getGolemPattern().func_177685_b(); ++j1) {
                    CachedBlockInfo cachedblockinfo1 = blockpattern$patternhelper.func_177670_a(i1, j1, 0);
                    worldIn.func_184138_a(cachedblockinfo1.func_177508_d(), cachedblockinfo1.func_177509_a(), cachedblockinfo1.func_177509_a(), 4);
                }
            }
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    protected BlockPattern getGolemBasePattern() {
        if (this.golemBasePattern == null) {
            this.golemBasePattern = BlockPatternBuilder.func_177660_a().func_177659_a(new String[]{"~ ~", "#X#", "~#~"}).func_177662_a('#', CachedBlockInfo.func_177510_a(IS_MARBLE)).func_177662_a('~', CachedBlockInfo.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177662_a('X', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)RatlantisBlockRegistry.MARBLED_CHEESE_GOLEM_CORE))).func_177661_b();
        }
        return this.golemBasePattern;
    }

    protected BlockPattern getGolemPattern() {
        if (this.golemPattern == null) {
            this.golemPattern = BlockPatternBuilder.func_177660_a().func_177659_a(new String[]{"~^~", "#X#", "~#~"}).func_177662_a('^', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)RatlantisBlockRegistry.MARBLED_CHEESE_RAT_HEAD))).func_177662_a('#', CachedBlockInfo.func_177510_a(IS_MARBLE)).func_177662_a('~', CachedBlockInfo.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177662_a('X', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)RatlantisBlockRegistry.MARBLED_CHEESE_GOLEM_CORE))).func_177661_b();
        }
        return this.golemPattern;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityRatlanteanAutomatonHead();
    }
}

