/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.blocks;

import com.github.alexthe666.rats.server.blocks.BlockRatCage;
import com.github.alexthe666.rats.server.blocks.ICustomRendered;
import com.github.alexthe666.rats.server.blocks.INoTab;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatTube;
import com.github.alexthe666.rats.server.items.ItemRatTube;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BlockRatTube
extends ContainerBlock
implements ICustomRendered,
INoTab {
    public static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    public static final BooleanProperty UP = BooleanProperty.func_177716_a((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.func_177716_a((String)"down");
    public static final BooleanProperty OPEN_NORTH = BooleanProperty.func_177716_a((String)"open_north");
    public static final BooleanProperty OPEN_EAST = BooleanProperty.func_177716_a((String)"open_east");
    public static final BooleanProperty OPEN_SOUTH = BooleanProperty.func_177716_a((String)"open_south");
    public static final BooleanProperty OPEN_WEST = BooleanProperty.func_177716_a((String)"open_west");
    public static final BooleanProperty OPEN_UP = BooleanProperty.func_177716_a((String)"open_up");
    public static final BooleanProperty OPEN_DOWN = BooleanProperty.func_177716_a((String)"open_down");
    public static final BooleanProperty[] ALL_OPEN_PROPS = new BooleanProperty[]{OPEN_DOWN, OPEN_UP, OPEN_NORTH, OPEN_SOUTH, OPEN_WEST, OPEN_EAST};
    private static final VoxelShape UP_AABB = Block.func_208617_a((double)3.0, (double)12.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
    private static final VoxelShape UP_AABB_CONNECT_1 = Block.func_208617_a((double)3.0, (double)13.0, (double)3.0, (double)13.0, (double)16.0, (double)4.0);
    private static final VoxelShape UP_AABB_CONNECT_2 = Block.func_208617_a((double)3.0, (double)13.0, (double)3.0, (double)4.0, (double)16.0, (double)13.0);
    private static final VoxelShape UP_AABB_CONNECT_3 = Block.func_208617_a((double)12.0, (double)13.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape UP_AABB_CONNECT_4 = Block.func_208617_a((double)3.0, (double)13.0, (double)12.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape INTERACT_AABB_CENTER = Block.func_208617_a((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
    private static final VoxelShape INTERACT_AABB_UP = Block.func_208617_a((double)3.0, (double)13.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape INTERACT_AABB_DOWN = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0);
    private static final VoxelShape INTERACT_AABB_SOUTH = Block.func_208617_a((double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0, (double)16.0);
    private static final VoxelShape INTERACT_AABB_NORTH = Block.func_208617_a((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)3.0);
    private static final VoxelShape INTERACT_AABB_WEST = Block.func_208617_a((double)0.0, (double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0);
    private static final VoxelShape INTERACT_AABB_EAST = Block.func_208617_a((double)13.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0);
    private static Map<Direction, VoxelShape> AABB_MAP = new HashMap<Direction, VoxelShape>();
    private static Map<Direction, VoxelShape> AABB_CONNECTOR_1_MAP = new HashMap<Direction, VoxelShape>();
    private static Map<Direction, VoxelShape> AABB_CONNECTOR_2_MAP = new HashMap<Direction, VoxelShape>();
    private static Map<Direction, VoxelShape> AABB_CONNECTOR_3_MAP = new HashMap<Direction, VoxelShape>();
    private static Map<Direction, VoxelShape> AABB_CONNECTOR_4_MAP = new HashMap<Direction, VoxelShape>();
    private static Map<String, VoxelShape> OVERALL_AABB_MAP = new HashMap<String, VoxelShape>();

    public BlockRatTube() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200947_a(SoundType.field_185848_a).func_200948_a(0.9f, 0.0f));
        this.setRegistryName("rats", "rat_tube");
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)OPEN_NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)OPEN_EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)OPEN_SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)OPEN_WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)OPEN_UP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)OPEN_DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public static VoxelShape rotateAABB(VoxelShape aabb, Direction facing) {
        switch (facing) {
            case UP: {
                return aabb;
            }
            case DOWN: {
                return BlockRatTube.makeCuboidShapeNoResize(aabb.func_197752_a().field_72340_a, 1.0 - aabb.func_197752_a().field_72337_e, aabb.func_197752_a().field_72339_c, aabb.func_197752_a().field_72336_d, 1.0 - aabb.func_197752_a().field_72338_b, aabb.func_197752_a().field_72334_f);
            }
            case NORTH: {
                return BlockRatTube.makeCuboidShapeNoResize(aabb.func_197752_a().field_72340_a, aabb.func_197752_a().field_72339_c, 1.0 - aabb.func_197752_a().field_72337_e, aabb.func_197752_a().field_72336_d, aabb.func_197752_a().field_72334_f, 1.0 - aabb.func_197752_a().field_72338_b);
            }
            case SOUTH: {
                return BlockRatTube.makeCuboidShapeNoResize(aabb.func_197752_a().field_72340_a, aabb.func_197752_a().field_72339_c, aabb.func_197752_a().field_72338_b, aabb.func_197752_a().field_72336_d, aabb.func_197752_a().field_72334_f, aabb.func_197752_a().field_72337_e);
            }
            case EAST: {
                return BlockRatTube.makeCuboidShapeNoResize(aabb.func_197752_a().field_72338_b, aabb.func_197752_a().field_72340_a, aabb.func_197752_a().field_72339_c, aabb.func_197752_a().field_72337_e, aabb.func_197752_a().field_72336_d, aabb.func_197752_a().field_72334_f);
            }
            case WEST: {
                return BlockRatTube.makeCuboidShapeNoResize(1.0 - aabb.func_197752_a().field_72337_e, aabb.func_197752_a().field_72340_a, aabb.func_197752_a().field_72339_c, 1.0 - aabb.func_197752_a().field_72338_b, aabb.func_197752_a().field_72336_d, aabb.func_197752_a().field_72334_f);
            }
        }
        return aabb;
    }

    public static VoxelShape makeCuboidShapeNoResize(double x1, double y1, double z1, double x2, double y2, double z2) {
        return VoxelShapes.func_197873_a((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    @Deprecated
    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return super.func_196247_c(state, worldIn, pos);
    }

    public List<VoxelShape> compileVoxelList(IBlockReader reader, BlockPos pos, BlockState state) {
        ArrayList<VoxelShape> aabbs = new ArrayList<VoxelShape>();
        aabbs.add(INTERACT_AABB_CENTER);
        if (state.func_177230_c() instanceof BlockRatTube) {
            BlockState actualState = state;
            if (((Boolean)actualState.func_177229_b((Property)UP)).booleanValue()) {
                aabbs.add(INTERACT_AABB_UP);
            }
            if (((Boolean)actualState.func_177229_b((Property)DOWN)).booleanValue()) {
                aabbs.add(INTERACT_AABB_DOWN);
            }
            if (((Boolean)actualState.func_177229_b((Property)EAST)).booleanValue()) {
                aabbs.add(INTERACT_AABB_EAST);
            }
            if (((Boolean)actualState.func_177229_b((Property)WEST)).booleanValue()) {
                aabbs.add(INTERACT_AABB_WEST);
            }
            if (((Boolean)actualState.func_177229_b((Property)NORTH)).booleanValue()) {
                aabbs.add(INTERACT_AABB_NORTH);
            }
            if (((Boolean)actualState.func_177229_b((Property)SOUTH)).booleanValue()) {
                aabbs.add(INTERACT_AABB_SOUTH);
            }
        }
        return aabbs;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (state.func_177230_c() instanceof BlockRatTube) {
            String key = "up:" + state.func_177229_b((Property)UP) + " down: " + state.func_177229_b((Property)DOWN) + " north: " + state.func_177229_b((Property)NORTH) + " east: " + state.func_177229_b((Property)EAST) + " south: " + state.func_177229_b((Property)SOUTH) + " west: " + state.func_177229_b((Property)WEST) + "up_open:" + state.func_177229_b((Property)OPEN_UP) + " down_open: " + state.func_177229_b((Property)OPEN_DOWN) + " north_open: " + state.func_177229_b((Property)OPEN_NORTH) + " east_open: " + state.func_177229_b((Property)OPEN_EAST) + " south_open: " + state.func_177229_b((Property)OPEN_SOUTH) + " west_open: " + state.func_177229_b((Property)OPEN_WEST);
            if (OVERALL_AABB_MAP.get(key) == null) {
                VoxelShape shape = this.generateRatTubeState(state, worldIn, pos, context);
                OVERALL_AABB_MAP.put(key, shape);
                return shape;
            }
            return OVERALL_AABB_MAP.get(key);
        }
        return super.func_220053_a(state, worldIn, pos, context);
    }

    public VoxelShape generateRatTubeState(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape shape = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        if (state.func_177230_c() instanceof BlockRatTube) {
            BlockState actualState = state;
            if (!((Boolean)actualState.func_177229_b((Property)UP)).booleanValue() && !((Boolean)actualState.func_177229_b((Property)OPEN_UP)).booleanValue()) {
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB, Direction.UP, AABB_MAP), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            if (!((Boolean)actualState.func_177229_b((Property)DOWN)).booleanValue() && !((Boolean)actualState.func_177229_b((Property)OPEN_DOWN)).booleanValue()) {
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB, Direction.DOWN, AABB_MAP), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            if (!((Boolean)actualState.func_177229_b((Property)NORTH)).booleanValue() && !((Boolean)actualState.func_177229_b((Property)OPEN_NORTH)).booleanValue()) {
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB, Direction.NORTH, AABB_MAP), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            if (!((Boolean)actualState.func_177229_b((Property)SOUTH)).booleanValue() && !((Boolean)actualState.func_177229_b((Property)OPEN_SOUTH)).booleanValue()) {
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB, Direction.SOUTH, AABB_MAP), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            if (!((Boolean)actualState.func_177229_b((Property)EAST)).booleanValue() && !((Boolean)actualState.func_177229_b((Property)OPEN_EAST)).booleanValue()) {
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB, Direction.EAST, AABB_MAP), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            if (!((Boolean)actualState.func_177229_b((Property)WEST)).booleanValue() && !((Boolean)actualState.func_177229_b((Property)OPEN_WEST)).booleanValue()) {
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB, Direction.WEST, AABB_MAP), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            if (((Boolean)actualState.func_177229_b((Property)UP)).booleanValue()) {
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_1, Direction.UP, AABB_CONNECTOR_1_MAP), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_2, Direction.UP, AABB_CONNECTOR_2_MAP), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_3, Direction.UP, AABB_CONNECTOR_3_MAP), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_4, Direction.UP, AABB_CONNECTOR_4_MAP), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            if (((Boolean)actualState.func_177229_b((Property)DOWN)).booleanValue()) {
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_1, Direction.DOWN, AABB_CONNECTOR_1_MAP), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_2, Direction.DOWN, AABB_CONNECTOR_2_MAP), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_3, Direction.DOWN, AABB_CONNECTOR_3_MAP), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_4, Direction.DOWN, AABB_CONNECTOR_4_MAP), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            if (((Boolean)actualState.func_177229_b((Property)NORTH)).booleanValue()) {
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_1, Direction.NORTH, AABB_CONNECTOR_1_MAP), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_2, Direction.NORTH, AABB_CONNECTOR_2_MAP), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_3, Direction.NORTH, AABB_CONNECTOR_3_MAP), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_4, Direction.NORTH, AABB_CONNECTOR_4_MAP), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            if (((Boolean)actualState.func_177229_b((Property)SOUTH)).booleanValue()) {
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_1, Direction.SOUTH, AABB_CONNECTOR_1_MAP), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_2, Direction.SOUTH, AABB_CONNECTOR_2_MAP), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_3, Direction.SOUTH, AABB_CONNECTOR_3_MAP), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_4, Direction.SOUTH, AABB_CONNECTOR_4_MAP), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            if (((Boolean)actualState.func_177229_b((Property)EAST)).booleanValue()) {
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_1, Direction.EAST, AABB_CONNECTOR_1_MAP), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_2, Direction.EAST, AABB_CONNECTOR_2_MAP), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_3, Direction.EAST, AABB_CONNECTOR_3_MAP), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_4, Direction.EAST, AABB_CONNECTOR_4_MAP), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            if (((Boolean)actualState.func_177229_b((Property)WEST)).booleanValue()) {
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_1, Direction.WEST, AABB_CONNECTOR_1_MAP), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_2, Direction.WEST, AABB_CONNECTOR_2_MAP), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_3, Direction.WEST, AABB_CONNECTOR_3_MAP), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_4, Direction.WEST, AABB_CONNECTOR_4_MAP), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
        }
        return shape.func_197753_c();
    }

    public AxisAlignedBB translateToAABB(VoxelShape shape) {
        return shape.func_197752_a();
    }

    public VoxelShape rotateWithMap(VoxelShape aabb, Direction facing, Map<Direction, VoxelShape> checkMap) {
        if (checkMap.get(facing) == null) {
            VoxelShape newAABB = BlockRatTube.rotateAABB(aabb, facing);
            checkMap.put(facing, newAABB);
            return newAABB;
        }
        return checkMap.get(facing);
    }

    @Deprecated
    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
    }

    public void updateTick(World worldIn, BlockPos pos, BlockState state, Random rand) {
        for (Direction side : Direction.values()) {
            BooleanProperty changing;
            BlockState sideState = worldIn.func_180495_p(pos.func_177972_a(side));
            switch (side) {
                case NORTH: {
                    changing = OPEN_NORTH;
                    break;
                }
                case SOUTH: {
                    changing = OPEN_SOUTH;
                    break;
                }
                case EAST: {
                    changing = OPEN_EAST;
                    break;
                }
                case WEST: {
                    changing = OPEN_WEST;
                    break;
                }
                case DOWN: {
                    changing = OPEN_DOWN;
                    break;
                }
                default: {
                    changing = OPEN_UP;
                }
            }
            if (!((Boolean)state.func_177229_b((Property)changing)).booleanValue() || this.canBeOpenNextToBlock(worldIn, sideState)) continue;
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)changing, (Comparable)Boolean.valueOf(false)));
            this.updateTEOpening(worldIn, pos, side, false);
        }
    }

    private boolean canBeOpenNextToBlock(World worldIn, BlockState sideState) {
        return !(sideState.func_177230_c() instanceof BlockRatTube);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{NORTH, SOUTH, EAST, WEST, UP, DOWN, OPEN_NORTH, OPEN_SOUTH, OPEN_EAST, OPEN_WEST, OPEN_UP, OPEN_DOWN});
    }

    public BlockState getActualState(BlockState state, IBlockReader iblockreader, BlockPos blockpos) {
        BlockPos blockpos1 = blockpos.func_177978_c();
        BlockPos blockpos2 = blockpos.func_177974_f();
        BlockPos blockpos3 = blockpos.func_177968_d();
        BlockPos blockpos4 = blockpos.func_177976_e();
        BlockPos blockpos5 = blockpos.func_177984_a();
        BlockPos blockpos6 = blockpos.func_177977_b();
        BlockState blockstate = iblockreader.func_180495_p(blockpos1);
        BlockState blockstate1 = iblockreader.func_180495_p(blockpos2);
        BlockState blockstate2 = iblockreader.func_180495_p(blockpos3);
        BlockState blockstate3 = iblockreader.func_180495_p(blockpos4);
        BlockState blockstate4 = iblockreader.func_180495_p(blockpos5);
        BlockState blockstate5 = iblockreader.func_180495_p(blockpos6);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(this.canFenceConnectTo(blockstate, false, Direction.SOUTH)))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(this.canFenceConnectTo(blockstate1, false, Direction.WEST)))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(this.canFenceConnectTo(blockstate2, false, Direction.NORTH)))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(this.canFenceConnectTo(blockstate3, false, Direction.EAST)))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(this.canFenceConnectTo(blockstate4, false, Direction.DOWN)))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(this.canFenceConnectTo(blockstate5, false, Direction.UP)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World iblockreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        FluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        BlockPos blockpos1 = blockpos.func_177978_c();
        BlockPos blockpos2 = blockpos.func_177974_f();
        BlockPos blockpos3 = blockpos.func_177968_d();
        BlockPos blockpos4 = blockpos.func_177976_e();
        BlockPos blockpos5 = blockpos.func_177984_a();
        BlockPos blockpos6 = blockpos.func_177977_b();
        BlockState blockstate = iblockreader.func_180495_p(blockpos1);
        BlockState blockstate1 = iblockreader.func_180495_p(blockpos2);
        BlockState blockstate2 = iblockreader.func_180495_p(blockpos3);
        BlockState blockstate3 = iblockreader.func_180495_p(blockpos4);
        BlockState blockstate4 = iblockreader.func_180495_p(blockpos5);
        BlockState blockstate5 = iblockreader.func_180495_p(blockpos6);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.func_196258_a(context).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(this.canFenceConnectTo(blockstate, false, Direction.SOUTH)))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(this.canFenceConnectTo(blockstate1, false, Direction.WEST)))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(this.canFenceConnectTo(blockstate2, false, Direction.NORTH)))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(this.canFenceConnectTo(blockstate3, false, Direction.EAST)))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(this.canFenceConnectTo(blockstate4, false, Direction.DOWN)))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(this.canFenceConnectTo(blockstate5, false, Direction.UP)));
    }

    private boolean canFenceConnectTo(BlockState p_220111_1_, boolean p_220111_2_, Direction p_220111_3_) {
        return p_220111_1_.func_177230_c() instanceof BlockRatCage || p_220111_1_.func_177230_c() instanceof BlockRatTube;
    }

    public boolean isOpaqueCube(BlockState state) {
        return false;
    }

    public boolean isFullCube(BlockState state) {
        return false;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        BooleanProperty changing;
        if (playerIn.func_225608_bj_() || playerIn.func_184586_b(hand).func_77973_b() instanceof BlockItem || playerIn.func_184586_b(hand).func_77973_b() instanceof ItemRatTube) {
            return ActionResultType.PASS;
        }
        Direction side = hit.func_216354_b();
        BooleanProperty[] allOpenVars = new BooleanProperty[]{OPEN_DOWN, OPEN_EAST, OPEN_NORTH, OPEN_SOUTH, OPEN_UP, OPEN_WEST};
        switch (side) {
            case NORTH: {
                changing = OPEN_NORTH;
                break;
            }
            case SOUTH: {
                changing = OPEN_SOUTH;
                break;
            }
            case EAST: {
                changing = OPEN_EAST;
                break;
            }
            case WEST: {
                changing = OPEN_WEST;
                break;
            }
            case DOWN: {
                changing = OPEN_DOWN;
                break;
            }
            default: {
                changing = OPEN_UP;
            }
        }
        boolean alreadyOpened = false;
        for (BooleanProperty opened : allOpenVars) {
            if (!((Boolean)state.func_177229_b((Property)opened)).booleanValue()) continue;
            alreadyOpened = true;
        }
        if (!alreadyOpened && this.canBeOpenNextToBlock(worldIn, worldIn.func_180495_p(pos.func_177972_a(side)))) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)changing, (Comparable)Boolean.valueOf(true)));
            this.updateTEOpening(worldIn, pos, side, true);
        } else {
            worldIn.func_175656_a(pos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)OPEN_NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)OPEN_EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)OPEN_SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)OPEN_WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)OPEN_UP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)OPEN_DOWN, (Comparable)Boolean.valueOf(false)));
            this.updateTEOpening(worldIn, pos, side, false);
        }
        return ActionResultType.SUCCESS;
    }

    private void updateTEOpening(World world, BlockPos pos, Direction side, boolean open) {
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileEntityRatTube) {
            TileEntityRatTube te = (TileEntityRatTube)world.func_175625_s(pos);
            te.setEntranceData(side, open);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (worldIn.func_175625_s(pos) != null && worldIn.func_175625_s(pos) instanceof TileEntityRatTube) {
            TileEntityRatTube te = (TileEntityRatTube)worldIn.func_175625_s(pos);
            te.setColor(this.getColorFromStack(stack));
        }
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return BlockRatTube.getTubeItem(worldIn, pos);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityRatTube && !player.func_184812_l_()) {
            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)BlockRatTube.getTubeItem((IBlockReader)worldIn, pos));
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    private static ItemStack getTubeItem(IBlockReader worldIn, BlockPos pos) {
        int color = 0;
        if (worldIn.func_175625_s(pos) != null && worldIn.func_175625_s(pos) instanceof TileEntityRatTube) {
            TileEntityRatTube te = (TileEntityRatTube)worldIn.func_175625_s(pos);
            color = te.getColor();
        }
        Item item = RatsItemRegistry.RAT_TUBES[MathHelper.func_76125_a((int)color, (int)0, (int)15)];
        return new ItemStack((IItemProvider)item);
    }

    private int getColorFromStack(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemRatTube) {
            return ((ItemRatTube)stack.func_77973_b()).color.ordinal();
        }
        return 0;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityRatTube();
    }

    public static boolean isOpenInDirection(BlockState state, Direction facing) {
        BooleanProperty notOpen = null;
        BooleanProperty connect = null;
        switch (facing) {
            case NORTH: {
                notOpen = OPEN_NORTH;
                connect = NORTH;
                break;
            }
            case SOUTH: {
                notOpen = OPEN_SOUTH;
                connect = SOUTH;
                break;
            }
            case EAST: {
                notOpen = OPEN_EAST;
                connect = EAST;
                break;
            }
            case WEST: {
                notOpen = OPEN_WEST;
                connect = WEST;
                break;
            }
            case DOWN: {
                notOpen = OPEN_DOWN;
                connect = DOWN;
                break;
            }
            default: {
                notOpen = OPEN_UP;
                connect = UP;
            }
        }
        return (Boolean)state.func_177229_b((Property)notOpen);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        BooleanProperty notOpen = null;
        BooleanProperty connect = null;
        switch (facing) {
            case NORTH: {
                notOpen = OPEN_NORTH;
                connect = NORTH;
                break;
            }
            case SOUTH: {
                notOpen = OPEN_SOUTH;
                connect = SOUTH;
                break;
            }
            case EAST: {
                notOpen = OPEN_EAST;
                connect = EAST;
                break;
            }
            case WEST: {
                notOpen = OPEN_WEST;
                connect = WEST;
                break;
            }
            case DOWN: {
                notOpen = OPEN_DOWN;
                connect = DOWN;
                break;
            }
            default: {
                notOpen = OPEN_UP;
                connect = UP;
            }
        }
        BlockState newState = stateIn;
        newState = (BlockState)newState.func_206870_a((Property)connect, (Comparable)Boolean.valueOf(this.canFenceConnectTo(facingState, false, facing.func_176734_d())));
        newState = (BlockState)newState.func_206870_a((Property)notOpen, (Comparable)Boolean.valueOf(false));
        return newState;
    }
}

