/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.blocks;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.blocks.IUsesTEISR;
import com.github.alexthe666.rats.server.blocks.RatlantisBlockRegistry;
import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatlantisPortal;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockRatlantisPortal
extends ContainerBlock
implements IUsesTEISR {
    protected BlockRatlantisPortal() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151567_E).func_200947_a(SoundType.field_185849_b).func_200943_b(-1.0f).func_235838_a_(p -> 15).func_200942_a());
        this.setRegistryName("rats", "ratlantis_portal");
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public RegistryKey<World> getRatlantisDimension() {
        ResourceLocation resourcelocation = new ResourceLocation("rats:ratlantis");
        RegistryKey registrykey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)resourcelocation);
        return registrykey;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entity) {
        if (RatsMod.RATLANTIS_LOADED && !worldIn.field_72995_K) {
            MinecraftServer server = worldIn.func_73046_m();
            if (!entity.func_184207_aI() && entity.func_184188_bt().isEmpty()) {
                boolean inOverworld;
                boolean bl = inOverworld = entity.field_70170_p.func_234923_W_() != this.getRatlantisDimension();
                if (entity instanceof ServerPlayerEntity) {
                    ServerPlayerEntity thePlayer = (ServerPlayerEntity)entity;
                    if (inOverworld) {
                        ServerWorld dimWorld = server.func_71218_a(this.getRatlantisDimension());
                        if (dimWorld != null) {
                            this.teleportEntity((Entity)thePlayer, dimWorld, pos, true);
                        }
                    } else {
                        ServerWorld dimWorld = server.func_71218_a(World.field_234918_g_);
                        if (dimWorld != null) {
                            this.teleportEntity((Entity)thePlayer, dimWorld, pos, false);
                        }
                    }
                }
                if (!(entity instanceof PlayerEntity)) {
                    ServerWorld dimWorld;
                    if (inOverworld) {
                        dimWorld = server.func_71218_a(this.getRatlantisDimension());
                        if (dimWorld != null) {
                            this.teleportEntity(entity, dimWorld, pos, true);
                        }
                    } else {
                        dimWorld = server.func_71218_a(World.field_234918_g_);
                        if (dimWorld != null) {
                            this.teleportEntity(entity, dimWorld, pos, false);
                        }
                    }
                }
            }
        }
    }

    private Entity teleportEntity(Entity entity, ServerWorld endpointWorld, BlockPos endpoint, boolean ratlantis) {
        if (ratlantis) {
            this.placeInPortal(entity, endpointWorld);
        }
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            player.func_200619_a(endpointWorld, (double)endpoint.func_177958_n() + 0.5, (double)endpoint.func_177956_o() + 0.5, (double)endpoint.func_177952_p() + 0.5, entity.field_70177_z, entity.field_70125_A);
            return player;
        }
        entity.func_213319_R();
        entity.func_70029_a((World)endpointWorld);
        Entity teleportedEntity = entity.func_200600_R().func_200721_a((World)endpointWorld);
        if (teleportedEntity == null) {
            return entity;
        }
        teleportedEntity.func_180432_n(entity);
        teleportedEntity.func_70012_b((double)endpoint.func_177958_n() + 0.5, (double)endpoint.func_177956_o() + 0.5, (double)endpoint.func_177952_p() + 0.5, entity.field_70177_z, entity.field_70125_A);
        teleportedEntity.func_70034_d(entity.field_70177_z);
        endpointWorld.func_217460_e(teleportedEntity);
        return teleportedEntity;
    }

    public void placeInPortal(Entity entity, ServerWorld serverWorld) {
        entity.func_213293_j(0.0, 0.0, 0.0);
        BlockPos portalBottom = new BlockPos(entity.func_213303_ch()).func_177982_a(1, -1, 1);
        for (int i = -1; i <= 1; ++i) {
            for (int j = 0; j <= 3; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    serverWorld.func_175656_a(portalBottom.func_177982_a(i, j, k), Blocks.field_150350_a.func_176223_P());
                }
            }
        }
        for (BlockPos pos : BlockPos.func_218281_b((BlockPos)portalBottom.func_177982_a(-2, 0, -2), (BlockPos)portalBottom.func_177982_a(2, 0, 2)).map(BlockPos::func_185334_h).collect(Collectors.toList())) {
            serverWorld.func_175656_a(pos, RatlantisBlockRegistry.MARBLED_CHEESE_TILE.func_176223_P());
            serverWorld.func_175656_a(pos.func_177981_b(4), RatlantisBlockRegistry.MARBLED_CHEESE_TILE.func_176223_P());
        }
        for (int i = 1; i < 4; ++i) {
            serverWorld.func_175656_a(portalBottom.func_177982_a(2, 0, 2).func_177981_b(i), (BlockState)RatlantisBlockRegistry.MARBLED_CHEESE_PILLAR.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y));
            serverWorld.func_175656_a(portalBottom.func_177982_a(2, 0, -2).func_177981_b(i), (BlockState)RatlantisBlockRegistry.MARBLED_CHEESE_PILLAR.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y));
            serverWorld.func_175656_a(portalBottom.func_177982_a(-2, 0, 2).func_177981_b(i), (BlockState)RatlantisBlockRegistry.MARBLED_CHEESE_PILLAR.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y));
            serverWorld.func_175656_a(portalBottom.func_177982_a(-2, 0, -2).func_177981_b(i), (BlockState)RatlantisBlockRegistry.MARBLED_CHEESE_PILLAR.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y));
        }
        serverWorld.func_175656_a(portalBottom, RatsBlockRegistry.MARBLED_CHEESE_RAW.func_176223_P());
        serverWorld.func_175656_a(portalBottom.func_177984_a(), RatlantisBlockRegistry.RATLANTIS_PORTAL.func_176223_P());
        serverWorld.func_175656_a(portalBottom.func_177981_b(2), RatlantisBlockRegistry.RATLANTIS_PORTAL.func_176223_P());
        serverWorld.func_175656_a(portalBottom.func_177981_b(3), RatsBlockRegistry.MARBLED_CHEESE_RAW.func_176223_P());
    }

    public void updateTick(World worldIn, BlockPos pos, BlockState state, Random rand) {
        if (!this.canSurviveAt(worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!this.canSurviveAt(worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public boolean canSurviveAt(World world, BlockPos pos) {
        return !(world.func_180495_p(pos.func_177984_a()).func_177230_c() != RatlantisBlockRegistry.RATLANTIS_PORTAL && world.func_180495_p(pos.func_177984_a()).func_177230_c() != RatsBlockRegistry.MARBLED_CHEESE_RAW || world.func_180495_p(pos.func_177977_b()).func_177230_c() != RatlantisBlockRegistry.RATLANTIS_PORTAL && world.func_180495_p(pos.func_177977_b()).func_177230_c() != RatsBlockRegistry.MARBLED_CHEESE_RAW);
    }

    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        Block block = adjacentBlockState.func_177230_c();
        return block != RatlantisBlockRegistry.RATLANTIS_PORTAL;
    }

    public boolean isOpaqueCube(BlockState state) {
        return false;
    }

    public boolean isFullCube(BlockState state) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityRatlantisPortal) {
            int i = 4;
            for (int j = 0; j < i; ++j) {
                double d0 = (float)pos.func_177958_n() + rand.nextFloat();
                double d1 = (float)pos.func_177956_o() + rand.nextFloat();
                double d2 = (float)pos.func_177952_p() + rand.nextFloat();
                double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
                double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
                double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
                int k = rand.nextInt(2) * 2 - 1;
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197624_q, d0, d1, d2, d3, d4, d5);
            }
        }
    }

    public ItemStack getItem(World worldIn, BlockPos pos, BlockState state) {
        return ItemStack.field_190927_a;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityRatlantisPortal();
    }
}

