/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.blocks;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.blocks.BlockAutoCurdler;
import com.github.alexthe666.rats.server.blocks.BlockCheese;
import com.github.alexthe666.rats.server.blocks.BlockCheeseCauldron;
import com.github.alexthe666.rats.server.blocks.BlockCursedGarbage;
import com.github.alexthe666.rats.server.blocks.BlockDyeSponge;
import com.github.alexthe666.rats.server.blocks.BlockGarbage;
import com.github.alexthe666.rats.server.blocks.BlockGeneric;
import com.github.alexthe666.rats.server.blocks.BlockGenericFacing;
import com.github.alexthe666.rats.server.blocks.BlockGenericTrapDoor;
import com.github.alexthe666.rats.server.blocks.BlockJackORatern;
import com.github.alexthe666.rats.server.blocks.BlockMilkCauldron;
import com.github.alexthe666.rats.server.blocks.BlockPiedGarbage;
import com.github.alexthe666.rats.server.blocks.BlockPurifiedGarbage;
import com.github.alexthe666.rats.server.blocks.BlockRatAttractor;
import com.github.alexthe666.rats.server.blocks.BlockRatCage;
import com.github.alexthe666.rats.server.blocks.BlockRatCageBreedingLantern;
import com.github.alexthe666.rats.server.blocks.BlockRatCageDecorated;
import com.github.alexthe666.rats.server.blocks.BlockRatCageWheel;
import com.github.alexthe666.rats.server.blocks.BlockRatCraftingTable;
import com.github.alexthe666.rats.server.blocks.BlockRatHole;
import com.github.alexthe666.rats.server.blocks.BlockRatQuarry;
import com.github.alexthe666.rats.server.blocks.BlockRatQuarryPlatform;
import com.github.alexthe666.rats.server.blocks.BlockRatTrap;
import com.github.alexthe666.rats.server.blocks.BlockRatTube;
import com.github.alexthe666.rats.server.blocks.BlockRatUpgrade;
import com.github.alexthe666.rats.server.blocks.BlockTrashCan;
import com.github.alexthe666.rats.server.blocks.BlockUpgradeCombiner;
import com.github.alexthe666.rats.server.blocks.BlockUpgradeSeparator;
import com.github.alexthe666.rats.server.blocks.INoTab;
import com.github.alexthe666.rats.server.blocks.IUsesTEISR;
import com.github.alexthe666.rats.server.blocks.IWearableBlock;
import com.github.alexthe666.rats.server.blocks.RatlantisBlockRegistry;
import com.github.alexthe666.rats.server.entity.tile.RatlantisTileEntityRegistry;
import com.github.alexthe666.rats.server.entity.tile.RatsTileEntityRegistry;
import com.github.alexthe666.rats.server.items.ItemBlockWearable;
import java.lang.reflect.Field;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="rats", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RatsBlockRegistry {
    public static final Block BLOCK_OF_CHEESE = new BlockCheese();
    public static final Block MILK_CAULDRON = new BlockMilkCauldron();
    public static final Block CHEESE_CAULDRON = new BlockCheeseCauldron();
    public static final Block RAT_HOLE = new BlockRatHole();
    public static final Block RAT_CAGE = new BlockRatCage("rat_cage");
    public static final Block RAT_CAGE_DECORATED = new BlockRatCageDecorated();
    public static final Block RAT_CAGE_BREEDING_LANTERN = new BlockRatCageBreedingLantern();
    public static final Block RAT_CAGE_WHEEL = new BlockRatCageWheel();
    public static final Block FISH_BARREL = new BlockGenericFacing("fish_barrel", Material.field_151575_d, 2.0f, 10.0f, SoundType.field_185848_a);
    public static final Block RAT_CRAFTING_TABLE = new BlockRatCraftingTable();
    public static final Block AUTO_CURDLER = new BlockAutoCurdler();
    public static final Block RAT_TRAP = new BlockRatTrap();
    public static final Block RAT_TUBE_COLOR = new BlockRatTube();
    public static final Block RAT_UPGRADE_BLOCK = new BlockRatUpgrade();
    public static final Block DYE_SPONGE = new BlockDyeSponge();
    public static final Block GARBAGE_PILE = new BlockGarbage("garbage_pile", 1.0);
    public static final Block CURSED_GARBAGE = new BlockCursedGarbage();
    public static final Block COMPRESSED_GARBAGE = new BlockGarbage("compressed_garbage", 2.0);
    public static final Block PURIFIED_GARBAGE = new BlockPurifiedGarbage();
    public static final Block PIED_GARBAGE = new BlockPiedGarbage();
    public static final Block MARBLED_CHEESE_RAW = new BlockGeneric("marbled_cheese_raw", Material.field_151576_e, 2.0f, 10.0f, SoundType.field_185851_d);
    public static final Block JACK_O_RATERN = new BlockJackORatern();
    public static final Block BLOCK_OF_BLUE_CHEESE = new BlockGeneric("block_of_blue_cheese", Material.field_151580_n, 2.0f, 0.0f, SoundType.field_185859_l);
    public static final Block PIED_WOOL = new BlockGeneric("pied_wool", Material.field_151580_n, 1.0f, 0.0f, SoundType.field_185854_g);
    public static final Block UPGRADE_COMBINER = new BlockUpgradeCombiner();
    public static final Block UPGRADE_SEPARATOR = new BlockUpgradeSeparator();
    public static final Block MANHOLE = (Block)new BlockGenericTrapDoor(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_193573_Y).func_200943_b(10.0f).func_200947_a(SoundType.field_185858_k).func_226896_b_().func_208770_d()).setRegistryName("rats:manhole");
    public static final Block TRASH_CAN = new BlockTrashCan();
    public static final Block RAT_ATTRACTOR = new BlockRatAttractor();
    public static final Block RAT_QUARRY = new BlockRatQuarry();
    public static final Block RAT_QUARRY_PLATFORM = new BlockRatQuarryPlatform();

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        Object obj;
        try {
            for (Field f : RatsBlockRegistry.class.getDeclaredFields()) {
                obj = f.get(null);
                if (obj instanceof Block) {
                    event.getRegistry().register((IForgeRegistryEntry)((Block)obj));
                    continue;
                }
                if (!(obj instanceof Block[])) continue;
                for (Block block : (Block[])obj) {
                    event.getRegistry().register((IForgeRegistryEntry)block);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (RatsMod.RATLANTIS_LOADED) {
            try {
                for (Field f : RatlantisBlockRegistry.class.getDeclaredFields()) {
                    obj = f.get(null);
                    if (obj instanceof Block) {
                        event.getRegistry().register((IForgeRegistryEntry)((Block)obj));
                        continue;
                    }
                    if (!(obj instanceof Block[])) continue;
                    for (Block block : (Block[])obj) {
                        event.getRegistry().register((IForgeRegistryEntry)block);
                    }
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @SubscribeEvent
    public static void registerBlockItems(RegistryEvent.Register<Item> event) {
        BlockItem blockItem;
        Item.Properties props;
        Object obj;
        try {
            for (Field f : RatsBlockRegistry.class.getDeclaredFields()) {
                Item.Properties props2;
                obj = f.get(null);
                if (obj instanceof Block) {
                    props2 = new Item.Properties();
                    if (!(obj instanceof INoTab)) {
                        props2.func_200916_a(RatsMod.TAB);
                    }
                    if (obj instanceof IUsesTEISR) {
                        props2 = RatsMod.PROXY.setupTEISR(props2);
                    }
                    BlockItem blockItem2 = new BlockItem((Block)obj, props2);
                    if (obj instanceof IWearableBlock) {
                        blockItem2 = new ItemBlockWearable((Block)obj, props2);
                    }
                    blockItem2.setRegistryName(((Block)obj).getRegistryName());
                    event.getRegistry().register((IForgeRegistryEntry)blockItem2);
                    continue;
                }
                if (!(obj instanceof Block[])) continue;
                props2 = (Item.Properties)obj;
                int blockItem2 = ((Block[])props2).length;
                for (int i = 0; i < blockItem2; ++i) {
                    Item.Properties properties = props2[i];
                    props = new Item.Properties();
                    if (!(properties instanceof INoTab)) {
                        props.func_200916_a(RatsMod.TAB);
                    }
                    if (properties instanceof IUsesTEISR) {
                        RatsMod.PROXY.setupTEISR(props);
                    }
                    blockItem = new BlockItem((Block)properties, props);
                    blockItem.setRegistryName(properties.getRegistryName());
                    event.getRegistry().register((IForgeRegistryEntry)blockItem);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (RatsMod.RATLANTIS_LOADED) {
            try {
                for (Field f : RatlantisBlockRegistry.class.getDeclaredFields()) {
                    obj = f.get(null);
                    if (obj instanceof Block) {
                        Item.Properties props2 = new Item.Properties();
                        if (!(obj instanceof INoTab)) {
                            props2.func_200916_a(RatsMod.getRatlantisTab());
                        }
                        if (obj instanceof IUsesTEISR) {
                            props2 = RatsMod.PROXY.setupTEISR(props2);
                        }
                        BlockItem blockItem3 = new BlockItem((Block)obj, props2);
                        if (obj instanceof IWearableBlock) {
                            blockItem3 = new ItemBlockWearable((Block)obj, props2);
                        }
                        blockItem3.setRegistryName(((Block)obj).getRegistryName());
                        event.getRegistry().register((IForgeRegistryEntry)blockItem3);
                        continue;
                    }
                    if (!(obj instanceof Block[])) continue;
                    for (Block block : (Block[])obj) {
                        props = new Item.Properties();
                        if (!(block instanceof INoTab)) {
                            props.func_200916_a(RatsMod.getRatlantisTab());
                        }
                        if (block instanceof IUsesTEISR) {
                            RatsMod.PROXY.setupTEISR(props);
                        }
                        blockItem = new BlockItem(block, props);
                        blockItem.setRegistryName(block.getRegistryName());
                        event.getRegistry().register((IForgeRegistryEntry)blockItem);
                    }
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @SubscribeEvent
    public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        Object obj;
        try {
            for (Field f : RatsTileEntityRegistry.class.getDeclaredFields()) {
                obj = f.get(null);
                if (obj instanceof TileEntityType) {
                    event.getRegistry().register((IForgeRegistryEntry)((TileEntityType)obj));
                    continue;
                }
                if (!(obj instanceof TileEntityType[])) continue;
                for (TileEntityType te : (TileEntityType[])obj) {
                    event.getRegistry().register((IForgeRegistryEntry)te);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (RatsMod.RATLANTIS_LOADED) {
            try {
                for (Field f : RatlantisTileEntityRegistry.class.getDeclaredFields()) {
                    obj = f.get(null);
                    if (obj instanceof TileEntityType) {
                        event.getRegistry().register((IForgeRegistryEntry)((TileEntityType)obj));
                        continue;
                    }
                    if (!(obj instanceof TileEntityType[])) continue;
                    for (TileEntityType te : (TileEntityType[])obj) {
                        event.getRegistry().register((IForgeRegistryEntry)te);
                    }
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

