/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.ai.RatAIEnterTrap;
import com.github.alexthe666.rats.server.entity.ai.RatAIFleeSun;
import com.github.alexthe666.rats.server.entity.ai.RatAIHurtByTarget;
import com.github.alexthe666.rats.server.entity.ai.RatAISit;
import com.github.alexthe666.rats.server.entity.ai.RatAIWander;
import com.github.alexthe666.rats.server.entity.ai.navigation.RatPathPathNavigateGround;
import com.github.alexthe666.rats.server.entity.ratlantis.IPirat;
import com.github.alexthe666.rats.server.entity.ratlantis.IRatlantean;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class EntityDemonRat
extends EntityRat
implements IPirat,
IRatlantean {
    public EntityDemonRat(EntityType type, World worldIn) {
        super((EntityType<? extends EntityRat>)type, worldIn);
        this.field_70728_aV = 5;
        this.func_184644_a(PathNodeType.DANGER_FIRE, 16.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, -1.0f);
    }

    public boolean func_70631_g_() {
        return false;
    }

    public static AttributeModifierMap.MutableAttribute func_234290_eH_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.35).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233819_b_, 48.0);
    }

    public static boolean canDemonRatSpawnOn(EntityType<? extends MobEntity> typeIn, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        BlockPos blockpos = pos.func_177977_b();
        return reason == SpawnReason.SPAWNER || worldIn.func_180495_p(blockpos).func_215688_a((IBlockReader)worldIn, blockpos, typeIn) && randomIn.nextInt(200) == 0;
    }

    @Override
    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return true;
    }

    @Override
    public boolean func_180431_b(DamageSource source) {
        if (source.func_76347_k() || source == DamageSource.field_76371_c) {
            return true;
        }
        return super.func_180431_b(source);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (this.field_70146_Z.nextInt(3) == 0) {
            entityIn.func_70015_d(5);
        }
        return super.func_70652_k(entityIn);
    }

    public static boolean canSpawn(EntityType<? extends MobEntity> entityType, IWorld p_234351_1_, SpawnReason reason, BlockPos p_234351_3_, Random rand) {
        return p_234351_1_.func_175659_aa() != Difficulty.PEACEFUL && p_234351_1_.func_180495_p(p_234351_3_.func_177977_b()).func_177230_c() != Blocks.field_189878_dg;
    }

    private static boolean canSpawnAtPos(IWorld world, BlockPos pos) {
        BlockState down = world.func_180495_p(pos.func_177977_b());
        return !down.func_203425_a(Blocks.field_189878_dg);
    }

    @Override
    public boolean shouldEyesGlow() {
        return true;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.45, false));
        this.field_70714_bg.func_75776_a(2, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new RatAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new RatAIFleeSun(this, 1.66));
        this.field_70714_bg.func_75776_a(3, (Goal)new RatAISit(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new RatAIEnterTrap(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 5, true, false, (Predicate)new com.google.common.base.Predicate<LivingEntity>(){

            public boolean apply(@Nullable LivingEntity entity) {
                return entity instanceof PlayerEntity && !((PlayerEntity)entity).func_184812_l_() || entity instanceof AbstractVillagerEntity;
            }
        }));
        this.field_70715_bh.func_75776_a(2, (Goal)new RatAIHurtByTarget(this, new Class[0]));
    }

    @Override
    public boolean canDigHoles() {
        return false;
    }

    @Override
    protected void switchNavigator(int type) {
        this.field_70765_h = new MovementController((MobEntity)this);
        this.field_70699_by = new RatPathPathNavigateGround(this, this.field_70170_p);
        this.navigatorType = 1;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K && this.field_70146_Z.nextFloat() < 0.5f) {
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_(), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d1, d2);
        }
    }

    public double func_70033_W() {
        return 0.45;
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setMale(this.func_70681_au().nextBoolean());
        this.setPlague(false);
        this.setToga(false);
        return spawnDataIn;
    }

    @Override
    public boolean hasPlague() {
        return false;
    }

    @Override
    public boolean canBeTamed() {
        return false;
    }

    public boolean func_70909_n() {
        return false;
    }

    @Override
    public boolean shouldHuntAnimal() {
        return true;
    }
}

