/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.EntityBlackDeath;
import com.github.alexthe666.rats.server.entity.IPlagueLegion;
import com.github.alexthe666.rats.server.entity.ai.BlackDeathAITargetNonPlagued;
import com.github.alexthe666.rats.server.entity.ratlantis.EntityFeralRatlantean;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class EntityPlagueBeast
extends EntityFeralRatlantean
implements IPlagueLegion {
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityPlagueBeast.class, (IDataSerializer)DataSerializers.field_187203_m);

    public EntityPlagueBeast(EntityType type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new BlackDeathAITargetNonPlagued((CreatureEntity)this, LivingEntity.class, false));
    }

    public static AttributeModifierMap.MutableAttribute func_234290_eH_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233821_d_, 0.5).func_233815_a_(Attributes.field_233823_f_, 5.0).func_233815_a_(Attributes.field_233819_b_, 64.0).func_233815_a_(Attributes.field_233826_i_, 4.0);
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        if (potioneffectIn.func_188419_a() == RatsMod.PLAGUE_POTION) {
            return false;
        }
        return super.func_70687_e(potioneffectIn);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        double d0 = 0.0;
        double d1 = this.field_70146_Z.nextGaussian() * 0.05 + 0.5;
        double d2 = 0.0;
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d1, d2);
        if (this.getOwnerId() != null && this.getOwner() != null && this.getOwner() instanceof EntityBlackDeath) {
            EntityBlackDeath death = (EntityBlackDeath)this.getOwner();
            if (death.func_70638_az() != null && death.func_70638_az().func_70089_S()) {
                this.func_70624_b(death.func_70638_az());
            } else {
                float radius = 8.0f - (float)Math.sin((double)death.field_70173_aa * 0.4) * 0.5f;
                int maxRatStuff = 360 / Math.max(death.getBeastsSummoned(), 1);
                int ratIndex = this.func_145782_y() % Math.max(death.getBeastsSummoned(), 1);
                float angle = (float)Math.PI / 180 * ((float)(ratIndex * maxRatStuff) + (float)this.field_70173_aa * 4.1f);
                double extraX = (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))) + death.func_226277_ct_();
                double extraZ = (double)(radius * MathHelper.func_76134_b((float)angle)) + death.func_226281_cx_();
                BlockPos runToPos = new BlockPos(extraX, death.func_226278_cu_(), extraZ);
                for (int steps = 0; this.field_70170_p.func_180495_p(runToPos).func_200015_d((IBlockReader)this.field_70170_p, runToPos) && steps < 10; ++steps) {
                    runToPos = runToPos.func_177984_a();
                }
                this.func_70661_as().func_75492_a(extraX, (double)runToPos.func_177956_o(), extraZ, 1.0);
            }
        }
        if (this.func_70638_az() != null && !this.func_70638_az().func_70089_S()) {
            this.func_70624_b(null);
        }
    }

    public void func_70106_y() {
        if (this.func_70089_S() && this.getOwnerId() != null && this.getOwner() != null && this.getOwner() instanceof EntityBlackDeath) {
            EntityBlackDeath illagerPiper = (EntityBlackDeath)this.getOwner();
            illagerPiper.setBeastsSummoned(illagerPiper.getBeastsSummoned() - 1);
        }
        super.func_70106_y();
    }

    @Override
    public boolean doExtraEffect(LivingEntity target) {
        target.func_195064_c(new EffectInstance(RatsMod.PLAGUE_POTION, 1200, 0));
        return true;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, Optional.empty());
    }

    @Override
    public boolean hasToga() {
        return false;
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.getOwnerId() == null) {
            compound.func_74778_a("OwnerUUID", "");
        } else {
            compound.func_74778_a("OwnerUUID", this.getOwnerId().toString());
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        String s;
        super.func_70037_a(compound);
        if (compound.func_150297_b("OwnerUUID", 8)) {
            s = compound.func_74779_i("OwnerUUID");
        } else {
            String s1 = compound.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1).toString();
        }
        if (!s.isEmpty()) {
            try {
                this.setOwnerId(UUID.fromString(s));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public UUID getOwnerId() {
        return ((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    public LivingEntity getOwner() {
        try {
            Entity entity;
            PlayerEntity player;
            UUID uuid = this.getOwnerId();
            PlayerEntity playerEntity = player = uuid == null ? null : this.field_70170_p.func_217371_b(uuid);
            if (player != null) {
                return player;
            }
            if (!this.field_70170_p.field_72995_K && (entity = this.field_70170_p.func_73046_m().func_71218_a(this.field_70170_p.func_234923_W_()).func_217461_a(uuid)) instanceof LivingEntity) {
                return (LivingEntity)entity;
            }
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
        return null;
    }

    public boolean func_184191_r(Entity entityIn) {
        return super.func_184191_r(entityIn) || entityIn instanceof IPlagueLegion;
    }
}

