/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.EntityBlackDeath;
import com.github.alexthe666.rats.server.entity.IPlagueLegion;
import com.github.alexthe666.rats.server.entity.ai.BlackDeathAITargetNonPlagued;
import com.github.alexthe666.rats.server.misc.RatsSoundRegistry;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class EntityPlagueCloud
extends MonsterEntity
implements IPlagueLegion {
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityPlagueCloud.class, (IDataSerializer)DataSerializers.field_187203_m);

    public EntityPlagueCloud(EntityType type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new AIMoveControl(this);
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        if (potioneffectIn.func_188419_a() == RatsMod.PLAGUE_POTION) {
            return false;
        }
        return super.func_70687_e(potioneffectIn);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187945_hs;
    }

    protected SoundEvent func_184615_bR() {
        return RatsSoundRegistry.RATLANTEAN_SPIRIT_DIE;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.func_189654_d(true);
        double d0 = this.field_70737_aN > 0 ? 1.0 : 0.0;
        double d1 = 0.01;
        double d2 = 0.0;
        double x = this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf();
        double y = this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()) - (double)this.func_213302_cg();
        double z = this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf();
        float f = (this.func_213311_cf() + this.func_213302_cg() + this.func_213311_cf()) * 0.333f + 0.5f;
        if (this.particleDistSq(x, y, z) < (double)(f * f)) {
            if (this.field_70146_Z.nextBoolean()) {
                RatsMod.PROXY.addParticle("black_death", x, y + 1.5, z, d0, d1, d2);
            } else {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, x, y + 1.5, z, d0, d1, d2);
            }
        }
        if (this.getOwnerId() != null && this.getOwner() != null && this.getOwner() instanceof EntityBlackDeath) {
            EntityBlackDeath death = (EntityBlackDeath)this.getOwner();
            if (death.func_70638_az() != null && death.func_70638_az().func_70089_S()) {
                this.func_70624_b(death.func_70638_az());
            } else {
                float radius = 9.0f - (float)Math.sin((double)death.field_70173_aa * 0.4) * 0.25f;
                int maxRatStuff = 360 / Math.max(death.getCloudsSummoned(), 1);
                int ratIndex = this.func_145782_y() % Math.max(death.getCloudsSummoned(), 1);
                float angle = (float)Math.PI / 180 * ((float)(ratIndex * maxRatStuff) + (float)this.field_70173_aa * 4.1f);
                double extraX = (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))) + death.func_226277_ct_();
                double extraZ = (double)(radius * MathHelper.func_76134_b((float)angle)) + death.func_226281_cx_();
                this.field_70765_h.func_75642_a(extraX, death.func_226278_cu_() + 2.0 + (double)this.field_70146_Z.nextInt(2), extraZ, 1.0);
            }
        }
        if (this.func_70638_az() != null && !this.func_70638_az().func_70089_S()) {
            this.func_70624_b(null);
        }
    }

    public static AttributeModifierMap.MutableAttribute func_234290_eH_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233819_b_, 32.0);
    }

    public void func_70106_y() {
        if (!this.func_70089_S() && this.getOwnerId() != null && this.getOwner() != null && this.getOwner() instanceof EntityBlackDeath) {
            EntityBlackDeath illagerPiper = (EntityBlackDeath)this.getOwner();
            illagerPiper.setCloudsSummoned(illagerPiper.getCloudsSummoned() - 1);
        }
        super.func_70106_y();
    }

    public double particleDistSq(double toX, double toY, double toZ) {
        double d0 = this.func_226277_ct_() - toX;
        double d1 = this.func_226278_cu_() - toY;
        double d2 = this.func_226281_cx_() - toZ;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, Optional.empty());
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AIMeleeAttack(this));
        this.field_70714_bg.func_75776_a(8, (Goal)new AIMoveRandom());
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new BlackDeathAITargetNonPlagued((CreatureEntity)this, LivingEntity.class, false));
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag && entityIn instanceof LivingEntity) {
            ((LivingEntity)entityIn).func_195064_c(new EffectInstance(RatsMod.PLAGUE_POTION, 600, 0));
        }
        return flag;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void fall(float distance, float damageMultiplier) {
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.getOwnerId() == null) {
            compound.func_74778_a("OwnerUUID", "");
        } else {
            compound.func_74778_a("OwnerUUID", this.getOwnerId().toString());
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        String s;
        super.func_70037_a(compound);
        if (compound.func_150297_b("OwnerUUID", 8)) {
            s = compound.func_74779_i("OwnerUUID");
        } else {
            String s1 = compound.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1).toString();
        }
        if (!s.isEmpty()) {
            try {
                this.setOwnerId(UUID.fromString(s));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public UUID getOwnerId() {
        return ((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    public LivingEntity getOwner() {
        try {
            Entity entity;
            PlayerEntity player;
            UUID uuid = this.getOwnerId();
            PlayerEntity playerEntity = player = uuid == null ? null : this.field_70170_p.func_217371_b(uuid);
            if (player != null) {
                return player;
            }
            if (!this.field_70170_p.field_72995_K && (entity = this.field_70170_p.func_73046_m().func_71218_a(this.field_70170_p.func_234923_W_()).func_217461_a(uuid)) instanceof LivingEntity) {
                return (LivingEntity)entity;
            }
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
        return null;
    }

    public boolean func_184191_r(Entity entityIn) {
        return super.func_184191_r(entityIn) || entityIn instanceof IPlagueLegion;
    }

    class AIMeleeAttack
    extends Goal {
        private final EntityPlagueCloud parentEntity;
        public int attackTimer;

        public AIMeleeAttack(EntityPlagueCloud ghast) {
            this.parentEntity = ghast;
        }

        public boolean func_75250_a() {
            return this.parentEntity.func_70638_az() != null;
        }

        public void func_75249_e() {
            this.attackTimer = 0;
        }

        public void func_75251_c() {
        }

        public void func_75246_d() {
            LivingEntity LivingEntity2 = this.parentEntity.func_70638_az();
            double d0 = 64.0;
            if (LivingEntity2.func_70068_e((Entity)this.parentEntity) >= 2.0 || !this.parentEntity.func_70685_l((Entity)LivingEntity2)) {
                EntityPlagueCloud.this.field_70765_h.func_75642_a(LivingEntity2.func_226277_ct_(), LivingEntity2.func_226278_cu_() + 1.0, LivingEntity2.func_226281_cx_(), 0.5);
            }
            if (LivingEntity2.func_70068_e((Entity)this.parentEntity) < 5.0) {
                World world = this.parentEntity.field_70170_p;
                ++this.attackTimer;
                if (this.attackTimer == 5) {
                    this.parentEntity.func_70652_k((Entity)LivingEntity2);
                    this.attackTimer = -10;
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
        }
    }

    class AIMoveRandom
    extends Goal {
        public AIMoveRandom() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return !EntityPlagueCloud.this.field_70765_h.func_75640_a() && EntityPlagueCloud.this.field_70146_Z.nextInt(2) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = new BlockPos(EntityPlagueCloud.this.func_213303_ch());
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(EntityPlagueCloud.this.field_70146_Z.nextInt(15) - 7, EntityPlagueCloud.this.field_70146_Z.nextInt(11) - 5, EntityPlagueCloud.this.field_70146_Z.nextInt(15) - 7);
                if (!EntityPlagueCloud.this.field_70170_p.func_175623_d(blockpos1)) continue;
                EntityPlagueCloud.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 0.25);
                if (EntityPlagueCloud.this.func_70638_az() != null) break;
                EntityPlagueCloud.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class AIMoveControl
    extends MovementController {
        public AIMoveControl(EntityPlagueCloud vex) {
            super((MobEntity)vex);
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                double edgeLength;
                Vector3d vec3d = new Vector3d(this.func_179917_d() - EntityPlagueCloud.this.func_226277_ct_(), this.func_179919_e() - EntityPlagueCloud.this.func_226278_cu_(), this.func_179918_f() - EntityPlagueCloud.this.func_226281_cx_());
                double d0 = vec3d.func_72433_c();
                if (d0 < (edgeLength = EntityPlagueCloud.this.func_174813_aQ().func_72320_b())) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    EntityPlagueCloud.this.func_213317_d(EntityPlagueCloud.this.func_213322_ci().func_186678_a(0.5));
                } else {
                    EntityPlagueCloud.this.func_213317_d(EntityPlagueCloud.this.func_213322_ci().func_178787_e(vec3d.func_186678_a(this.field_75645_e * 0.1 / d0)));
                    if (EntityPlagueCloud.this.func_70638_az() == null) {
                        Vector3d vec3d1 = EntityPlagueCloud.this.func_213322_ci();
                        EntityPlagueCloud.this.field_70761_aq = EntityPlagueCloud.this.field_70177_z = -((float)MathHelper.func_181159_b((double)vec3d1.field_72450_a, (double)vec3d1.field_72449_c)) * 57.295776f;
                    } else {
                        double d4 = EntityPlagueCloud.this.func_70638_az().func_226277_ct_() - EntityPlagueCloud.this.func_226277_ct_();
                        double d5 = EntityPlagueCloud.this.func_70638_az().func_226281_cx_() - EntityPlagueCloud.this.func_226281_cx_();
                        EntityPlagueCloud.this.field_70761_aq = EntityPlagueCloud.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }
}

