/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.ISummonsRats;
import com.github.alexthe666.rats.server.entity.RatsEntityRegistry;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityRatShot
extends ThrowableEntity {
    private static final DataParameter<Integer> RAT_COLOR = EntityDataManager.func_187226_a(EntityRatShot.class, (IDataSerializer)DataSerializers.field_187192_b);

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(RAT_COLOR, (Object)0);
    }

    public EntityRatShot(EntityType type, World worldIn) {
        super(type, worldIn);
    }

    public EntityRatShot(FMLPlayMessages.SpawnEntity spawnEntity, World worldIn) {
        this(RatsEntityRegistry.RAT_SHOT, worldIn);
    }

    public EntityRatShot(EntityType type, World worldIn, LivingEntity throwerIn) {
        super(type, throwerIn, worldIn);
    }

    public EntityRatShot(EntityType type, World worldIn, double x, double y, double z) {
        super(type, x, y, z, worldIn);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("RatColor", this.getColorVariant());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setColorVariant(compound.func_74762_e("RatColor"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 3) {
            double d0 = 0.08;
            for (int i = 0; i < 18; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)RatsItemRegistry.CHEESE)), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.08, ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.08, ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.08);
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        Vector3d vec3d = this.func_213322_ci();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)EntityRatShot.func_213296_b((Vector3d)vec3d));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
    }

    protected void func_70227_a(RayTraceResult result) {
        float damage;
        if (result instanceof EntityRayTraceResult && this.func_234616_v_() != null && this.func_234616_v_().func_184191_r(((EntityRayTraceResult)result).func_216348_a())) {
            return;
        }
        Entity hitEntity = null;
        float f = damage = this.func_234616_v_() instanceof PlayerEntity ? 6.0f : 8.0f;
        if (!this.field_70170_p.field_72995_K) {
            Entity thrower;
            if (result instanceof EntityRayTraceResult) {
                EntityRayTraceResult entityResult = (EntityRayTraceResult)result;
                if ((this.func_234616_v_() == null || !entityResult.func_216348_a().func_184191_r(this.func_234616_v_())) && entityResult.func_216348_a() instanceof LivingEntity) {
                    ((LivingEntity)entityResult.func_216348_a()).func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_234616_v_()), damage);
                    hitEntity = entityResult.func_216348_a();
                }
            }
            if ((thrower = this.func_234616_v_()) != null) {
                EntityRat rat = new EntityRat(RatsEntityRegistry.RAT, this.field_70170_p);
                rat.func_82149_j((Entity)this);
                rat.setColorVariant(this.getColorVariant());
                if (thrower instanceof MobEntity) {
                    rat.func_70624_b(((MobEntity)thrower).func_70638_az());
                    rat.setTamedByMonster(true);
                    rat.func_70903_f(false);
                    rat.setMonsterOwnerUniqueId(this.func_110124_au());
                } else if (hitEntity instanceof LivingEntity) {
                    rat.func_70624_b((LivingEntity)hitEntity);
                }
                if (thrower instanceof ISummonsRats) {
                    ((ISummonsRats)thrower).setRatsSummoned(((ISummonsRats)thrower).getRatsSummoned() + 1);
                }
                this.field_70170_p.func_217376_c((Entity)rat);
            }
            this.func_70106_y();
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public int getColorVariant() {
        return (Integer)this.field_70180_af.func_187225_a(RAT_COLOR);
    }

    public void setColorVariant(int color) {
        this.field_70180_af.func_187227_b(RAT_COLOR, (Object)color);
    }

    public BlockPos getLightPosition() {
        BlockPos pos = new BlockPos(this.func_213303_ch());
        if (!this.field_70170_p.func_180495_p(pos).func_200132_m()) {
            return pos.func_177984_a();
        }
        return pos;
    }
}

