/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.EntitySmallArrow;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;

public class RatAIAttackBow
extends Goal {
    private final EntityRat entity;
    private final double moveSpeedAmp;
    private int attackCooldown;
    private final float maxAttackDistance;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;
    private int useTime = 0;

    public RatAIAttackBow(EntityRat mob, double moveSpeedAmpIn, int attackCooldownIn, float maxAttackDistanceIn) {
        this.entity = mob;
        this.moveSpeedAmp = moveSpeedAmpIn;
        this.attackCooldown = attackCooldownIn;
        this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void setAttackCooldown(int attackCooldownIn) {
        this.attackCooldown = attackCooldownIn;
    }

    public boolean func_75250_a() {
        return this.entity.func_70638_az() == null ? false : this.isBowInMainhand();
    }

    protected boolean isBowInMainhand() {
        return this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BOW) || this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CROSSBOW);
    }

    public boolean func_75253_b() {
        return (this.func_75250_a() || !this.entity.func_70661_as().func_75500_f()) && this.isBowInMainhand();
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.entity.func_213395_q(true);
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.entity.func_213395_q(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.useTime = 0;
        this.entity.func_184602_cy();
    }

    public void func_75246_d() {
        LivingEntity livingentity = this.entity.func_70638_az();
        if (livingentity != null) {
            boolean flag1;
            double d0 = this.entity.func_70092_e(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_());
            boolean flag = this.entity.func_70635_at().func_75522_a((Entity)livingentity);
            boolean bl = flag1 = this.seeTime > 0;
            if (flag != flag1) {
                this.seeTime = 0;
            }
            this.seeTime = flag ? ++this.seeTime : --this.seeTime;
            if (!(d0 > (double)this.maxAttackDistance) && this.seeTime >= 20) {
                this.entity.func_70661_as().func_75499_g();
                ++this.strafingTime;
            } else {
                this.entity.func_70661_as().func_75497_a((Entity)livingentity, this.moveSpeedAmp);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if ((double)this.entity.func_70681_au().nextFloat() < 0.3) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.entity.func_70681_au().nextFloat() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (d0 > (double)(this.maxAttackDistance * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (d0 < (double)(this.maxAttackDistance * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.entity.func_70605_aq().func_188488_a(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                this.entity.func_70625_a((Entity)livingentity, 30.0f, 30.0f);
            } else {
                this.entity.func_70671_ap().func_75651_a((Entity)livingentity, 30.0f, 30.0f);
            }
            if (this.useTime > 0) {
                if (!flag && this.seeTime < -60) {
                    this.useTime = 0;
                } else if (flag) {
                    ++this.useTime;
                    if (this.useTime >= (this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CROSSBOW) ? 40 : 20)) {
                        this.useTime = 0;
                        this.attackEntityWithRangedAttack(livingentity, BowItem.func_185059_b((int)Math.min(this.useTime, 20)));
                        this.attackTime = this.attackCooldown;
                    }
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                ++this.useTime;
            }
        }
    }

    public void attackEntityWithRangedAttack(LivingEntity target, float distanceFactor) {
        ItemStack itemstack = new ItemStack((IItemProvider)Items.field_151032_g);
        EntitySmallArrow abstractarrowentity = new EntitySmallArrow(this.entity.field_70170_p, (LivingEntity)this.entity);
        double d0 = target.func_226277_ct_() - this.entity.func_226277_ct_();
        double d1 = target.func_226283_e_(0.3333333333333333) - abstractarrowentity.func_226278_cu_();
        double d2 = target.func_226281_cx_() - this.entity.func_226281_cx_();
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        abstractarrowentity.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - this.entity.field_70170_p.func_175659_aa().func_151525_a() * 4);
        if (this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CROSSBOW)) {
            abstractarrowentity.func_70239_b(abstractarrowentity.func_70242_d() + 2.5);
        }
        this.entity.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.entity.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.entity.field_70170_p.func_217376_c((Entity)abstractarrowentity);
    }
}

