/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class RatAIDepositInInventory
extends Goal {
    private static final int RADIUS = 16;
    private final EntityRat entity;
    private final BlockSorter targetSorter;
    private BlockPos targetBlock = null;
    private int feedingTicks;
    private int breakingTime;
    private int previousBreakProgress;

    public RatAIDepositInInventory(EntityRat entity) {
        this.entity = entity;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (!this.entity.canMove() || !this.entity.func_70909_n() || this.entity.getCommand() != RatCommand.TRANSPORT && this.entity.getCommand() != RatCommand.GATHER && this.entity.getCommand() != RatCommand.HUNT_ANIMALS && this.entity.getCommand() != RatCommand.HARVEST || this.entity.func_70638_az() != null) {
            return false;
        }
        if (!this.entity.shouldDepositItem(this.entity.func_184614_ca())) {
            return false;
        }
        if (this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
            return false;
        }
        this.resetTarget();
        return this.targetBlock != null;
    }

    private void resetTarget() {
        this.targetBlock = this.entity.getDepositPos();
    }

    public boolean func_75253_b() {
        return this.targetBlock != null && !this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b() && this.entity.shouldDepositItem(this.entity.func_184614_ca());
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.resetTarget();
    }

    public boolean canSeeChest() {
        RayTraceResult rayTrace = RatUtils.rayTraceBlocksIgnoreRatholes(this.entity.field_70170_p, this.entity.func_213303_ch(), new Vector3d((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o() + 0.5, (double)this.targetBlock.func_177952_p() + 0.5), false, (Entity)this.entity);
        if (rayTrace instanceof BlockRayTraceResult) {
            BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTrace;
            BlockPos pos = blockRayTraceResult.func_216350_a();
            BlockPos sidePos = blockRayTraceResult.func_216350_a().func_177972_a(blockRayTraceResult.func_216354_b());
            return this.entity.field_70170_p.func_175623_d(sidePos) || this.entity.field_70170_p.func_175623_d(pos) || this.entity.field_70170_p.func_175625_s(pos) == this.entity.field_70170_p.func_175625_s(this.targetBlock);
        }
        return true;
    }

    private Vector3d getMovePos() {
        BlockPos minusVec = this.targetBlock.func_177972_a(this.entity.depositFacing).func_177973_b((Vector3i)this.targetBlock);
        return new Vector3d((double)this.targetBlock.func_177958_n(), (double)this.targetBlock.func_177956_o(), (double)this.targetBlock.func_177952_p()).func_72441_c((double)minusVec.func_177958_n() * 0.25, (double)minusVec.func_177956_o() * 0.25, (double)minusVec.func_177952_p() * 0.25);
    }

    public void func_75246_d() {
        if (this.targetBlock != null && this.entity.field_70170_p.func_175625_s(this.targetBlock) != null) {
            TileEntity te = this.entity.field_70170_p.func_175625_s(this.targetBlock);
            if ((this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_MINER_ORE) || this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_MINER)) && !this.entity.func_70605_aq().func_75640_a() && this.entity.func_233570_aj_() && !this.entity.func_70661_as().func_75492_a(this.getMovePos().func_82615_a() + 0.5, this.getMovePos().func_82617_b(), this.getMovePos().func_82616_c() + 0.5, 1.25)) {
                RatUtils.doRatMinerLogic(this.entity, this.targetBlock, this);
            } else {
                this.entity.func_70661_as().func_75492_a(this.getMovePos().func_82615_a() + 0.5, this.getMovePos().func_82617_b() + 0.5, this.getMovePos().func_82616_c() + 0.5, 1.25);
                double distance = Math.sqrt(this.entity.getRatDistanceSq((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o() + 0.5, (double)this.targetBlock.func_177952_p() + 0.5));
                if (distance < 3.5 * this.entity.getRatDistanceModifier() && distance > 2.5 * this.entity.getRatDistanceModifier() && this.canSeeChest() && te instanceof IInventory) {
                    this.toggleChest((IInventory)te, true);
                }
                if (distance <= 2.5 * this.entity.getRatDistanceModifier() && this.canSeeChest()) {
                    LazyOptional handler;
                    if (te instanceof IInventory) {
                        this.toggleChest((IInventory)te, false);
                    }
                    if ((handler = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.entity.depositFacing)).orElse(null) != null) {
                        ItemStack duplicate = this.entity.func_184586_b(Hand.MAIN_HAND).func_77946_l();
                        if (!ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)handler.orElse(null)), (ItemStack)duplicate, (boolean)true).equals(duplicate)) {
                            ItemStack shrunkenStack = ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)handler.orElse(null)), (ItemStack)duplicate, (boolean)false);
                            if (shrunkenStack.func_190926_b()) {
                                this.entity.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                            } else {
                                this.entity.func_184611_a(Hand.MAIN_HAND, shrunkenStack);
                            }
                            this.targetBlock = null;
                            this.func_75251_c();
                        }
                    }
                }
            }
        }
    }

    private void destroyBlock(BlockPos pos, BlockState state) {
        if (this.entity.field_70170_p instanceof ServerWorld) {
            LootContext.Builder loot = new LootContext.Builder((ServerWorld)this.entity.field_70170_p).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216023_a(this.entity.func_70681_au()).func_186469_a(1.0f);
            List drops = state.func_177230_c().func_220076_a(state, loot);
            if (!drops.isEmpty() && this.entity.canRatPickupItem((ItemStack)drops.get(0))) {
                for (ItemStack drop : drops) {
                    this.entity.func_70099_a(drop, 0.0f);
                }
                this.entity.field_70170_p.func_175655_b(pos, false);
                this.entity.fleePos = pos;
            }
        }
    }

    public void toggleChest(IInventory te, boolean open) {
        if (te instanceof ChestTileEntity) {
            ChestTileEntity chest = (ChestTileEntity)te;
            if (open) {
                this.entity.field_70170_p.func_175641_c(this.targetBlock, chest.func_195044_w().func_177230_c(), 1, 1);
            } else {
                this.entity.field_70170_p.func_175641_c(this.targetBlock, chest.func_195044_w().func_177230_c(), 1, 0);
            }
        }
    }

    public class BlockSorter
    implements Comparator<BlockPos> {
        private final Entity entity;

        public BlockSorter(Entity entity) {
            this.entity = entity;
        }

        @Override
        public int compare(BlockPos pos1, BlockPos pos2) {
            double distance1 = this.getDistance(pos1);
            double distance2 = this.getDistance(pos2);
            return Double.compare(distance1, distance2);
        }

        private double getDistance(BlockPos pos) {
            double deltaX = this.entity.func_226277_ct_() - ((double)pos.func_177958_n() + 0.5);
            double deltaY = this.entity.func_226278_cu_() + (double)this.entity.func_70047_e() - ((double)pos.func_177956_o() + 0.5);
            double deltaZ = this.entity.func_226281_cx_() - ((double)pos.func_177952_p() + 0.5);
            return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        }
    }
}

