/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.server.entity.EntityRat;
import java.util.EnumSet;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public abstract class RatAIMoveToBlock
extends Goal {
    private final CreatureEntity creature;
    private final double movementSpeed;
    private final int searchLength;
    protected int runDelay;
    protected BlockPos destinationBlock = BlockPos.field_177992_a;
    protected double distanceCheck = 1.0;
    private int timeoutCounter;
    private int maxStayTicks;
    private boolean isAboveDestination;

    public RatAIMoveToBlock(CreatureEntity creature, double speedIn, int length) {
        this.creature = creature;
        this.movementSpeed = speedIn;
        this.searchLength = length;
        this.distanceCheck = 1.0;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (this.runDelay > 0) {
            --this.runDelay;
            return false;
        }
        this.runDelay = RatConfig.ratUpdateDelay + this.creature.func_70681_au().nextInt(RatConfig.ratUpdateDelay);
        return this.searchForDestination();
    }

    public boolean func_75253_b() {
        return this.timeoutCounter >= -this.maxStayTicks && this.timeoutCounter <= 1200 && this.shouldMoveTo(this.creature.field_70170_p, this.destinationBlock);
    }

    public void func_75249_e() {
        this.creature.func_70661_as().func_75492_a((double)this.destinationBlock.func_177958_n() + 0.5, (double)(this.destinationBlock.func_177956_o() + 1), (double)this.destinationBlock.func_177952_p() + 0.5, this.movementSpeed);
        this.timeoutCounter = 0;
        this.maxStayTicks = this.creature.func_70681_au().nextInt(this.creature.func_70681_au().nextInt(1200) + 1200) + 1200;
    }

    public double getTargetDistanceSq() {
        return 1.0;
    }

    public void func_75246_d() {
        if (!this.destinationBlock.func_177984_a().func_218137_a((IPosition)this.creature.func_213303_ch(), this.getTargetDistanceSq())) {
            this.isAboveDestination = false;
            ++this.timeoutCounter;
            if (this.timeoutCounter % 40 == 0) {
                this.creature.func_70661_as().func_75492_a((double)this.destinationBlock.func_177958_n() + 0.5, (double)(this.destinationBlock.func_177956_o() + 1), (double)this.destinationBlock.func_177952_p() + 0.5, this.movementSpeed);
            }
        } else {
            this.isAboveDestination = true;
            --this.timeoutCounter;
        }
    }

    protected boolean getIsAboveDestination() {
        return this.isAboveDestination;
    }

    private boolean searchForDestination() {
        int i = this.searchLength;
        boolean j = true;
        BlockPos blockpos = new BlockPos((Vector3i)((EntityRat)this.creature).getSearchCenter());
        int k = 0;
        while (k <= 1) {
            for (int l = 0; l < i; ++l) {
                int i1 = 0;
                while (i1 <= l) {
                    int j1;
                    int n = j1 = i1 < l && i1 > -l ? l : 0;
                    while (j1 <= l) {
                        BlockPos blockpos1 = blockpos.func_177982_a(i1, k - 1, j1);
                        if (this.creature.func_213389_a(blockpos1) && this.shouldMoveTo(this.creature.field_70170_p, blockpos1)) {
                            this.destinationBlock = blockpos1;
                            return true;
                        }
                        j1 = j1 > 0 ? -j1 : 1 - j1;
                    }
                    i1 = i1 > 0 ? -i1 : 1 - i1;
                }
            }
            k = k > 0 ? -k : 1 - k;
        }
        return false;
    }

    protected abstract boolean shouldMoveTo(World var1, BlockPos var2);
}

