/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ratlantis;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.rats.RatlantisConfig;
import com.github.alexthe666.rats.server.entity.EntityRatMountBase;
import com.github.alexthe666.rats.server.entity.ratlantis.EntityGolemBeam;
import com.github.alexthe666.rats.server.entity.ratlantis.RatlantisEntityRegistry;
import com.github.alexthe666.rats.server.items.RatlantisItemRegistry;
import com.github.alexthe666.rats.server.misc.RatsSoundRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class EntityRatAutomatonMount
extends EntityRatMountBase
implements IAnimatedEntity {
    private int animationTick;
    private Animation currentAnimation;
    public static final Animation ANIMATION_MELEE = Animation.create((int)15);
    public static final Animation ANIMATION_RANGED = Animation.create((int)15);
    private boolean useRangedAttack = false;

    public EntityRatAutomatonMount(EntityType<? extends MobEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
        this.field_70765_h = new AIMoveControl(this);
        this.upgrade = RatlantisItemRegistry.RAT_UPGRADE_AUTOMATON_MOUNT;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_MELEE, ANIMATION_RANGED};
    }

    public static AttributeModifierMap.MutableAttribute func_234290_eH_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 250.0).func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_(Attributes.field_233823_f_, 5.0).func_233815_a_(Attributes.field_233819_b_, 128.0).func_233815_a_(Attributes.field_233826_i_, 10.0);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(this.useRangedAttack ? ANIMATION_MELEE : ANIMATION_RANGED);
        }
        return true;
    }

    public void func_70636_d() {
        double extraY;
        double extraZ;
        double extraX;
        float angle;
        float radius;
        super.func_70636_d();
        this.riderY = 2.52f;
        LivingEntity target = this.func_70638_az();
        if (target != null) {
            boolean bl = this.useRangedAttack = this.func_70032_d((Entity)target) > 10.0f;
        }
        if (this.useRangedAttack && this.getAnimation() != ANIMATION_RANGED && target != null && this.func_70685_l((Entity)target) && target.func_70089_S()) {
            this.setAnimation(ANIMATION_RANGED);
            this.func_70625_a((Entity)target, 360.0f, 80.0f);
        }
        if (!this.useRangedAttack && target != null && this.func_70032_d((Entity)target) < 7.0f && this.func_70685_l((Entity)target) && target.func_70089_S()) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(ANIMATION_MELEE);
                this.func_184185_a(SoundEvents.field_187730_dW, 1.0f, 0.5f + this.field_70146_Z.nextFloat() * 0.5f);
            }
            this.func_70625_a((Entity)target, 360.0f, 80.0f);
            if (this.getAnimation() == ANIMATION_MELEE && this.getAnimationTick() == 10) {
                target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), RatlantisConfig.ratlanteanAutomatonAttack);
                target.func_233627_a_(1.5f, this.func_226277_ct_() - target.func_226277_ct_(), this.func_226281_cx_() - target.func_226281_cx_());
                this.useRangedAttack = this.field_70146_Z.nextBoolean();
            }
        }
        if (this.field_70170_p.field_72995_K && this.field_70146_Z.nextDouble() < 0.5) {
            radius = -0.5f;
            angle = (float)Math.PI / 180 * this.field_70761_aq;
            extraX = (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))) + this.func_226277_ct_();
            extraZ = (double)(radius * MathHelper.func_76134_b((float)angle)) + this.func_226281_cx_();
            extraY = 1.25 + this.func_226278_cu_();
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197624_q, extraX + (double)(this.field_70146_Z.nextFloat() * 0.5f) - 0.25, extraY, extraZ + (double)(this.field_70146_Z.nextFloat() * 0.5f) - 0.25, 0.0, (double)-0.1f, 0.0);
        }
        if (this.useRangedAttack && this.getAnimation() == ANIMATION_RANGED && this.getAnimationTick() == 6) {
            radius = -3.4f;
            angle = (float)Math.PI / 180 * this.field_70761_aq - 160.0f;
            extraX = (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))) + this.func_226277_ct_();
            extraZ = (double)(radius * MathHelper.func_76134_b((float)angle)) + this.func_226281_cx_();
            extraY = (double)2.4f + this.func_226278_cu_();
            double targetRelativeX = (target == null ? this.func_70676_i((float)1.0f).field_72450_a : target.func_226277_ct_()) - extraX;
            double targetRelativeY = (target == null ? this.func_70676_i((float)1.0f).field_72448_b : target.func_226278_cu_()) - extraY;
            double targetRelativeZ = (target == null ? this.func_70676_i((float)1.0f).field_72449_c : target.func_226281_cx_()) - extraZ;
            EntityGolemBeam beam = new EntityGolemBeam(RatlantisEntityRegistry.RATLANTEAN_AUTOMATON_BEAM, this.field_70170_p, (LivingEntity)this);
            beam.func_70107_b(extraX, extraY, extraZ);
            beam.func_70186_c(targetRelativeX, targetRelativeY, targetRelativeZ, 2.0f, 0.1f);
            this.func_184185_a(RatsSoundRegistry.LASER, 1.0f, 0.75f + this.field_70146_Z.nextFloat() * 0.5f);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_217376_c((Entity)beam);
            }
            this.useRangedAttack = this.field_70146_Z.nextBoolean();
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    class AIMoveControl
    extends MovementController {
        public AIMoveControl(EntityRatAutomatonMount vex) {
            super((MobEntity)vex);
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                double edgeLength;
                Vector3d vec3d = new Vector3d(this.func_179917_d() - EntityRatAutomatonMount.this.func_226277_ct_(), this.func_179919_e() - EntityRatAutomatonMount.this.func_226278_cu_(), this.func_179918_f() - EntityRatAutomatonMount.this.func_226281_cx_());
                double d0 = vec3d.func_72433_c();
                if (d0 < (edgeLength = EntityRatAutomatonMount.this.func_174813_aQ().func_72320_b())) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    EntityRatAutomatonMount.this.func_213317_d(EntityRatAutomatonMount.this.func_213322_ci().func_186678_a(0.5));
                } else {
                    EntityRatAutomatonMount.this.func_213317_d(EntityRatAutomatonMount.this.func_213322_ci().func_178787_e(vec3d.func_186678_a(this.field_75645_e * 0.1 / d0)));
                    if (EntityRatAutomatonMount.this.func_70638_az() == null) {
                        Vector3d vec3d1 = EntityRatAutomatonMount.this.func_213322_ci();
                        EntityRatAutomatonMount.this.field_70761_aq = EntityRatAutomatonMount.this.field_70177_z = -((float)MathHelper.func_181159_b((double)vec3d1.field_72450_a, (double)vec3d1.field_72449_c)) * 57.295776f;
                    } else {
                        double d4 = EntityRatAutomatonMount.this.func_70638_az().func_226277_ct_() - EntityRatAutomatonMount.this.func_226277_ct_();
                        double d5 = EntityRatAutomatonMount.this.func_70638_az().func_226281_cx_() - EntityRatAutomatonMount.this.func_226281_cx_();
                        EntityRatAutomatonMount.this.field_70761_aq = EntityRatAutomatonMount.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }
}

