/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ratlantis;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.ratlantis.EntityRatBaron;
import com.github.alexthe666.rats.server.entity.ratlantis.EntityRattlingGunBullet;
import com.github.alexthe666.rats.server.entity.ratlantis.IRatlantean;
import com.github.alexthe666.rats.server.entity.ratlantis.PlaneBuffer;
import com.github.alexthe666.rats.server.entity.ratlantis.RatlantisEntityRegistry;
import com.github.alexthe666.rats.server.misc.RatsSoundRegistry;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityRatBaronPlane
extends MobEntity
implements IRatlantean {
    private static final DataParameter<Boolean> FIRING = EntityDataManager.func_187226_a(EntityRatBaronPlane.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> PLANE_PITCH = EntityDataManager.func_187226_a(EntityRatBaronPlane.class, (IDataSerializer)DataSerializers.field_187193_c);
    @OnlyIn(value=Dist.CLIENT)
    public PlaneBuffer roll_buffer;
    @OnlyIn(value=Dist.CLIENT)
    public PlaneBuffer pitch_buffer;
    @Nullable
    private Vector3d flightTarget;
    private Vector3d startAttackVec;
    private Vector3d startPreyVec;
    private boolean hasStartedToScorch = false;
    private LivingEntity prevAttackTarget = null;
    private BlockPos escortPosition = null;
    private int soundLoopCounter = 0;
    private static final com.google.common.base.Predicate<LivingEntity> PLAYER = new com.google.common.base.Predicate<LivingEntity>(){

        public boolean apply(@Nullable LivingEntity entity) {
            return (entity instanceof PlayerEntity || entity instanceof AbstractVillagerEntity) && entity.func_70089_S();
        }
    };
    public float prevPlanePitch;

    public EntityRatBaronPlane(EntityType<? extends MobEntity> type, World world) {
        super(type, world);
        this.field_70765_h = new FlightMoveHelper(this);
        this.field_70728_aV = 55;
        if (world.field_72995_K) {
            this.roll_buffer = new PlaneBuffer();
            this.pitch_buffer = new PlaneBuffer();
        }
    }

    public float getPlanePitch() {
        return ((Float)this.field_70180_af.func_187225_a(PLANE_PITCH)).floatValue();
    }

    public void setPlanePitch(float pitch) {
        this.field_70180_af.func_187227_b(PLANE_PITCH, (Object)Float.valueOf(pitch));
    }

    public void incrementPlanePitch(float pitch) {
        this.field_70180_af.func_187227_b(PLANE_PITCH, (Object)Float.valueOf(this.getPlanePitch() + pitch));
    }

    public void decrementPlanePitch(float pitch) {
        this.field_70180_af.func_187227_b(PLANE_PITCH, (Object)Float.valueOf(this.getPlanePitch() - pitch));
    }

    public boolean func_184191_r(Entity entityIn) {
        return super.func_184191_r(entityIn) || entityIn instanceof EntityRatBaron;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public void fall(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(1, (Goal)new AIHuntPlayers(this));
    }

    public void func_70624_b(@Nullable LivingEntity LivingEntityIn) {
        super.func_70624_b(LivingEntityIn);
        if (LivingEntityIn != null) {
            if (this.prevAttackTarget != LivingEntityIn) {
                this.startPreyVec = LivingEntityIn != null ? new Vector3d(LivingEntityIn.func_226277_ct_(), LivingEntityIn.func_226278_cu_(), LivingEntityIn.func_226281_cx_()) : new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                this.startAttackVec = new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            }
            this.prevAttackTarget = LivingEntityIn;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.soundLoopCounter == 0) {
            this.func_184185_a(RatsSoundRegistry.BIPLANE_LOOP, 10.0f, 1.0f);
        }
        ++this.soundLoopCounter;
        if (this.soundLoopCounter > 90) {
            this.soundLoopCounter = 0;
        }
        for (Entity passenger : this.func_184188_bt()) {
            if (!(passenger instanceof EntityRat)) continue;
            this.func_70624_b(((EntityRat)passenger).func_70638_az());
        }
        this.prevPlanePitch = this.getPlanePitch();
        if (!this.func_184207_aI() && !this.field_70170_p.field_72995_K) {
            this.func_70097_a(DamageSource.field_76369_e, 1000.0f);
        }
        if (!this.func_233570_aj_() && this.func_213322_ci().field_72448_b < 0.0) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.6, 1.0));
        }
        this.func_213293_j(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b + 0.08, this.func_213322_ci().field_72449_c);
        if (this.func_70638_az() != null && this.startPreyVec != null && this.startAttackVec != null) {
            float distX = (float)(this.startPreyVec.field_72450_a - this.startAttackVec.field_72450_a);
            float distY = 1.5f;
            float distZ = (float)(this.startPreyVec.field_72449_c - this.startAttackVec.field_72449_c);
            this.flightTarget = new Vector3d(this.func_70638_az().func_226277_ct_() + (double)distX, this.func_70638_az().func_226278_cu_() + (double)distY, this.func_70638_az().func_226281_cx_() + (double)distZ);
            this.tryScorchTarget();
            this.hasStartedToScorch = true;
            if (this.flightTarget != null && this.func_70092_e(this.flightTarget.field_72450_a, this.flightTarget.field_72448_b, this.flightTarget.field_72449_c) < 100.0) {
                this.flightTarget = new Vector3d(this.func_70638_az().func_226277_ct_() - (double)distX, this.func_70638_az().func_226278_cu_() + (double)distY, this.func_70638_az().func_226281_cx_() - (double)distZ);
            }
        }
        if (this.func_70638_az() != null && this.func_70685_l((Entity)this.func_70638_az())) {
            LivingEntity target = this.func_70638_az();
            if (this.field_70173_aa % 2 == 0) {
                for (int i = 0; i < 2; ++i) {
                    boolean left = i == 0;
                    float radius = 1.15f;
                    float angle = (float)Math.PI / 180 * this.field_70761_aq + (float)(left ? 75 : -75);
                    double extraX = this.func_226277_ct_() + (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle))));
                    double extraZ = this.func_226281_cx_() + (double)(radius * MathHelper.func_76134_b((float)angle));
                    double extraY = this.func_226278_cu_() + (double)1.35f;
                    double d0 = target.func_226278_cu_() + (double)target.func_70047_e() / 2.0;
                    double d1 = target.func_226277_ct_() - extraX;
                    double d3 = target.func_226281_cx_() - extraZ;
                    double d2 = d0 - extraY;
                    float velocity = 3.2f;
                    EntityRattlingGunBullet cannonball = new EntityRattlingGunBullet(RatlantisEntityRegistry.RATTLING_GUN_BULLET, this.field_70170_p, (LivingEntity)this);
                    cannonball.func_70107_b(extraX, extraY, extraZ);
                    cannonball.func_70239_b(0.5);
                    cannonball.func_70186_c(d1, d2, d3, velocity, 1.4f);
                    this.func_184185_a(SoundEvents.field_187539_bB, 3.0f, 2.3f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                    if (this.field_70170_p.field_72995_K) continue;
                    this.field_70170_p.func_217376_c((Entity)cannonball);
                }
            }
            this.setFiring(true);
        }
        if (this.func_70638_az() == null || this.flightTarget == null || this.func_70092_e(this.flightTarget.field_72450_a, this.flightTarget.field_72448_b, this.flightTarget.field_72449_c) < 9.0 || !this.field_70170_p.func_175623_d(new BlockPos(this.flightTarget))) {
            if (this.escortPosition == null) {
                this.escortPosition = this.field_70170_p.func_205770_a(Heightmap.Type.WORLD_SURFACE, new BlockPos(this.func_213303_ch())).func_177981_b(20 + this.field_70146_Z.nextInt(10));
            }
            this.flightTarget = this.getBlockInViewEscort();
        }
        if (this.field_70170_p.field_72995_K && !this.field_70122_E) {
            this.roll_buffer.calculateChainFlapBuffer(40.0f, 20, 0.5f, 0.5f, (LivingEntity)this);
            this.pitch_buffer.calculateChainWaveBuffer(40.0f, 10, 0.5f, 0.5f, (LivingEntity)this);
        }
        if (!this.field_70122_E) {
            double ydist = this.field_70167_r - this.func_226278_cu_();
            float planeDist = (float)((Math.abs(this.func_213322_ci().func_82615_a()) + Math.abs(this.func_213322_ci().func_82616_c())) * 6.0);
            this.incrementPlanePitch((float)ydist * 10.0f);
            this.setPlanePitch(MathHelper.func_76131_a((float)this.getPlanePitch(), (float)-60.0f, (float)40.0f));
            float plateau = 2.0f;
            if (this.getPlanePitch() > plateau) {
                this.decrementPlanePitch(planeDist * Math.abs(this.getPlanePitch()) / 90.0f);
            }
            if (this.getPlanePitch() < -plateau) {
                this.incrementPlanePitch(planeDist * Math.abs(this.getPlanePitch()) / 90.0f);
            }
            if (this.getPlanePitch() > 2.0f) {
                this.decrementPlanePitch(1.0f);
            } else if (this.getPlanePitch() < -2.0f) {
                this.incrementPlanePitch(1.0f);
            }
        } else {
            this.setPlanePitch(0.0f);
        }
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    private void tryScorchTarget() {
    }

    public boolean func_213397_c(double p_213397_1_) {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_184207_aI() && !this.func_184188_bt().isEmpty()) {
            for (Entity passenger : this.func_184188_bt()) {
                passenger.func_70097_a(source, amount);
            }
            return super.func_70097_a(source, 0.0f);
        }
        return super.func_70097_a(source, amount);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static AttributeModifierMap.MutableAttribute func_234290_eH_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, 0.35).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233819_b_, 128.0);
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        float radius = 0.35f;
        float angle = (float)Math.PI / 180 * this.field_70761_aq;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        double extraY = 1.35f;
        passenger.func_70107_b(this.func_226277_ct_() + extraX, this.func_226278_cu_() + extraY, this.func_226281_cx_() + extraZ);
        if (passenger instanceof LivingEntity) {
            ((LivingEntity)passenger).field_70761_aq = this.field_70761_aq;
            ((LivingEntity)passenger).field_70177_z = this.field_70761_aq;
            ((LivingEntity)passenger).field_70759_as = this.field_70761_aq;
        }
    }

    public Vector3d getBlockInViewEscort() {
        float radius = 12.0f;
        float neg = this.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.field_70761_aq;
        BlockPos escortPos = this.getEscortPosition();
        BlockPos ground = this.field_70170_p.func_205770_a(Heightmap.Type.WORLD_SURFACE, escortPos);
        int distFromGround = escortPos.func_177956_o() - ground.func_177956_o();
        int fromHome = 30;
        for (int i = 0; i < 10; ++i) {
            BlockPos pos = new BlockPos(escortPos.func_177958_n() + this.func_70681_au().nextInt(fromHome) - fromHome / 2, distFromGround > 16 ? escortPos.func_177956_o() : escortPos.func_177956_o() + 5 + this.func_70681_au().nextInt(26), escortPos.func_177952_p() + this.func_70681_au().nextInt(fromHome) - fromHome / 2);
            if (!this.canBlockPosBeSeen(pos) || !(this.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) > 6.0)) continue;
            return new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        }
        return null;
    }

    public boolean canBlockPosBeSeen(BlockPos pos) {
        Vector3d vec3d1;
        Vector3d vec3d = new Vector3d(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        return this.field_70170_p.func_217299_a(new RayTraceContext(vec3d, vec3d1 = new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this)).func_216346_c() == RayTraceResult.Type.MISS;
    }

    private BlockPos getEscortPosition() {
        return this.escortPosition;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FIRING, (Object)false);
        this.field_70180_af.func_187214_a(PLANE_PITCH, (Object)Float.valueOf(0.0f));
    }

    public boolean isFiring() {
        return (Boolean)this.field_70180_af.func_187225_a(FIRING);
    }

    public void setFiring(boolean male) {
        this.field_70180_af.func_187227_b(FIRING, (Object)male);
    }

    private double getFlightSpeedModifier() {
        return 1.0;
    }

    protected static class FlightMoveHelper
    extends MovementController {
        private EntityRatBaronPlane plane;

        protected FlightMoveHelper(EntityRatBaronPlane planeBase) {
            super((MobEntity)planeBase);
            this.plane = planeBase;
        }

        public static float approach(float number, float max, float min) {
            min = Math.abs(min);
            return number < max ? MathHelper.func_76131_a((float)(number + min), (float)number, (float)max) : MathHelper.func_76131_a((float)(number - min), (float)max, (float)number);
        }

        public static float approachDegrees(float number, float max, float min) {
            float add = MathHelper.func_76142_g((float)(max - number));
            return FlightMoveHelper.approach(number, number + add, min);
        }

        public static float degreesDifferenceAbs(float f1, float f2) {
            return Math.abs(MathHelper.func_76142_g((float)(f2 - f1)));
        }

        public void func_75641_c() {
            if (this.plane.field_70123_F) {
                this.plane.field_70177_z += 180.0f;
                this.field_75645_e = 0.1f;
                this.plane.flightTarget = null;
                return;
            }
            if (this.plane.flightTarget != null) {
                float distX = (float)(((EntityRatBaronPlane)this.plane).flightTarget.field_72450_a - this.plane.func_226277_ct_());
                float distY = (float)(((EntityRatBaronPlane)this.plane).flightTarget.field_72448_b - this.plane.func_226278_cu_());
                float distZ = (float)(((EntityRatBaronPlane)this.plane).flightTarget.field_72449_c - this.plane.func_226281_cx_());
                double planeDist = MathHelper.func_76129_c((float)(distX * distX + distZ * distZ));
                double yDistMod = 1.0 - (double)MathHelper.func_76135_e((float)(distY * 0.7f)) / planeDist;
                distX = (float)((double)distX * yDistMod);
                distZ = (float)((double)distZ * yDistMod);
                planeDist = MathHelper.func_76129_c((float)(distX * distX + distZ * distZ));
                double dist = MathHelper.func_76129_c((float)(distX * distX + distZ * distZ + distY * distY));
                if (dist > 1.0) {
                    float finPitch;
                    float yawCopy = this.plane.field_70177_z;
                    float atan = (float)MathHelper.func_181159_b((double)distZ, (double)distX);
                    float yawTurn = MathHelper.func_76142_g((float)(this.plane.field_70177_z + 90.0f));
                    float yawTurnAtan = MathHelper.func_76142_g((float)(atan * 57.295776f));
                    this.plane.field_70761_aq = this.plane.field_70177_z = FlightMoveHelper.approachDegrees(yawTurn, yawTurnAtan, 4.0f) - 90.0f;
                    if (FlightMoveHelper.degreesDifferenceAbs(yawCopy, this.plane.field_70177_z) < 3.0f) {
                        this.field_75645_e = FlightMoveHelper.approach((float)this.field_75645_e, 1.2f, 0.005f * (1.2f / (float)this.field_75645_e));
                    } else {
                        this.field_75645_e = FlightMoveHelper.approach((float)this.field_75645_e, 0.2f, 0.025f);
                        if (dist < 100.0 && this.plane.func_70638_az() != null) {
                            this.field_75645_e *= dist / 100.0;
                        }
                    }
                    this.plane.field_70125_A = finPitch = (float)(-(MathHelper.func_181159_b((double)(-distY), (double)planeDist) * 57.2957763671875));
                    float yawTurnHead = this.plane.field_70177_z + 90.0f;
                    double lvt_16_1_ = this.field_75645_e * (double)MathHelper.func_76134_b((float)(yawTurnHead * ((float)Math.PI / 180))) * Math.abs((double)distX / dist);
                    double lvt_18_1_ = this.field_75645_e * (double)MathHelper.func_76126_a((float)(yawTurnHead * ((float)Math.PI / 180))) * Math.abs((double)distZ / dist);
                    double lvt_20_1_ = this.field_75645_e * (double)MathHelper.func_76126_a((float)(finPitch * ((float)Math.PI / 180))) * Math.abs((double)distY / dist);
                    this.plane.func_213317_d(this.plane.func_213322_ci().func_72441_c(lvt_16_1_ * 0.4 * this.plane.getFlightSpeedModifier(), lvt_20_1_ * 0.4 * this.plane.getFlightSpeedModifier(), lvt_18_1_ * 0.4 * this.plane.getFlightSpeedModifier()));
                }
            }
        }
    }

    private class AIHuntPlayers
    extends NearestAttackableTargetGoal<LivingEntity> {
        private final EntityRatBaronPlane rat;

        public AIHuntPlayers(EntityRatBaronPlane entityIn) {
            super((MobEntity)entityIn, LivingEntity.class, 10, true, true, (Predicate)PLAYER);
            this.rat = entityIn;
        }

        protected AxisAlignedBB func_188511_a(double targetDistance) {
            return this.field_75299_d.func_174813_aQ().func_72314_b(targetDistance, 128.0, targetDistance);
        }
    }
}

