/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.tile;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.entity.tile.RatsTileEntityRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;

public class TileEntityRatTrap
extends TileEntity
implements ITickableTileEntity {
    public boolean isShut;
    public float shutProgress;
    private NonNullList<ItemStack> baitStack = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);

    public TileEntityRatTrap() {
        super(RatsTileEntityRegistry.RAT_TRAP);
    }

    public void func_73660_a() {
        boolean prevShut = this.isShut;
        if (this.isShut && this.shutProgress < 6.0f) {
            this.shutProgress += 1.5f;
        } else if (!this.isShut && this.shutProgress > 0.0f) {
            this.shutProgress -= 1.5f;
        }
        if (RatUtils.isRatFood((ItemStack)this.baitStack.get(0))) {
            this.killRats();
        }
    }

    private void killRats() {
        if (!this.isShut) {
            float i = (float)this.func_174877_v().func_177958_n() + 0.5f;
            float j = (float)this.func_174877_v().func_177956_o() + 0.5f;
            float k = (float)this.func_174877_v().func_177952_p() + 0.5f;
            float d0 = 0.65f;
            for (EntityRat rat : this.field_145850_b.func_217357_a(EntityRat.class, new AxisAlignedBB((double)i - (double)d0, (double)j - (double)d0, (double)k - (double)d0, (double)i + (double)d0, (double)j + (double)d0, (double)k + (double)d0))) {
                this.isShut = true;
                if (rat.isDead()) continue;
                rat.setKilledInTrap();
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187614_cJ, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.decreaseBait();
            }
        }
    }

    private void decreaseBait() {
        ((ItemStack)this.baitStack.get(0)).func_190918_g(1);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT tag = new CompoundNBT();
        this.func_189515_b(tag);
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, tag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.baitStack);
        compound.func_74757_a("IsShut", this.isShut);
        compound.func_74776_a("ShutProgress", this.shutProgress);
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.baitStack = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.baitStack);
        this.isShut = compound.func_74767_n("IsShut");
        this.shutProgress = compound.func_74760_g("ShutProgress");
    }

    public void setBaitStack(ItemStack stack) {
        this.baitStack.set(0, (Object)stack);
    }

    public ItemStack getBait() {
        return (ItemStack)this.baitStack.get(0);
    }

    public int calculateRedstone() {
        if (this.isShut) {
            return 15;
        }
        return 0;
    }

    public void onRedstonePulse() {
        this.isShut = true;
    }
}

