/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.message;

import com.github.alexthe666.rats.server.entity.EntityRat;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageDancingRat {
    public int ratId;
    public boolean setDancing;
    public long blockPos;
    public int moves;

    public MessageDancingRat(int ratId, boolean setDancing, long blockPos, int moves) {
        this.ratId = ratId;
        this.setDancing = setDancing;
        this.blockPos = blockPos;
        this.moves = moves;
    }

    public static MessageDancingRat read(PacketBuffer buf) {
        return new MessageDancingRat(buf.readInt(), buf.readBoolean(), buf.readLong(), buf.readInt());
    }

    public static void write(MessageDancingRat message, PacketBuffer buf) {
        buf.writeInt(message.ratId);
        buf.writeBoolean(message.setDancing);
        buf.writeLong(message.blockPos);
        buf.writeInt(message.moves);
    }

    public static class Handler {
        public static void handle(MessageDancingRat message, Supplier<NetworkEvent.Context> context) {
            context.get().setPacketHandled(true);
            context.get().enqueueWork(() -> {
                Entity entity;
                ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
                if (player != null && (entity = player.field_70170_p.func_73045_a(message.ratId)) instanceof EntityRat) {
                    EntityRat rat = (EntityRat)entity;
                    if (!rat.isDancing() && message.setDancing) {
                        rat.setDanceMoves(message.moves);
                    }
                    rat.setDancing(message.setDancing);
                    rat.jukeboxPos = BlockPos.func_218283_e((long)message.blockPos);
                }
            });
        }
    }
}

