/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.message;

import com.github.alexthe666.rats.server.entity.EntityThrownBlock;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSyncThrownBlock {
    public int blockEntityId;
    public long blockPos;

    public MessageSyncThrownBlock() {
    }

    public MessageSyncThrownBlock(int blockEntityId, long blockPos) {
        this.blockEntityId = blockEntityId;
        this.blockPos = blockPos;
    }

    public static MessageSyncThrownBlock read(PacketBuffer buf) {
        return new MessageSyncThrownBlock(buf.readInt(), buf.readLong());
    }

    public static void write(MessageSyncThrownBlock message, PacketBuffer buf) {
        buf.writeInt(message.blockEntityId);
        buf.writeLong(message.blockPos);
    }

    public static class Handler {
        public static void handle(MessageSyncThrownBlock message, Supplier<NetworkEvent.Context> context) {
            context.get().setPacketHandled(true);
            context.get().enqueueWork(() -> {
                Entity entity;
                ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
                if (player != null && (entity = player.field_70170_p.func_73045_a(message.blockEntityId)) instanceof EntityThrownBlock) {
                    BlockPos pos = BlockPos.func_218283_e((long)message.blockPos);
                    ((EntityThrownBlock)entity).setHeldBlockState(player.field_70170_p.func_180495_p(pos));
                }
            });
        }
    }
}

