/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.message;

import com.github.alexthe666.citadel.server.message.PacketBufferUtils;
import com.github.alexthe666.rats.RatsMod;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageUpdateTileSlots {
    public long blockPos;
    public CompoundNBT tag;

    public MessageUpdateTileSlots(long blockPos, CompoundNBT tag) {
        this.blockPos = blockPos;
        this.tag = tag;
    }

    public static MessageUpdateTileSlots read(PacketBuffer packetBuffer) {
        return new MessageUpdateTileSlots(packetBuffer.readLong(), PacketBufferUtils.readTag((ByteBuf)packetBuffer));
    }

    public static void write(MessageUpdateTileSlots message, PacketBuffer packetBuffer) {
        packetBuffer.writeLong(message.blockPos);
        PacketBufferUtils.writeTag((ByteBuf)packetBuffer, (CompoundNBT)message.tag);
    }

    public static class Handler {
        public static void handle(MessageUpdateTileSlots message, Supplier<NetworkEvent.Context> context) {
            context.get().setPacketHandled(true);
            context.get().enqueueWork(() -> RatsMod.PROXY.handlePacketUpdateTileSlots(message.blockPos, message.tag));
        }
    }
}

