/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.pathfinding;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.pathfinding.AbstractAdvancedPathNavigate;
import com.github.alexthe666.rats.server.pathfinding.IStuckHandler;
import com.github.alexthe666.rats.server.pathfinding.Node;
import com.github.alexthe666.rats.server.pathfinding.PathFindingStatus;
import com.github.alexthe666.rats.server.pathfinding.PathPointExtended;
import com.github.alexthe666.rats.server.pathfinding.PathResult;
import com.github.alexthe666.rats.server.pathfinding.Pathfinding;
import com.github.alexthe666.rats.server.pathfinding.PathingStuckHandler;
import com.github.alexthe666.rats.server.pathfinding.pathjobs.AbstractPathJob;
import com.github.alexthe666.rats.server.pathfinding.pathjobs.PathJobMoveToLocation;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class RatAdvancedPathNavigate
extends AbstractAdvancedPathNavigate {
    public static final double MIN_Y_DISTANCE = 0.001;
    public static final int MAX_SPEED_ALLOWED = 5;
    public static final double MIN_SPEED_ALLOWED = 0.1;
    private static final double ON_PATH_SPEED_MULTIPLIER = 1.3;
    private static final double PIRATE_SWIM_BONUS = 1.5;
    private static final double BARBARIAN_SWIM_BONUS = 1.2;
    private static final double CITIZEN_SWIM_BONUS = 1.1;
    @Nullable
    private PathResult pathResult;
    private long pathStartTime = 0L;
    private BlockPos spawnedPos = BlockPos.field_177992_a;
    private BlockPos desiredPos;
    private int desiredPosTimeout = 0;
    private IStuckHandler stuckHandler;
    private boolean isSneaking = true;

    public RatAdvancedPathNavigate(MobEntity entity, World world) {
        super(entity, world);
        this.field_179695_a = new WalkNodeProcessor();
        this.field_179695_a.func_186317_a(true);
        this.getPathingOptions().setEnterDoors(true);
        this.field_179695_a.func_186321_b(true);
        this.getPathingOptions().setCanOpenDoors(true);
        this.field_179695_a.func_186316_c(true);
        this.getPathingOptions().setCanSwim(true);
        this.stuckHandler = PathingStuckHandler.createStuckHandler().withTakeDamageOnStuck(0.0f).withDelayBeforeStuckActions(100).withTeleportSteps(6).withTeleportOnFullStuck();
    }

    public static boolean isEqual(BlockPos coords, int x, int y, int z) {
        return coords.func_177958_n() == x && coords.func_177956_o() == y && coords.func_177952_p() == z;
    }

    @Override
    public BlockPos getDestination() {
        return this.destination;
    }

    @Nullable
    public PathResult setPathJob(AbstractPathJob job, BlockPos dest, double speedFactor) {
        if (dest != null && dest.equals((Object)this.desiredPos) && this.calculationFuture != null && this.pathResult != null) {
            return this.pathResult;
        }
        this.func_75499_g();
        this.destination = dest;
        this.originalDestination = dest;
        if (dest != null) {
            this.desiredPos = dest;
            this.desiredPosTimeout = 1000;
        }
        this.walkSpeedFactor = speedFactor;
        if (speedFactor > 5.0 || speedFactor < 0.1) {
            RatsMod.LOGGER.error("Tried to set a bad speed:" + speedFactor + " for entity:" + this.ourEntity, (Throwable)new Exception());
            return null;
        }
        job.setPathingOptions(this.getPathingOptions());
        this.calculationFuture = Pathfinding.enqueue(job);
        this.pathResult = job.getResult();
        return this.pathResult;
    }

    public boolean func_75500_f() {
        return this.calculationFuture == null && super.func_75500_f();
    }

    public void func_75501_e() {
        int oldIndex;
        if (this.desiredPosTimeout > 0 && this.desiredPosTimeout-- <= 0) {
            this.desiredPos = null;
        }
        if (this.calculationFuture != null) {
            if (!this.calculationFuture.isDone()) {
                return;
            }
            try {
                if (this.processCompletedCalculationResult()) {
                    return;
                }
            }
            catch (InterruptedException | ExecutionException e) {
                RatsMod.LOGGER.catching((Throwable)e);
            }
            this.calculationFuture = null;
        }
        int n = oldIndex = this.func_75500_f() ? 0 : this.func_75505_d().func_75873_e();
        if (this.isSneaking) {
            this.isSneaking = false;
            this.field_75515_a.func_226284_e_(false);
        }
        if (this.handleLadders(oldIndex)) {
            this.func_75508_h();
            return;
        }
        if (this.handleRails()) {
            return;
        }
        super.func_75501_e();
        if (this.pathResult != null && this.func_75500_f()) {
            this.pathResult.setStatus(PathFindingStatus.COMPLETE);
            this.pathResult = null;
        }
        this.stuckHandler.checkStuck(this);
    }

    @Override
    @Nullable
    public PathResult moveToXYZ(double x, double y, double z, double speedFactor) {
        int newX = MathHelper.func_76128_c((double)x);
        int newY = (int)y;
        int newZ = MathHelper.func_76128_c((double)z);
        if (this.pathResult != null && (this.pathResult.isComputing() || this.destination != null && RatAdvancedPathNavigate.isEqual(this.destination, newX, newY, newZ) || this.originalDestination != null && RatAdvancedPathNavigate.isEqual(this.originalDestination, newX, newY, newZ))) {
            return this.pathResult;
        }
        BlockPos start = AbstractPathJob.prepareStart((LivingEntity)this.ourEntity);
        this.desiredPos = new BlockPos(newX, newY, newZ);
        return this.setPathJob(new PathJobMoveToLocation(this.ourEntity.field_70170_p, start, this.desiredPos, (int)this.ourEntity.func_110148_a(Attributes.field_233821_d_).func_111126_e(), (LivingEntity)this.ourEntity), this.desiredPos, speedFactor);
    }

    @Override
    public boolean tryMoveToBlockPos(BlockPos pos, double speedFactor) {
        this.moveToXYZ(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), speedFactor);
        return true;
    }

    protected PathFinder func_179679_a(int p_179679_1_) {
        return null;
    }

    protected boolean func_75485_k() {
        return true;
    }

    protected Vector3d func_75502_i() {
        return this.ourEntity.func_213303_ch();
    }

    public Path func_179680_a(BlockPos pos, int p_179680_2_) {
        return null;
    }

    protected boolean func_75493_a(Vector3d start, Vector3d end, int sizeX, int sizeY, int sizeZ) {
        return super.func_75493_a(start, end, sizeX, sizeY, sizeZ);
    }

    public double getSpeedFactor() {
        this.field_75511_d = this.walkSpeedFactor;
        return this.walkSpeedFactor;
    }

    public void func_75489_a(double speedFactor) {
        if (speedFactor > 5.0 || speedFactor < 0.1) {
            RatsMod.LOGGER.error("Tried to set a bad speed:" + speedFactor + " for entity:" + this.ourEntity, (Throwable)new Exception());
            return;
        }
        this.walkSpeedFactor = speedFactor;
    }

    public boolean func_75492_a(double x, double y, double z, double speedFactor) {
        if (x == 0.0 && y == 0.0 && z == 0.0) {
            return false;
        }
        this.moveToXYZ(x, y, z, speedFactor);
        return true;
    }

    public boolean func_75497_a(Entity entityIn, double speedFactor) {
        return this.tryMoveToBlockPos(entityIn.func_233580_cy_(), speedFactor);
    }

    protected void func_75487_m() {
    }

    public boolean func_75484_a(@Nullable Path path, double speedFactor) {
        if (path == null) {
            this.func_75499_g();
            return false;
        }
        this.pathStartTime = this.field_75513_b.func_82737_E();
        return super.func_75484_a(this.convertPath(path), speedFactor);
    }

    private Path convertPath(Path path) {
        int pathLength = path.func_75874_d();
        Path tempPath = null;
        if (pathLength > 0 && !(path.func_75877_a(0) instanceof PathPointExtended)) {
            PathPointExtended[] newPoints = new PathPointExtended[pathLength];
            for (int i = 0; i < pathLength; ++i) {
                PathPoint point = path.func_75877_a(i);
                newPoints[i] = !(point instanceof PathPointExtended) ? new PathPointExtended(new BlockPos(point.field_75839_a, point.field_75837_b, point.field_75838_c)) : (PathPointExtended)point;
            }
            tempPath = new Path(Arrays.asList(newPoints), path.func_224770_k(), path.func_224771_h());
            PathPointExtended finalPoint = newPoints[pathLength - 1];
            this.destination = new BlockPos(finalPoint.field_75839_a, finalPoint.field_75837_b, finalPoint.field_75838_c);
        }
        return tempPath == null ? path : tempPath;
    }

    private boolean processCompletedCalculationResult() throws InterruptedException, ExecutionException {
        if (this.calculationFuture.get() == null) {
            this.calculationFuture = null;
            return true;
        }
        this.func_75484_a((Path)this.calculationFuture.get(), this.getSpeedFactor());
        this.pathResult.setPathLength(this.func_75505_d().func_75874_d());
        this.pathResult.setStatus(PathFindingStatus.IN_PROGRESS_FOLLOWING);
        PathPoint p = this.func_75505_d().func_75870_c();
        if (p != null && this.destination == null) {
            this.destination = new BlockPos(p.field_75839_a, p.field_75837_b, p.field_75838_c);
            this.pathResult.setPathReachesDestination(true);
        }
        return false;
    }

    private boolean handleLadders(int oldIndex) {
        if (!this.func_75500_f()) {
            PathPointExtended pEx = (PathPointExtended)this.func_75505_d().func_75877_a(this.func_75505_d().func_75873_e());
            PathPointExtended pExNext = this.func_75505_d().func_75874_d() > this.func_75505_d().func_75873_e() + 1 ? (PathPointExtended)this.func_75505_d().func_75877_a(this.func_75505_d().func_75873_e() + 1) : null;
            for (int i = this.field_75514_c.func_75873_e(); i < Math.min(this.field_75514_c.func_75874_d(), this.field_75514_c.func_75873_e() + 3); ++i) {
                PathPointExtended nextPoints = (PathPointExtended)this.func_75505_d().func_75877_a(i);
                if (!nextPoints.isOnLadder()) continue;
                Vector3d motion = this.field_75515_a.func_213322_ci();
                double x = motion.field_72450_a < -0.1 ? -0.1 : Math.min(motion.field_72450_a, 0.1);
                double z = motion.field_72450_a < -0.1 ? -0.1 : Math.min(motion.field_72449_c, 0.1);
                this.ourEntity.func_213293_j(x, motion.field_72448_b, z);
                break;
            }
            if (this.ourEntity.func_70090_H()) {
                return this.handleEntityInWater(oldIndex, pEx);
            }
            if (this.field_75513_b.field_73012_v.nextInt(10) == 0) {
                this.field_75511_d = this.getSpeedFactor();
            }
        }
        return false;
    }

    private BlockPos findBlockUnderEntity(Entity parEntity) {
        int blockX = (int)Math.round(parEntity.func_226277_ct_());
        int blockY = MathHelper.func_76128_c((double)(parEntity.func_226278_cu_() - 0.2));
        int blockZ = (int)Math.round(parEntity.func_226281_cx_());
        return new BlockPos(blockX, blockY, blockZ);
    }

    private boolean handleRails() {
        if (!this.func_75500_f()) {
            PathPointExtended pEx = (PathPointExtended)this.func_75505_d().func_75877_a(this.func_75505_d().func_75873_e());
            PathPointExtended pathPointExtended = this.func_75505_d().func_75874_d() > this.func_75505_d().func_75873_e() + 1 ? (PathPointExtended)this.func_75505_d().func_75877_a(this.func_75505_d().func_75873_e() + 1) : null;
        }
        return false;
    }

    private boolean handleEntityInWater(int oldIndex, PathPointExtended pEx) {
        int curIndex = this.func_75505_d().func_75873_e();
        if (curIndex > 0 && curIndex + 1 < this.func_75505_d().func_75874_d() && this.func_75505_d().func_75877_a((int)(curIndex - 1)).field_75837_b != pEx.field_75837_b) {
            oldIndex = curIndex + 1;
        }
        this.func_75505_d().func_75872_c(oldIndex);
        Vector3d vec3d = this.func_75505_d().func_75878_a((Entity)this.ourEntity);
        Vector3d vector3d = new Vector3d(this.ourEntity.func_226277_ct_(), vec3d.field_72448_b, this.ourEntity.func_226281_cx_());
        if (vec3d.func_72436_e(vector3d) < 0.1 && Math.abs(this.ourEntity.func_226278_cu_() - vec3d.field_72448_b) < 0.5) {
            this.func_75505_d().func_75875_a();
            if (this.func_75500_f()) {
                return true;
            }
            vec3d = this.func_75505_d().func_75878_a((Entity)this.ourEntity);
        }
        this.ourEntity.func_70605_aq().func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, this.getSpeedFactor());
        return false;
    }

    protected void func_75508_h() {
        this.getSpeedFactor();
        int curNode = this.field_75514_c.func_75873_e();
        int curNodeNext = curNode + 1;
        if (curNodeNext < this.field_75514_c.func_75874_d()) {
            if (!(this.field_75514_c.func_75877_a(curNode) instanceof PathPointExtended)) {
                this.field_75514_c = this.convertPath(this.field_75514_c);
            }
            PathPointExtended pEx = (PathPointExtended)this.field_75514_c.func_75877_a(curNode);
            PathPointExtended pExNext = (PathPointExtended)this.field_75514_c.func_75877_a(curNodeNext);
            if (pEx.isOnLadder() && pEx.getLadderFacing() == Direction.DOWN && !pExNext.isOnLadder()) {
                Vector3d vec3 = this.func_75502_i();
                if (vec3.field_72448_b - (double)pEx.field_75837_b < 0.001) {
                    this.field_75514_c.func_75872_c(curNodeNext);
                }
                return;
            }
        }
        Vector3d vec3d = this.func_75502_i();
        double maxYDistance = 0.0;
        block0: for (int i = this.field_75514_c.func_75873_e(); i < Math.min(this.field_75514_c.func_75874_d(), this.field_75514_c.func_75873_e() + 4); ++i) {
            Vector3d vec3d2 = this.field_75514_c.func_75881_a((Entity)this.field_75515_a, i);
            double yDist = Math.abs(this.field_75515_a.func_226278_cu_() - vec3d2.field_72448_b);
            if (!(Math.abs(this.field_75515_a.func_226277_ct_() - vec3d2.field_72450_a) < (double)this.field_188561_o) || !(Math.abs(this.field_75515_a.func_226281_cx_() - vec3d2.field_72449_c) < (double)this.field_188561_o) || !(yDist < 0.9)) continue;
            this.field_75514_c.func_75875_a();
            if (AbstractPathJob.lastDebugNodesPath == null) continue;
            PathPoint point = this.field_75514_c.func_75877_a(i);
            BlockPos pos = new BlockPos(point.field_75839_a, point.field_75837_b, point.field_75838_c);
            for (Node node : AbstractPathJob.lastDebugNodesPath) {
                if (!node.pos.equals((Object)pos)) continue;
                node.setReachedByWorker();
                continue block0;
            }
        }
    }

    public void func_188554_j() {
    }

    protected void func_179677_a(Vector3d positionVec3) {
    }

    public void func_75499_g() {
        if (this.calculationFuture != null) {
            this.calculationFuture.cancel(true);
            this.calculationFuture = null;
        }
        if (this.pathResult != null) {
            this.pathResult.setStatus(PathFindingStatus.CANCELLED);
            this.pathResult = null;
        }
        this.destination = null;
        super.func_75499_g();
    }

    @Override
    @Nullable
    public PathResult moveToLivingEntity(Entity e, double speed) {
        return this.moveToXYZ(e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_(), speed);
    }

    public void func_212239_d(boolean canSwim) {
        super.func_212239_d(canSwim);
        this.getPathingOptions().setCanSwim(canSwim);
    }

    @Override
    public BlockPos getDesiredPos() {
        return this.desiredPos;
    }

    @Override
    public void setStuckHandler(IStuckHandler stuckHandler) {
        this.stuckHandler = stuckHandler;
    }
}

