/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.recipes;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.blocks.RatlantisBlockRegistry;
import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.items.RatlantisItemRegistry;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.github.alexthe666.rats.server.recipes.SharedRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.IItemProvider;

public class RatsRecipeRegistry {
    public static List<SharedRecipe> CAULDRON_RECIPES = new ArrayList<SharedRecipe>();
    public static List<SharedRecipe> RAT_CHEF_RECIPES = new ArrayList<SharedRecipe>();
    public static List<SharedRecipe> RAT_ARCHEOLOGIST_RECIPES = new ArrayList<SharedRecipe>();
    public static List<SharedRecipe> RAT_GEMCUTTER_RECIPES = new ArrayList<SharedRecipe>();
    public static BannerPattern RAT_PATTERN = RatsRecipeRegistry.addBanner("rat", new ItemStack((IItemProvider)RatsItemRegistry.RAT_PELT));
    public static BannerPattern CHEESE_PATTERN = RatsRecipeRegistry.addBanner("cheese", new ItemStack((IItemProvider)RatsItemRegistry.CHEESE));
    public static BannerPattern RAT_AND_CROSSBONES_BANNER = RatsRecipeRegistry.addBanner("rat_and_crossbones", new ItemStack((IItemProvider)RatsItemRegistry.PIRAT_HAT));
    public static BannerPattern RAT_AND_SICKLE_BANNER = RatsRecipeRegistry.addBanner("rat_and_sickle", new ItemStack((IItemProvider)RatlantisItemRegistry.MILITARY_HAT));

    public static void preRegister() {
        RAT_CHEF_RECIPES.add(new SharedRecipe(new ItemStack((IItemProvider)RatsItemRegistry.ASSORTED_VEGETABLES), new ItemStack((IItemProvider)RatsItemRegistry.CONFIT_BYALDI)));
        RAT_CHEF_RECIPES.add(new SharedRecipe(new ItemStack((IItemProvider)RatsItemRegistry.CHEESE), new ItemStack((IItemProvider)RatsItemRegistry.STRING_CHEESE, 4)));
        RAT_CHEF_RECIPES.add(new SharedRecipe(new ItemStack((IItemProvider)RatsItemRegistry.CENTIPEDE), new ItemStack((IItemProvider)RatsItemRegistry.POTATO_KNISHES)));
        if (RatsMod.RATLANTIS_LOADED) {
            RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack((IItemProvider)Items.field_151166_bC), new ItemStack((IItemProvider)RatlantisItemRegistry.GEM_OF_RATLANTIS)));
            RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack((IItemProvider)RatsItemRegistry.RAT_UPGRADE_BASIC), new ItemStack((IItemProvider)RatlantisItemRegistry.RAT_UPGRADE_BASIC_RATLANTEAN)));
            RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack((IItemProvider)RatsItemRegistry.PIPER_HAT), new ItemStack((IItemProvider)RatsItemRegistry.PIRAT_HAT)));
            RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack((IItemProvider)Items.field_151065_br), new ItemStack((IItemProvider)RatlantisItemRegistry.RATLANTEAN_FLAME)));
            RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack((IItemProvider)Items.field_151027_R), new ItemStack((IItemProvider)RatlantisItemRegistry.RAT_TOGA)));
            RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack((IItemProvider)Items.field_179556_br), new ItemStack((IItemProvider)RatlantisItemRegistry.FERAL_RAT_CLAW)));
            RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack((IItemProvider)Items.field_151059_bz), new ItemStack((IItemProvider)RatlantisItemRegistry.CHEESE_CANNONBALL)));
            RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack((IItemProvider)Items.field_151040_l), new ItemStack((IItemProvider)RatlantisItemRegistry.PIRAT_CUTLASS)));
            RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack((IItemProvider)Items.field_179555_bs), new ItemStack((IItemProvider)RatsItemRegistry.RAT_PELT)));
            RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack((IItemProvider)Items.field_204840_eX), new ItemStack((IItemProvider)RatlantisItemRegistry.GHOST_PIRAT_ECTOPLASM)));
            RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack((IItemProvider)Items.field_196088_aY), new ItemStack((IItemProvider)RatlantisItemRegistry.RATFISH)));
            RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack((IItemProvider)Blocks.field_150367_z), new ItemStack((IItemProvider)RatlantisItemRegistry.RATBOT_BARREL)));
            RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack((IItemProvider)Blocks.field_150484_ah), new ItemStack((IItemProvider)RatlantisItemRegistry.ORATCHALCUM_INGOT)));
            RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack((IItemProvider)Blocks.field_150461_bJ), new ItemStack((IItemProvider)RatlantisItemRegistry.ARCANE_TECHNOLOGY)));
            RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack((IItemProvider)Items.field_185157_bK), new ItemStack((IItemProvider)RatlantisItemRegistry.PSIONIC_RAT_BRAIN)));
            RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack((IItemProvider)Items.field_222048_ij), new ItemStack((IItemProvider)RatlantisItemRegistry.DUTCHRAT_WHEEL)));
            RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack((IItemProvider)Items.field_185160_cR), new ItemStack((IItemProvider)RatlantisItemRegistry.BIPLANE_WING)));
        }
        RAT_GEMCUTTER_RECIPES.add(new SharedRecipe(new ItemStack((IItemProvider)Items.field_151044_h), new ItemStack((IItemProvider)RatsItemRegistry.LITTLE_BLACK_SQUASH_BALLS)));
        RAT_GEMCUTTER_RECIPES.add(new SharedRecipe(new ItemStack((IItemProvider)RatsItemRegistry.LITTLE_BLACK_WORM), new ItemStack((IItemProvider)RatsItemRegistry.CENTIPEDE)));
    }

    public static void register() {
        RatsRecipeRegistry.preRegister();
        CAULDRON_RECIPES.add(new SharedRecipe(new ItemStack((IItemProvider)Items.field_151117_aB), new ItemStack((IItemProvider)RatsBlockRegistry.BLOCK_OF_CHEESE)));
        RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack((IItemProvider)RatsBlockRegistry.BLOCK_OF_CHEESE), new ItemStack((IItemProvider)RatsBlockRegistry.MARBLED_CHEESE_RAW)));
        RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack((IItemProvider)Items.field_196182_dv), new ItemStack((IItemProvider)RatlantisBlockRegistry.MARBLED_CHEESE_RAT_HEAD)));
        RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack((IItemProvider)Blocks.field_196607_be), new ItemStack((IItemProvider)RatlantisBlockRegistry.RATGLOVE_FLOWER)));
        RatsItemRegistry.CHEF_TOQUE_ARMOR_MATERIAL.setRepairMaterial(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196556_aL)}));
        RatsItemRegistry.PIPER_HAT_ARMOR_MATERIAL.setRepairMaterial(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)RatsBlockRegistry.PIED_WOOL)}));
        RatsItemRegistry.HAT_ARMOR_MATERIAL.setRepairMaterial(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151116_aA)}));
        RatsItemRegistry.PIRAT_CUTLASS_MATERIAL.setRepairMaterial(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151042_j)}));
        RatsItemRegistry.BAGHNAKHS_MATERIAL.setRepairMaterial(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)RatlantisItemRegistry.FERAL_RAT_CLAW)}));
        RatsItemRegistry.PLAGUE_SCYTHE_MATERIAL.setRepairMaterial(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)RatsItemRegistry.PLAGUE_ESSENCE)}));
        RatsItemRegistry.PLAGUE_MASK_MATERIAL.setRepairMaterial(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)RatsItemRegistry.PLAGUE_ESSENCE)}));
    }

    public static BannerPattern addBanner(String name, ItemStack craftingStack) {
        return BannerPattern.create((String)name.toUpperCase(), (String)name, (String)("rats." + name), (boolean)true);
    }

    public static SharedRecipe getRatChefRecipe(ItemStack stack) {
        for (SharedRecipe recipe : RAT_CHEF_RECIPES) {
            if (!ItemStack.func_179545_c((ItemStack)recipe.getInput(), (ItemStack)stack)) continue;
            return recipe;
        }
        return null;
    }

    public static SharedRecipe getArcheologistRecipe(ItemStack stack) {
        for (SharedRecipe recipe : RAT_ARCHEOLOGIST_RECIPES) {
            if (!ItemStack.func_179545_c((ItemStack)recipe.getInput(), (ItemStack)stack)) continue;
            return recipe;
        }
        return null;
    }

    public static SharedRecipe getGemcutterRecipe(ItemStack stack) {
        for (SharedRecipe recipe : RAT_GEMCUTTER_RECIPES) {
            if (!ItemStack.func_179545_c((ItemStack)recipe.getInput(), (ItemStack)stack)) continue;
            return recipe;
        }
        return null;
    }
}

