/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.world;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.world.RatlantisSurfaceBuilder;
import com.github.alexthe666.rats.server.world.structure.DutchratShipStructure;
import com.github.alexthe666.rats.server.world.structure.RatlantisRuinsStructure;
import com.github.alexthe666.rats.server.world.structure.RunwayStructure;
import com.mojang.serialization.Codec;
import java.util.Locale;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class RatsWorldRegistry {
    public static final RatlantisSurfaceBuilder RATLANTIS_SURFACE = new RatlantisSurfaceBuilder((Codec<SurfaceBuilderConfig>)SurfaceBuilderConfig.field_237203_a_);
    public static Biome RATLANTIS_BIOME;
    public static final RegistryKey<DimensionSettings> RATLANTIS_KEY;
    public static final Structure<NoFeatureConfig> RAT_RUINS;
    public static final Structure<NoFeatureConfig> FLYING_DUTCHRAT;
    public static final Structure<NoFeatureConfig> RUNWAY;
    public static StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>> RAT_RUINS_SF;
    public static StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>> FLYING_DUTCHRAT_SF;
    public static StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>> RUNWAY_SF;

    public static <F extends Structure<?>> void putStructureOnAList(String nameForList, F structure) {
        Structure.field_236365_a_.put((Object)nameForList.toLowerCase(Locale.ROOT), structure);
    }

    private static <FC extends IFeatureConfig, F extends Structure<FC>> StructureFeature<FC, F> func_244162_a(String p_244162_0_, StructureFeature<FC, F> p_244162_1_) {
        return (StructureFeature)WorldGenRegistries.func_243663_a((Registry)WorldGenRegistries.field_243654_f, (String)p_244162_0_, p_244162_1_);
    }

    public static void init() {
        if (RatsMod.RATLANTIS_LOADED) {
            RAT_RUINS_SF = RatsWorldRegistry.func_244162_a("rats:ratlantis_ruins_structure", RAT_RUINS.func_236391_a_((IFeatureConfig)NoFeatureConfig.field_236559_b_));
            FLYING_DUTCHRAT_SF = RatsWorldRegistry.func_244162_a("rats:dutchrat_ship", FLYING_DUTCHRAT.func_236391_a_((IFeatureConfig)NoFeatureConfig.field_236559_b_));
            RUNWAY_SF = RatsWorldRegistry.func_244162_a("rats:runway", RUNWAY.func_236391_a_((IFeatureConfig)NoFeatureConfig.field_236559_b_));
        }
    }

    static {
        RATLANTIS_KEY = RegistryKey.func_240903_a_((RegistryKey)Registry.field_243549_ar, (ResourceLocation)new ResourceLocation("rats:ratlantis"));
        RAT_RUINS = new RatlantisRuinsStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
        FLYING_DUTCHRAT = new DutchratShipStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
        RUNWAY = new RunwayStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
    }
}

