/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.world.gen;

import com.github.alexthe666.rats.server.blocks.RatlantisBlockRegistry;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;

public enum RatStructure {
    PILLAR("marble_pillar", true, 30),
    PILLAR_LEANING("marble_pillar_leaning", true, 30),
    PILLAR_THIN("marble_pillar_thin", true, 20),
    PILLAR_COLLECTION("marble_pillar_collection", true, 20),
    HUT("marble_hut", true, 25),
    CHEESE_STATUETTE("cheese_statuette", true, 25),
    SMALL_AQUADUCT("marble_small_aquaduct", false, 0),
    LARGE_AQUADUCT("marble_large_aquaduct", false, 0),
    SPHINX("marble_rat_sphinx", true, 5),
    LINCOLN("marble_rat_lincoln", true, 7),
    HEAD("marble_rat_head", true, 9),
    COLOSSUS("marble_rat_colossus", true, 5),
    TOWER("marble_tower", true, 20),
    TEMPLE("marble_temple", true, 20),
    PALACE("marble_palace", true, 30),
    FORUM("marble_forum", true, 20),
    GIANT_CHEESE("marble_giant_cheese", true, 4);

    private static final BlockState MARBLED_CHEESE_TILE;
    private static final BlockState MARBLED_CHEESE_BRICK;
    private static final BlockState MARBLED_CHEESE_BRICK_MOSSY;
    private static final BlockState MARBLED_CHEESE_BRICK_CRACK;
    private static final BlockState MARBLED_GRASS;
    private static final BlockState MARBLED_DIRT;
    private static NavigableMap<Float, RatStructure> weightMap;
    private static float totalWeight;
    public ResourceLocation structureLoc;
    private boolean gen;
    private int weight;

    private RatStructure(String file, boolean gen, int weight) {
        this.structureLoc = new ResourceLocation("rats", file);
    }

    public static BlockState getRandomCrackedBlock(@Nullable BlockState prev, Random random) {
        float rand = random.nextFloat();
        if (prev != null && prev.func_177230_c() == Blocks.field_150349_c) {
            if ((double)rand < 0.075) {
                return MARBLED_CHEESE_TILE;
            }
            if ((double)rand < 0.3) {
                return MARBLED_CHEESE_BRICK;
            }
            if ((double)rand < 0.55) {
                return MARBLED_CHEESE_BRICK_CRACK;
            }
            if ((double)rand < 0.75) {
                return MARBLED_CHEESE_BRICK_MOSSY;
            }
            return MARBLED_GRASS;
        }
        if ((double)rand < 0.3) {
            return MARBLED_CHEESE_BRICK;
        }
        if ((double)rand < 0.6) {
            return MARBLED_CHEESE_BRICK_CRACK;
        }
        return MARBLED_CHEESE_BRICK_MOSSY;
    }

    static {
        MARBLED_CHEESE_TILE = RatlantisBlockRegistry.MARBLED_CHEESE_TILE.func_176223_P();
        MARBLED_CHEESE_BRICK = RatlantisBlockRegistry.MARBLED_CHEESE_BRICK.func_176223_P();
        MARBLED_CHEESE_BRICK_MOSSY = RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_MOSSY.func_176223_P();
        MARBLED_CHEESE_BRICK_CRACK = RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_CRACKED.func_176223_P();
        MARBLED_GRASS = RatlantisBlockRegistry.MARBLED_CHEESE_GRASS.func_176223_P();
        MARBLED_DIRT = RatlantisBlockRegistry.MARBLED_CHEESE_DIRT.func_176223_P();
        weightMap = new TreeMap<Float, RatStructure>();
    }
}

