/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.exoticbirds.capabilities.BirdTrackingProvider;
import net.pavocado.exoticbirds.client.gui.CachedEntry;
import net.pavocado.exoticbirds.client.gui.buttons.BirdVariantButton;
import net.pavocado.exoticbirds.client.gui.buttons.ChildBirdButton;
import net.pavocado.exoticbirds.client.gui.buttons.EntityTypeButton;
import net.pavocado.exoticbirds.client.gui.buttons.RotateBirdButton;
import net.pavocado.exoticbirds.client.gui.buttons.SmallArrowButton;
import net.pavocado.exoticbirds.client.gui.buttons.ToggleSpinBirdButton;
import net.pavocado.exoticbirds.entity.EntityAbstractBird;

@OnlyIn(value=Dist.CLIENT)
public class ScreenBirdBook
extends Screen {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("exoticbirds:textures/gui/birdbook.png");
    private TextFieldWidget searchField;
    private RotateBirdButton buttonLeft;
    private RotateBirdButton buttonRight;
    private ToggleSpinBirdButton buttonSpin;
    private ChildBirdButton buttonToggleChild;
    private SmallArrowButton biomeScrollLeft;
    private SmallArrowButton biomeScrollRight;
    private SmallArrowButton tamedItemsScrollLeft;
    private SmallArrowButton tamedItemsScrollRight;
    private SmallArrowButton bredItemsScrollLeft;
    private SmallArrowButton bredItemsScrollRight;
    private List<EntityTypeButton> entityTypeButtons;
    private List<BirdVariantButton> birdVariantButtons;
    public static Set<Map.Entry<EntityType, Integer>> trackedBirds = new HashSet<Map.Entry<EntityType, Integer>>();
    private List<EntityType> searchedBirdList = Lists.newArrayList();
    public static Set<Map.Entry<EntityType, List<Biome>>> birdBiomes = new HashSet<Map.Entry<EntityType, List<Biome>>>();
    public CachedEntry cachedEntry;
    private int rotateAngle;
    private int bredItemIndex;
    private int tamedItemIndex;
    private int biomeListIndex;
    private boolean autoRotate = false;
    private ItemStack hoveredItemStack;
    private float currentMainScroll;
    private float currentSideScroll;
    private boolean isMainScrolling;
    private boolean isSideScrolling;
    private int xSize = 256;
    private int ySize = 166;

    public ScreenBirdBook(PlayerEntity player) {
        super((ITextComponent)new StringTextComponent(""));
        if (player != null) {
            player.getCapability(BirdTrackingProvider.BIRD_TRACKING_CAPABILITY).ifPresent(cap -> {
                trackedBirds = cap.getAll();
            });
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        RenderHelper.func_227783_c_();
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND);
        int x = (this.field_230708_k_ - this.xSize) / 2;
        int y = (this.field_230709_l_ - this.ySize) / 2;
        this.func_238474_b_(matrixStack, x, y, 0, 0, this.xSize, this.ySize);
        this.func_238474_b_(matrixStack, x + 69, (int)((float)(y + 22) + 122.0f * this.currentMainScroll), this.searchedBirdList.size() > this.entityTypeButtons.size() ? 0 : 9, 220, 9, 13);
        this.func_238474_b_(matrixStack, x + 240, (int)((float)(y + 96) + 47.0f * this.currentSideScroll), this.cachedEntry != null && this.cachedEntry.getBirdVariantList().size() > this.birdVariantButtons.size() ? 0 : 9, 233, 9, 13);
        this.searchField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.hoveredItemStack = null;
        if (this.cachedEntry != null) {
            EntityAbstractBird birdEntity = this.cachedEntry.getCachedEntity();
            birdEntity.func_230245_c_(true);
            this.field_230712_o_.func_238421_b_(matrixStack, birdEntity.func_145748_c_().getString(), (float)(x + 96), (float)(y + 8), 0);
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            this.field_230712_o_.func_238421_b_(matrixStack, this.cachedEntry.getFamilyName(), (float)((x + 96) * 2), (float)((y + 17) * 2), 0x404040);
            this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"book.exoticbirds.variant_count", (Object[])new Object[]{this.cachedEntry.getDiscoveredVariants(), this.cachedEntry.getBirdVariantList().size()}), (float)((x + 96) * 2), (float)((y + 23) * 2), 0x404040);
            this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"book.exoticbirds.egg", (Object[])new Object[0]), (float)((x + 96) * 2), (float)((y + 36) * 2), 0);
            this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"book.exoticbirds.breeding_items", (Object[])new Object[0]), (float)((x + 127) * 2), (float)((y + 36) * 2), 0);
            this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"book.exoticbirds.taming_items", (Object[])new Object[0]), (float)((x + 127) * 2), (float)((y + 57) * 2), 0);
            this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"book.exoticbirds.biomes", (Object[])new Object[0]), (float)((x + 96) * 2), (float)((y + 77) * 2), 0);
            matrixStack.func_227865_b_();
            float f = 2.0f;
            float f1 = Math.max(birdEntity.func_213311_cf(), birdEntity.func_213302_cg());
            if ((double)f1 > 1.0) {
                f /= f1;
            }
            this.drawEntityOnScreen(matrixStack, x + 215, y + 70, (int)(f * 20.0f), x + 180 - mouseX, y + 45 - 30 - mouseY, this.cachedEntry);
            CachedEntry.BirdVariantEntry currentVariant = this.cachedEntry.getCurrentVariant();
            if (currentVariant.getVariantName().length() > 0) {
                matrixStack.func_227860_a_();
                matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
                ScreenBirdBook.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)currentVariant.getVariantName(), (int)((x + 216) * 2), (int)((y + 15) * 2), (int)0xFFFFFF);
                if (birdEntity.func_70631_g_()) {
                    ScreenBirdBook.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"book.exoticbirds.child", (Object[])new Object[0]), (int)((x + 216) * 2), (int)((y + 21) * 2), (int)0xFFFFFF);
                }
                matrixStack.func_227865_b_();
            }
            List<ItemStack> breedingItems = this.cachedEntry.getBreedingItems();
            for (int i = 0; i < 4; ++i) {
                if (i + this.bredItemIndex >= breedingItems.size()) continue;
                this.drawItemStack(breedingItems.get(i + this.bredItemIndex), x + 124 + i * 14, y + 40);
                if (!this.isItemSelected(x + 124 + i * 14, y + 40, 16, mouseX, mouseY)) continue;
                this.hoveredItemStack = breedingItems.get(i + this.bredItemIndex);
            }
            if (breedingItems.size() == 0) {
                matrixStack.func_227860_a_();
                matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
                this.field_230712_o_.func_238421_b_(matrixStack, "\u00a7o" + I18n.func_135052_a((String)"book.exoticbirds.cannot_breed", (Object[])new Object[0]), (float)((x + 127) * 2), (float)((y + 43) * 2), 0x404040);
                matrixStack.func_227865_b_();
            }
            List<ItemStack> tamingItems = this.cachedEntry.getTamingItems();
            for (int i = this.tamedItemIndex; i < 4; ++i) {
                if (i + this.tamedItemIndex >= tamingItems.size()) continue;
                this.drawItemStack(tamingItems.get(i + this.tamedItemIndex), x + 124 + i * 14, y + 61);
                if (!this.isItemSelected(x + 124 + i * 14, y + 61, 16, mouseX, mouseY)) continue;
                this.hoveredItemStack = tamingItems.get(i + this.tamedItemIndex);
            }
            if (tamingItems.size() == 0) {
                matrixStack.func_227860_a_();
                matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
                this.field_230712_o_.func_238421_b_(matrixStack, "\u00a7o" + I18n.func_135052_a((String)"book.exoticbirds.cannot_tame", (Object[])new Object[0]), (float)((x + 127) * 2), (float)((y + 64) * 2), 0x404040);
                matrixStack.func_227865_b_();
            }
            List<Biome> biomeList = this.cachedEntry.getBiomeList();
            for (int i = 0; i < 15; ++i) {
                Biome currentBiome;
                matrixStack.func_227860_a_();
                matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
                if (biomeList.size() <= 15) {
                    if (i < biomeList.size()) {
                        currentBiome = biomeList.get(i);
                        this.field_230712_o_.func_238421_b_(matrixStack, currentBiome.getRegistryName().toString(), (float)((x + 98) * 2), (float)((y + 83 + i * 5) * 2), 0x404040);
                    } else if (biomeList.size() == 0) {
                        this.field_230712_o_.func_238421_b_(matrixStack, "\u00a7o" + I18n.func_135052_a((String)"book.exoticbirds.not_available", (Object[])new Object[0]), (float)((x + 98) * 2), (float)((y + 83) * 2), 0x404040);
                    }
                } else if (this.biomeListIndex == 0) {
                    if (i < 14) {
                        currentBiome = biomeList.get(i);
                        this.field_230712_o_.func_238421_b_(matrixStack, currentBiome.getRegistryName().toString(), (float)((x + 98) * 2), (float)((y + 83 + i * 5) * 2), 0x404040);
                    } else {
                        this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"book.exoticbirds.more_items", (Object[])new Object[]{biomeList.size() - 14}), (float)((x + 98) * 2), (float)((y + 83 + i * 5) * 2), 0x404040);
                    }
                } else if (biomeList.size() <= 28 + (this.biomeListIndex - 1) * 13) {
                    if (i == 0) {
                        this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"book.exoticbirds.previous_items", (Object[])new Object[]{14 + 13 * (this.biomeListIndex - 1)}), (float)((x + 98) * 2), (float)((y + 83) * 2), 0x404040);
                    } else if (i - 1 + (14 + 13 * (this.biomeListIndex - 1)) < biomeList.size()) {
                        currentBiome = biomeList.get(i - 1 + (14 + 13 * (this.biomeListIndex - 1)));
                        this.field_230712_o_.func_238421_b_(matrixStack, currentBiome.getRegistryName().toString(), (float)((x + 98) * 2), (float)((y + 83 + i * 5) * 2), 0x404040);
                    }
                } else if (i == 0) {
                    this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"book.exoticbirds.previous_items", (Object[])new Object[]{14 + 13 * (this.biomeListIndex - 1)}), (float)((x + 98) * 2), (float)((y + 83) * 2), 0x404040);
                } else if (i == 14) {
                    this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"book.exoticbirds.more_items", (Object[])new Object[]{14 + 13 * this.biomeListIndex}), (float)((x + 98) * 2), (float)((y + 83 + i * 5) * 2), 0x404040);
                } else if (i - 1 + (14 + 13 * (this.biomeListIndex - 1)) < biomeList.size()) {
                    currentBiome = biomeList.get(i - 1 + (14 + 13 * (this.biomeListIndex - 1)));
                    this.field_230712_o_.func_238421_b_(matrixStack, currentBiome.getRegistryName().toString(), (float)((x + 98) * 2), (float)((y + 83 + i * 5) * 2), 0x404040);
                }
                matrixStack.func_227865_b_();
            }
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)2.0f, (float)2.0f, (float)2.0f);
            this.drawItemStack(this.cachedEntry.getBirdEgg(), (x + 94) / 2, (y + 40) / 2);
            RenderSystem.popMatrix();
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        RenderHelper.func_227784_d_();
        this.renderHoveredToolTip(matrixStack, mouseX, mouseY);
    }

    private boolean isItemSelected(int topLeft, int topRight, int size, double mouseX, double mouseY) {
        return mouseX >= (double)(topLeft - 1) && mouseX < (double)(topLeft + size + 1) && mouseY >= (double)(topRight - 1) && mouseY < (double)(topRight + size + 1);
    }

    protected void func_231160_c_() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        int x = (this.field_230708_k_ - this.xSize) / 2;
        int y = (this.field_230709_l_ - this.ySize) / 2;
        this.buttonLeft = (RotateBirdButton)this.func_230480_a_((Widget)new RotateBirdButton(x + 190, y + 76, true, button -> {
            this.rotateAngle += 45;
            this.rotateAngle = MathHelper.func_188209_b((int)this.rotateAngle);
        }));
        this.buttonRight = (RotateBirdButton)this.func_230480_a_((Widget)new RotateBirdButton(x + 232, y + 76, false, button -> {
            this.rotateAngle -= 45;
            this.rotateAngle = MathHelper.func_188209_b((int)this.rotateAngle);
        }));
        this.buttonSpin = (ToggleSpinBirdButton)this.func_230480_a_((Widget)new ToggleSpinBirdButton(x + 203, y + 77, button -> {
            boolean bl = this.autoRotate = !this.autoRotate;
            if (this.autoRotate) {
                button.func_238482_a_((ITextComponent)new TranslationTextComponent("book.exoticbirds.button.pause"));
            } else {
                button.func_238482_a_((ITextComponent)new TranslationTextComponent("book.exoticbirds.button.spin"));
            }
        }));
        this.buttonToggleChild = (ChildBirdButton)this.func_230480_a_((Widget)new ChildBirdButton(x + 163, y + 10, button -> {
            EntityAbstractBird entity;
            if (this.cachedEntry != null && (entity = this.cachedEntry.getCachedEntity()) != null) {
                if (entity.func_70631_g_()) {
                    entity.func_70873_a(0);
                } else {
                    entity.func_70873_a(-24000);
                }
            }
        }));
        this.biomeScrollLeft = (SmallArrowButton)this.func_230480_a_((Widget)new SmallArrowButton(x + 167, y + 77, true, button -> {
            this.biomeListIndex = MathHelper.func_76125_a((int)(--this.biomeListIndex), (int)0, (int)MathHelper.func_76123_f((float)(this.cachedEntry.getBiomeList().size() / 13)));
            this.biomeScrollLeft.field_230694_p_ = this.biomeListIndex > 0;
            this.biomeScrollRight.field_230694_p_ = true;
        }));
        this.biomeScrollRight = (SmallArrowButton)this.func_230480_a_((Widget)new SmallArrowButton(x + 175, y + 77, false, button -> {
            this.biomeListIndex = MathHelper.func_76125_a((int)(++this.biomeListIndex), (int)0, (int)MathHelper.func_76123_f((float)(this.cachedEntry.getBiomeList().size() / 13)));
            this.biomeScrollRight.field_230694_p_ = this.cachedEntry.getBiomeList().size() > 15 + this.biomeListIndex * 13 + (this.biomeListIndex > 0 ? 1 : 0);
            this.biomeScrollLeft.field_230694_p_ = true;
        }));
        this.tamedItemsScrollLeft = (SmallArrowButton)this.func_230480_a_((Widget)new SmallArrowButton(x + 167, y + 54, true, button -> {
            this.tamedItemIndex = MathHelper.func_76125_a((int)(--this.tamedItemIndex), (int)0, (int)(this.cachedEntry.getTamingItems().size() - 4));
            this.tamedItemsScrollLeft.field_230694_p_ = this.tamedItemIndex > 0;
            this.tamedItemsScrollRight.field_230694_p_ = true;
        }));
        this.tamedItemsScrollRight = (SmallArrowButton)this.func_230480_a_((Widget)new SmallArrowButton(x + 175, y + 54, false, button -> {
            this.tamedItemIndex = MathHelper.func_76125_a((int)(++this.tamedItemIndex), (int)0, (int)(this.cachedEntry.getTamingItems().size() - 4));
            this.tamedItemsScrollRight.field_230694_p_ = this.tamedItemIndex < this.cachedEntry.getTamingItems().size() - 4;
            this.tamedItemsScrollLeft.field_230694_p_ = true;
        }));
        this.bredItemsScrollLeft = (SmallArrowButton)this.func_230480_a_((Widget)new SmallArrowButton(x + 167, y + 33, true, button -> {
            this.bredItemIndex = MathHelper.func_76125_a((int)(--this.bredItemIndex), (int)0, (int)(this.cachedEntry.getBreedingItems().size() - 4));
            this.bredItemsScrollLeft.field_230694_p_ = this.bredItemIndex > 0;
            this.bredItemsScrollRight.field_230694_p_ = true;
        }));
        this.bredItemsScrollRight = (SmallArrowButton)this.func_230480_a_((Widget)new SmallArrowButton(x + 175, y + 33, false, button -> {
            this.bredItemIndex = MathHelper.func_76125_a((int)(++this.bredItemIndex), (int)0, (int)(this.cachedEntry.getBreedingItems().size() - 4));
            this.bredItemsScrollRight.field_230694_p_ = this.bredItemIndex < this.cachedEntry.getBreedingItems().size() - 4;
            this.bredItemsScrollLeft.field_230694_p_ = true;
        }));
        ArrayList tempEntityTypeButtons = Lists.newArrayList();
        for (int i = 0; i < 9; ++i) {
            EntityTypeButton birdButton = (EntityTypeButton)this.func_230480_a_((Widget)new EntityTypeButton(x + 6, y + 22 + i * 15, button -> this.updatePageInfo(((EntityTypeButton)button).getEntityType())));
            tempEntityTypeButtons.add(birdButton);
        }
        this.entityTypeButtons = tempEntityTypeButtons;
        ArrayList tempBirdVariantButtons = Lists.newArrayList();
        for (int i = 0; i < 5; ++i) {
            BirdVariantButton birdButton = (BirdVariantButton)this.func_230480_a_((Widget)new BirdVariantButton(x + 184, y + 96 + i * 12, button -> {
                if (this.cachedEntry != null) {
                    this.cachedEntry.setCurrentVariant(((BirdVariantButton)button).getVariantEntry());
                }
            }));
            tempBirdVariantButtons.add(birdButton);
        }
        this.birdVariantButtons = tempBirdVariantButtons;
        this.tamedItemsScrollLeft.field_230694_p_ = false;
        this.tamedItemsScrollRight.field_230694_p_ = false;
        this.bredItemsScrollLeft.field_230694_p_ = false;
        this.bredItemsScrollRight.field_230694_p_ = false;
        this.biomeScrollLeft.field_230694_p_ = false;
        this.biomeScrollRight.field_230694_p_ = false;
        this.field_230712_o_.getClass();
        this.searchField = new TextFieldWidget(this.field_230712_o_, x + 9, y + 9, 69, 9, (ITextComponent)new TranslationTextComponent("itemGroup.search"));
        this.searchField.func_146203_f(20);
        this.searchField.func_146185_a(false);
        this.searchField.func_146189_e(true);
        this.searchField.func_146193_g(0xFFFFFF);
        this.searchField.func_146205_d(false);
        this.searchField.func_146195_b(true);
        this.field_230705_e_.add(this.searchField);
        this.updateBirdSearch();
        if (this.searchedBirdList.size() > 0) {
            this.updatePageInfo(this.searchedBirdList.get(0));
        }
    }

    public void func_231164_f_() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    public void func_231023_e_() {
        if (this.searchField != null) {
            this.searchField.func_146178_a();
        }
        if (this.autoRotate) {
            this.rotateAngle = MathHelper.func_188209_b((int)(this.rotateAngle += 5));
        }
    }

    public void func_231152_a_(Minecraft minecraft, int width, int height) {
        String s = this.searchField.func_146179_b();
        CachedEntry entry = this.cachedEntry;
        int rotateAngle = this.rotateAngle;
        boolean autoRotate = this.autoRotate;
        this.func_231158_b_(minecraft, width, height);
        this.searchField.func_146180_a(s);
        if (!this.searchField.func_146179_b().isEmpty()) {
            this.updateBirdSearch();
        }
        if (entry != null) {
            this.updatePageInfo(entry);
        }
        this.rotateAngle = rotateAngle;
        this.autoRotate = autoRotate;
    }

    public boolean func_231042_a_(char charIn, int keyCode) {
        String s = this.searchField.func_146179_b();
        if (this.searchField.func_231042_a_(charIn, keyCode)) {
            if (!Objects.equals(s, this.searchField.func_146179_b())) {
                this.currentMainScroll = 0.0f;
                this.updateBirdSearch();
            }
            return true;
        }
        return false;
    }

    public boolean func_231046_a_(int keyCode, int p_keyPressed_2_, int p_keyPressed_3_) {
        String s = this.searchField.func_146179_b();
        if (this.searchField.func_231046_a_(keyCode, p_keyPressed_2_, p_keyPressed_3_)) {
            if (!Objects.equals(s, this.searchField.func_146179_b())) {
                this.currentMainScroll = 0.0f;
                this.updateBirdSearch();
            }
            return true;
        }
        return keyCode != 256 || super.func_231046_a_(keyCode, p_keyPressed_2_, p_keyPressed_3_);
    }

    private void updateBirdSearch() {
        this.searchedBirdList.clear();
        String s1 = this.searchField.func_146179_b().toLowerCase();
        for (EntityType entityType : Registry.field_212629_r) {
            if (!TextFormatting.func_110646_a((String)I18n.func_135052_a((String)entityType.func_210760_d(), (Object[])new Object[0])).toLowerCase().contains(s1)) continue;
            try {
                if (!(entityType.func_200721_a((World)this.field_230706_i_.field_71441_e) instanceof EntityAbstractBird)) continue;
                this.searchedBirdList.add(entityType);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        Collections.sort(this.searchedBirdList, new Comparator<EntityType>(){

            @Override
            public int compare(EntityType first, EntityType second) {
                return I18n.func_135052_a((String)first.func_210760_d(), (Object[])new Object[0]).compareTo(I18n.func_135052_a((String)second.func_210760_d(), (Object[])new Object[0]));
            }
        });
        this.updateEntityTypeButtons();
    }

    public void drawEntityOnScreen(MatrixStack matrixStack, int posX, int posY, int posZ, float mouseX, float mouseY, CachedEntry cachedEntry) {
        EntityAbstractBird entity = cachedEntry.getCachedEntity();
        CachedEntry.BirdVariantEntry currentVariant = cachedEntry.getCurrentVariant();
        float mouseAngleY = (float)Math.atan(mouseY / 40.0f);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)posX, (double)posY, 1050.0);
        matrixStack.func_227862_a_(1.0f, 1.0f, -1.0f);
        matrixStack.func_227861_a_(0.0, 0.0, 1000.0);
        matrixStack.func_227862_a_((float)posZ, (float)posZ, (float)posZ);
        Quaternion lvt_9_1_ = Vector3f.field_229183_f_.func_229187_a_(180.0f);
        Quaternion lvt_10_1_ = Vector3f.field_229179_b_.func_229187_a_(mouseAngleY * 20.0f);
        lvt_9_1_.func_195890_a(lvt_10_1_);
        matrixStack.func_227863_a_(lvt_9_1_);
        float lvt_11_1_ = entity.field_70761_aq;
        float lvt_12_1_ = entity.field_70177_z;
        float lvt_13_1_ = entity.field_70125_A;
        float lvt_14_1_ = entity.field_70758_at;
        float lvt_15_1_ = entity.field_70759_as;
        entity.field_70761_aq = this.rotateAngle;
        entity.field_70177_z = this.rotateAngle;
        entity.field_70125_A = -mouseAngleY * 20.0f;
        entity.field_70759_as = entity.field_70177_z;
        entity.field_70758_at = entity.field_70177_z;
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        lvt_10_1_.func_195892_e();
        renderManager.func_229089_a_(lvt_10_1_);
        renderManager.func_178633_a(false);
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        int packedLight = !currentVariant.isVariantUnlocked() ? -15728880 : 0xF000F0;
        RenderSystem.runAsFancy(() -> renderManager.func_229084_a_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack, (IRenderTypeBuffer)buffer, packedLight));
        buffer.func_228461_a_();
        renderManager.func_178633_a(true);
        entity.field_70761_aq = lvt_11_1_;
        entity.field_70177_z = lvt_12_1_;
        entity.field_70125_A = lvt_13_1_;
        entity.field_70758_at = lvt_14_1_;
        entity.field_70759_as = lvt_15_1_;
        matrixStack.func_227865_b_();
    }

    private void renderHoveredToolTip(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.hoveredItemStack != null && !this.hoveredItemStack.func_190926_b()) {
            this.func_230457_a_(matrixStack, this.hoveredItemStack, mouseX, mouseY);
        }
    }

    private void updateEntityTypeButtons() {
        for (EntityTypeButton button : this.entityTypeButtons) {
            button.setEntityType(null);
            button.field_230694_p_ = false;
        }
        for (int i = 0; i < MathHelper.func_76125_a((int)this.searchedBirdList.size(), (int)0, (int)this.entityTypeButtons.size()); ++i) {
            EntityTypeButton button;
            button = this.entityTypeButtons.get(i);
            int birdIndex = i + MathHelper.func_76125_a((int)((int)(this.currentMainScroll * (float)(this.searchedBirdList.size() - this.entityTypeButtons.size()))), (int)0, (int)this.searchedBirdList.size());
            button.setEntityType(this.searchedBirdList.get(birdIndex));
            button.field_230694_p_ = true;
        }
    }

    private void updateVariantButtons() {
        for (BirdVariantButton button : this.birdVariantButtons) {
            button.setVariantInfo(null);
            button.field_230694_p_ = false;
        }
        if (this.cachedEntry != null) {
            List<CachedEntry.BirdVariantEntry> birdVariantList = this.cachedEntry.getBirdVariantList();
            for (int i = 0; i < MathHelper.func_76125_a((int)birdVariantList.size(), (int)0, (int)this.birdVariantButtons.size()); ++i) {
                BirdVariantButton button = this.birdVariantButtons.get(i);
                int birdIndex = i + MathHelper.func_76125_a((int)((int)(this.currentSideScroll * (float)(birdVariantList.size() - this.birdVariantButtons.size()))), (int)0, (int)birdVariantList.size());
                button.setVariantInfo(birdVariantList.get(birdIndex));
                button.field_230694_p_ = true;
            }
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.inMainScrollbar(mouseX, mouseY)) {
                this.isMainScrolling = true;
                return true;
            }
            if (this.inSideScrollbar(mouseX, mouseY)) {
                this.isSideScrolling = true;
                return true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isMainScrolling = false;
            this.isSideScrolling = false;
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        int x = (this.field_230708_k_ - this.xSize) / 2;
        if (mouseX - (double)x < 84.0 && this.searchedBirdList.size() > this.entityTypeButtons.size()) {
            int i = this.searchedBirdList.size() - this.entityTypeButtons.size();
            this.currentMainScroll = (float)((double)this.currentMainScroll - amount / (double)i);
            this.currentMainScroll = MathHelper.func_76131_a((float)this.currentMainScroll, (float)0.0f, (float)1.0f);
            this.updateEntityTypeButtons();
            return true;
        }
        if (mouseX - (double)x > 84.0 && this.cachedEntry != null && this.cachedEntry.getBirdVariantList().size() > this.birdVariantButtons.size()) {
            int i = this.cachedEntry.getBirdVariantList().size() - this.birdVariantButtons.size();
            this.currentSideScroll = (float)((double)this.currentSideScroll - amount / (double)i);
            this.currentSideScroll = MathHelper.func_76131_a((float)this.currentSideScroll, (float)0.0f, (float)1.0f);
            this.updateVariantButtons();
            return true;
        }
        return false;
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        int y = (this.field_230709_l_ - this.ySize) / 2;
        if (this.isMainScrolling && this.searchedBirdList.size() > this.entityTypeButtons.size()) {
            int i = y + 22;
            this.currentMainScroll = ((float)mouseY - (float)i - 7.5f) / 121.0f;
            this.currentMainScroll = MathHelper.func_76131_a((float)this.currentMainScroll, (float)0.0f, (float)1.0f);
            this.updateEntityTypeButtons();
            return true;
        }
        if (this.isSideScrolling && this.cachedEntry != null && this.cachedEntry.getBirdVariantList().size() > this.birdVariantButtons.size()) {
            int i = y + 96;
            this.currentSideScroll = ((float)mouseY - (float)i - 7.5f) / 46.0f;
            this.currentSideScroll = MathHelper.func_76131_a((float)this.currentSideScroll, (float)0.0f, (float)1.0f);
            this.updateVariantButtons();
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    private boolean inMainScrollbar(double mouseX, double mouseY) {
        int x = (this.field_230708_k_ - this.xSize) / 2;
        int y = (this.field_230709_l_ - this.ySize) / 2;
        int i = x + 69;
        int j = y + 22;
        int k = i + 9;
        int l = j + 136;
        return mouseX >= (double)i && mouseY >= (double)j && mouseX < (double)k && mouseY < (double)l;
    }

    private boolean inSideScrollbar(double mouseX, double mouseY) {
        int x = (this.field_230708_k_ - this.xSize) / 2;
        int y = (this.field_230709_l_ - this.ySize) / 2;
        int i = x + 237;
        int j = y + 96;
        int k = i + 9;
        int l = j + 135;
        return mouseX >= (double)i && mouseY >= (double)j && mouseX < (double)k && mouseY < (double)l;
    }

    private void updatePageInfo(CachedEntry cachedEntry) {
        this.cachedEntry = cachedEntry;
        this.currentSideScroll = 0.0f;
        this.bredItemIndex = 0;
        this.tamedItemIndex = 0;
        this.biomeListIndex = 0;
        if (!this.autoRotate) {
            this.rotateAngle = MathHelper.func_188209_b((int)225);
        }
        if (this.cachedEntry != null) {
            int variantIndex;
            this.biomeScrollRight.field_230694_p_ = this.cachedEntry.getBiomeList().size() > 15;
            this.biomeScrollLeft.field_230694_p_ = false;
            this.bredItemsScrollRight.field_230694_p_ = this.cachedEntry.getBreedingItems().size() > 4;
            this.bredItemsScrollLeft.field_230694_p_ = false;
            this.tamedItemsScrollRight.field_230694_p_ = this.cachedEntry.getTamingItems().size() > 4;
            this.tamedItemsScrollLeft.field_230694_p_ = false;
            if (this.cachedEntry.getBirdVariantList().size() > this.birdVariantButtons.size() && (variantIndex = this.cachedEntry.getBirdVariantList().indexOf(this.cachedEntry.getCurrentVariant())) > 4) {
                this.currentSideScroll = 1 - variantIndex / this.cachedEntry.getBirdVariantList().size();
                this.currentSideScroll = MathHelper.func_76131_a((float)this.currentSideScroll, (float)0.0f, (float)1.0f);
            }
        }
        this.updateVariantButtons();
    }

    private void updatePageInfo(EntityType selectedBirdType) {
        this.updateCachedEntity(selectedBirdType);
        this.updatePageInfo(this.cachedEntry);
    }

    private void updateCachedEntity(EntityType selectedBirdType) {
        Entity entity;
        this.cachedEntry = null;
        if (selectedBirdType != null && (entity = selectedBirdType.func_200721_a((World)this.field_230706_i_.field_71441_e)) instanceof EntityAbstractBird) {
            this.cachedEntry = new CachedEntry((EntityAbstractBird)entity);
        }
    }

    private void drawItemStack(ItemStack stack, int x, int y) {
        this.field_230707_j_.func_184391_a((LivingEntity)this.field_230706_i_.field_71439_g, stack, x, y);
    }

    public static boolean isEntityUnlocked(EntityType entityType, int variant) {
        for (Map.Entry<EntityType, Integer> pair : trackedBirds) {
            if (pair.getKey() != entityType || pair.getValue() != variant) continue;
            return true;
        }
        return false;
    }
}

