/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.entity;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.pavocado.exoticbirds.config.ExoticBirdsConfig;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;

public abstract class EntityAbstractBird
extends TameableEntity {
    protected static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityAbstractBird.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int timeUntilNextEgg;
    protected int numberOfTypes;
    private ItemStack eggType;
    private boolean canFloat;
    private boolean isGendered;
    protected boolean hasChildTextures;
    public float wingRotation;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    public float wingRotDelta;

    public EntityAbstractBird(EntityType<? extends EntityAbstractBird> type, World worldIn, ItemStack itemEggIn, int typesCountIn, boolean canFloatIn, boolean isGenderedIn) {
        super(type, worldIn);
        this.timeUntilNextEgg = this.field_70146_Z.nextInt(6000) + ExoticBirdsConfig.eggLayRate;
        this.hasChildTextures = false;
        this.wingRotDelta = 1.0f;
        this.eggType = itemEggIn;
        this.numberOfTypes = typesCountIn;
        this.canFloat = canFloatIn;
        this.isGendered = isGenderedIn;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (spawnDataIn == null) {
            this.setVariant(this.field_70146_Z.nextInt(this.numberOfTypes));
            spawnDataIn = new FlockData(this);
        } else if (spawnDataIn instanceof FlockData) {
            this.setVariant(((FlockData)((Object)spawnDataIn)).flockLeader.getChildVariant());
        } else {
            this.setVariant(this.field_70146_Z.nextInt(this.numberOfTypes));
        }
        return spawnDataIn;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    public final ResourceLocation getBirdTypeName() {
        return this.getBirdTypeName(this.getVariant(), false);
    }

    public final ResourceLocation getBirdTypeName(int variant, boolean ignoreChild) {
        if (this.func_70631_g_() && this.hasChildTextures && !ignoreChild) {
            return this.getBirdTypeNameForChild();
        }
        return this.getEntityTextures().get(variant);
    }

    private ResourceLocation getBirdTypeNameForChild() {
        String resourceName = this.getEntityTextures().get(this.getVariant()).toString().replace("_male", "").replace("_female", "").replace(".png", "_chick.png");
        return new ResourceLocation(resourceName);
    }

    @OnlyIn(value=Dist.CLIENT)
    public final String getTranslatedVariantName(int variant, boolean ignoreGender) {
        String resourceName = this.getBirdTypeName(variant, true).toString();
        resourceName = resourceName.substring(resourceName.lastIndexOf(47) + 1).replace(".png", "");
        Gender gender = this.getGender(variant);
        if (gender != Gender.NONE) {
            resourceName = resourceName.replace("_male", "").replace("_female", "");
            String genderString = gender == Gender.MALE ? "male" : "female";
            return I18n.func_135052_a((String)("exoticbirds.species." + resourceName), (Object[])new Object[0]) + (ignoreGender ? "" : " (" + I18n.func_135052_a((String)("gender.exoticbirds." + genderString), (Object[])new Object[0]) + ")");
        }
        return I18n.func_135052_a((String)("exoticbirds.species." + resourceName), (Object[])new Object[0]);
    }

    protected abstract Map<Integer, ResourceLocation> getEntityTextures();

    public abstract List<String> getBlacklistedDimensions();

    public List<ItemStack> getTamingItems() {
        return Lists.newArrayList();
    }

    public List<ItemStack> getBreedingItems() {
        return Lists.newArrayList();
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.oFlap = this.wingRotation;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed = (float)((double)this.flapSpeed + (double)(this.field_70122_E || this.field_70171_ac ? -1 : 4) * 0.3);
        this.flapSpeed = MathHelper.func_76131_a((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (this.canFloat) {
            if (!this.field_70122_E && this.wingRotDelta < 1.0f && !this.field_70171_ac) {
                this.wingRotDelta = 1.0f;
            }
            this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
            Vector3d Vector3d2 = this.func_213322_ci();
            if (!this.field_70122_E && Vector3d2.field_72448_b < 0.0) {
                this.func_213317_d(Vector3d2.func_216372_d(1.0, 0.6, 1.0));
            }
            this.wingRotation += this.wingRotDelta * 2.0f;
        }
        if (!(this.field_70170_p.field_72995_K || !this.func_70089_S() || this.func_70631_g_() || !ExoticBirdsConfig.allowEggs || --this.timeUntilNextEgg > 0 || this.isGendered && this.getVariant() != 1)) {
            this.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            ItemStack eggStack = this.eggType.func_77946_l();
            CompoundNBT compoundnbt = eggStack.func_190925_c("eggValues");
            compoundnbt.func_74768_a("Variant", this.getChildVariantIgnoreGender());
            this.func_199701_a_(this.eggType);
            this.timeUntilNextEgg = this.field_70146_Z.nextInt(6000) + ExoticBirdsConfig.eggLayRate;
        }
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.func_70909_n() && ExoticBirdsConfig.allowDespawning;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        if (this.canFloat) {
            return super.func_225503_b_(distance, damageMultiplier);
        }
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        if (this.canFloat) {
            super.func_184231_a(y, onGroundIn, state, pos);
        }
    }

    public int func_70627_aG() {
        return 200;
    }

    public CreatureAttribute func_70668_bt() {
        return ExoticBirdsEntities.BIRD;
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (otherAnimal.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        if (this.func_70880_s() && otherAnimal.func_70880_s()) {
            if (this.isGendered) {
                int otherVariant = ((EntityAbstractBird)otherAnimal).getVariant();
                return otherVariant / 2 == this.getVariant() / 2 && otherVariant != this.getVariant();
            }
            return ((EntityAbstractBird)otherAnimal).getVariant() == this.getVariant();
        }
        return false;
    }

    public int getVariant() {
        return MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(VARIANT)), (int)0, (int)(this.numberOfTypes - 1));
    }

    public void setVariant(int variantIn) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variantIn);
    }

    public int getVariantCount() {
        return this.numberOfTypes;
    }

    public ItemStack getEgg() {
        return this.eggType;
    }

    public Gender getGender(int variant) {
        if (!this.isGendered) {
            return Gender.NONE;
        }
        return variant % 2 == 0 ? Gender.MALE : Gender.FEMALE;
    }

    public int getChildVariant() {
        if (this.isGendered) {
            return 2 * (this.getVariant() / 2) + this.field_70146_Z.nextInt(2);
        }
        return this.getVariant();
    }

    public final int getChildVariantIgnoreGender() {
        return 2 * (this.getChildVariant() / 2);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("EggLayTime")) {
            this.timeUntilNextEgg = compound.func_74762_e("EggLayTime");
        }
        this.setVariant(compound.func_74762_e("Variant"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74768_a("EggLayTime", this.timeUntilNextEgg);
    }

    public SoundEvent getBirdcageSound() {
        return this.func_184639_G();
    }

    public float getBirdcagePitch() {
        return this.func_70647_i();
    }

    public IPacket func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static class FlockData
    extends AgeableEntity.AgeableData {
        public final EntityAbstractBird flockLeader;

        public FlockData(EntityAbstractBird flockLeaderIn, float spawnProbability) {
            super(spawnProbability);
            this.flockLeader = flockLeaderIn;
        }

        public FlockData(EntityAbstractBird flockLeaderIn) {
            super(0.0f);
            this.flockLeader = flockLeaderIn;
        }
    }

    public static enum Gender {
        NONE,
        MALE,
        FEMALE;

    }
}

