/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import net.pavocado.exoticbirds.entity.EntityAbstractBird;

public class PacketLogBird {
    private final int entityId;
    private final boolean isNewEntry;

    public PacketLogBird(int entityId, boolean isNewEntry) {
        this.entityId = entityId;
        this.isNewEntry = isNewEntry;
    }

    public static void encode(PacketLogBird message, PacketBuffer buffer) {
        buffer.writeInt(message.entityId);
        buffer.writeBoolean(message.isNewEntry);
    }

    public static PacketLogBird decode(PacketBuffer buffer) {
        return new PacketLogBird(buffer.readInt(), buffer.readBoolean());
    }

    public static void handle(PacketLogBird packet, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> PacketLogBird.handleOnClient(packet)));
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleOnClient(PacketLogBird packet) {
        Entity entity;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && (entity = player.field_70170_p.func_73045_a(packet.entityId)) instanceof EntityAbstractBird) {
            EntityAbstractBird birdEntity = (EntityAbstractBird)entity;
            String variantName = birdEntity.func_200200_C_().getString();
            if (packet.isNewEntry) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("book.exoticbirds.log_new", new Object[]{variantName.toLowerCase()}).func_240699_a_(TextFormatting.AQUA), Util.field_240973_b_);
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("book.exoticbirds.log_old", new Object[]{variantName}).func_240699_a_(TextFormatting.GRAY), Util.field_240973_b_);
            }
            String speciesName = birdEntity.getTranslatedVariantName(birdEntity.getVariant(), false);
            player.func_145747_a((ITextComponent)new TranslationTextComponent("book.exoticbirds.log_species", new Object[]{speciesName}).func_240699_a_(TextFormatting.GRAY).func_240699_a_(TextFormatting.ITALIC), Util.field_240973_b_);
        }
    }
}

