/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.network;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsPacketHandler;
import net.pavocado.exoticbirds.network.PacketSendBirdBiomes;

public class PacketRequestBirdBiomes {
    private final EntityType entityType;

    public PacketRequestBirdBiomes(EntityType entityType) {
        this.entityType = entityType;
    }

    public static void encode(PacketRequestBirdBiomes message, PacketBuffer buffer) {
        ResourceLocation entityName = new ResourceLocation(Registry.field_212629_r.func_177774_c((Object)message.entityType).toString());
        buffer.func_192572_a(entityName);
    }

    public static PacketRequestBirdBiomes decode(PacketBuffer buffer) {
        ResourceLocation entityName = buffer.func_192575_l();
        Optional entityOpt = Registry.field_212629_r.func_241873_b(entityName);
        EntityType entityType = (EntityType)ExoticBirdsEntities.BIRD_EGG.get();
        if (entityOpt.isPresent()) {
            entityType = (EntityType)entityOpt.get();
        }
        return new PacketRequestBirdBiomes(entityType);
    }

    public static void handle(PacketRequestBirdBiomes packet, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ArrayList biomeList = Lists.newArrayList();
            for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
                MobSpawnInfo spawnInfo = biome.func_242433_b();
                for (MobSpawnInfo.Spawners spawn : spawnInfo.func_242559_a(EntityClassification.CREATURE)) {
                    if (spawn.field_242588_c != packet.entityType) continue;
                    biomeList.add(biome);
                }
            }
            ServerPlayerEntity sender = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            ExoticBirdsPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sender), (Object)new PacketSendBirdBiomes(packet.entityType, biomeList));
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

