/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.geoip;

import com.earth2me.essentials.EssentialsConf;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IConf;
import com.earth2me.essentials.User;
import com.earth2me.essentials.geoip.EssentialsGeoIP;
import com.earth2me.essentials.geoip.libs.javatar.TarEntry;
import com.earth2me.essentials.geoip.libs.javatar.TarInputStream;
import com.earth2me.essentials.geoip.libs.maxmind.geoip2.DatabaseReader;
import com.earth2me.essentials.geoip.libs.maxmind.geoip2.exception.AddressNotFoundException;
import com.earth2me.essentials.geoip.libs.maxmind.geoip2.exception.GeoIp2Exception;
import com.earth2me.essentials.geoip.libs.maxmind.geoip2.model.AbstractCityResponse;
import com.earth2me.essentials.geoip.libs.maxmind.geoip2.model.AbstractCountryResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import net.ess3.api.IEssentials;
import net.essentialsx.api.v2.events.AsyncUserDataLoadEvent;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class EssentialsGeoIPPlayerListener
implements Listener,
IConf {
    private static final Logger logger = Logger.getLogger("EssentialsGeoIP");
    private final File dataFolder;
    private final EssentialsConf config;
    private final transient IEssentials ess;
    private DatabaseReader mmreader = null;
    private File databaseFile;

    EssentialsGeoIPPlayerListener(File dataFolder, IEssentials ess) {
        this.ess = ess;
        this.dataFolder = dataFolder;
        this.config = new EssentialsConf(new File(dataFolder, "config.yml"));
        this.config.setTemplateName("/config.yml", EssentialsGeoIP.class);
        this.reloadConfig();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDataLoad(AsyncUserDataLoadEvent event) {
        this.delayedJoin(event.getUser().getBase());
    }

    private void delayedJoin(Player player) {
        User u = this.ess.getUser(player);
        if (u.isAuthorized("essentials.geoip.hide") || player.getAddress() == null) {
            return;
        }
        InetAddress address = player.getAddress().getAddress();
        StringBuilder sb = new StringBuilder();
        if (this.mmreader == null) {
            logger.log(Level.WARNING, I18n.tl((String)"geoIpErrorOnJoin", (Object[])new Object[]{u.getName()}));
            return;
        }
        try {
            AbstractCountryResponse response;
            if (this.config.getBoolean("database.show-cities", false)) {
                response = this.mmreader.city(address);
                if (response == null) {
                    return;
                }
                String city = ((AbstractCityResponse)response).getCity().getName();
                String region = ((AbstractCityResponse)response).getMostSpecificSubdivision().getName();
                String country = response.getCountry().getName();
                if (city != null) {
                    sb.append(city).append(", ");
                }
                if (region != null) {
                    sb.append(region).append(", ");
                }
                sb.append(country);
            } else {
                response = this.mmreader.country(address);
                sb.append(response.getCountry().getName());
            }
        }
        catch (AddressNotFoundException ex) {
            if (this.checkIfLocal(address)) {
                for (Player online : player.getServer().getOnlinePlayers()) {
                    User user = this.ess.getUser(online);
                    if (!user.isAuthorized("essentials.geoip.show")) continue;
                    user.sendMessage(I18n.tl((String)"geoipCantFind", (Object[])new Object[]{u.getDisplayName()}));
                }
                return;
            }
            logger.log(Level.INFO, I18n.tl((String)"cantReadGeoIpDB", (Object[])new Object[0]) + " " + ex.getLocalizedMessage());
        }
        catch (GeoIp2Exception | IOException ex) {
            logger.log(Level.SEVERE, I18n.tl((String)"cantReadGeoIpDB", (Object[])new Object[0]) + " " + ex.getLocalizedMessage());
        }
        if (this.config.getBoolean("show-on-whois", true)) {
            u.setGeoLocation(sb.toString());
        }
        if (this.config.getBoolean("show-on-login", true) && !u.isHidden()) {
            for (Player onlinePlayer : player.getServer().getOnlinePlayers()) {
                User user = this.ess.getUser(onlinePlayer);
                if (!user.isAuthorized("essentials.geoip.show")) continue;
                user.sendMessage(I18n.tl((String)"geoipJoinFormat", (Object[])new Object[]{u.getDisplayName(), sb.toString()}));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void reloadConfig() {
        long diff;
        this.config.load();
        if (!this.config.isSet("enable-locale")) {
            this.config.set("database.download-url", (Object)"https://download.maxmind.com/app/geoip_download?edition_id=GeoLite2-Country&license_key={LICENSEKEY}&suffix=tar.gz");
            this.config.set("database.download-url-city", (Object)"https://download.maxmind.com/app/geoip_download?edition_id=GeoLite2-City&license_key={LICENSEKEY}&suffix=tar.gz");
            this.config.set("database.license-key", (Object)"");
            this.config.set("database.update.enable", (Object)true);
            this.config.set("database.update.by-every-x-days", (Object)30);
            this.config.set("enable-locale", (Object)true);
            this.config.save();
            File oldDatFile = new File(this.dataFolder, "GeoIP.dat");
            File oldDatFileCity = new File(this.dataFolder, "GeoIP-City.dat");
            oldDatFile.delete();
            oldDatFileCity.delete();
        }
        this.databaseFile = this.config.getBoolean("database.show-cities", false) ? new File(this.dataFolder, "GeoIP2-City.mmdb") : new File(this.dataFolder, "GeoIP2-Country.mmdb");
        if (!this.databaseFile.exists()) {
            if (!this.config.getBoolean("database.download-if-missing", true)) {
                logger.log(Level.SEVERE, I18n.tl((String)"cantFindGeoIpDB", (Object[])new Object[0]));
                return;
            }
            this.downloadDatabase();
        } else if (this.config.getBoolean("database.update.enable", true) && (diff = new Date().getTime() - this.databaseFile.lastModified()) / 24L / 3600L / 1000L > this.config.getLong("database.update.by-every-x-days", 30L)) {
            this.downloadDatabase();
        }
        try {
            if (!this.config.getBoolean("enable-locale")) {
                this.mmreader = new DatabaseReader.Builder(this.databaseFile).build();
                return;
            }
            String locale = this.ess.getI18n().getCurrentLocale().toString().replace('_', '-');
            if ("zh".equalsIgnoreCase(locale)) {
                locale = "zh-CN";
            }
            this.mmreader = new DatabaseReader.Builder(this.databaseFile).locales(Arrays.asList(locale, "en")).build();
            return;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, I18n.tl((String)"cantReadGeoIpDB", (Object[])new Object[0]), ex);
        }
    }

    private void downloadDatabase() {
        try {
            String url = this.config.getBoolean("database.show-cities", false) ? this.config.getString("database.download-url-city") : this.config.getString("database.download-url");
            if (url == null || url.isEmpty()) {
                logger.log(Level.SEVERE, I18n.tl((String)"geoIpUrlEmpty", (Object[])new Object[0]));
                return;
            }
            String licenseKey = this.config.getString("database.license-key", "");
            if (licenseKey == null || licenseKey.isEmpty()) {
                logger.log(Level.SEVERE, I18n.tl((String)"geoIpLicenseMissing", (Object[])new Object[0]));
                return;
            }
            url = url.replace("{LICENSEKEY}", licenseKey);
            logger.log(Level.INFO, I18n.tl((String)"downloadingGeoIp", (Object[])new Object[0]));
            URL downloadUrl = new URL(url);
            URLConnection conn = downloadUrl.openConnection();
            conn.setConnectTimeout(10000);
            conn.connect();
            InputStream input = conn.getInputStream();
            FileOutputStream output = new FileOutputStream(this.databaseFile);
            byte[] buffer = new byte[2048];
            if (url.contains("gz")) {
                input = new GZIPInputStream(input);
                if (url.contains("tar.gz")) {
                    TarEntry entry;
                    TarInputStream tarInputStream = new TarInputStream(input);
                    while ((entry = tarInputStream.getNextEntry()) != null) {
                        String filename;
                        if (entry.isDirectory() || !(filename = entry.getName()).substring(filename.length() - 5).equalsIgnoreCase(".mmdb")) continue;
                        input = tarInputStream;
                        break;
                    }
                }
            }
            int length = input.read(buffer);
            while (length >= 0) {
                ((OutputStream)output).write(buffer, 0, length);
                length = input.read(buffer);
            }
            ((OutputStream)output).close();
            input.close();
        }
        catch (MalformedURLException ex) {
            logger.log(Level.SEVERE, I18n.tl((String)"geoIpUrlInvalid", (Object[])new Object[0]), ex);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, I18n.tl((String)"connectionFailed", (Object[])new Object[0]), ex);
        }
    }

    private boolean checkIfLocal(InetAddress address) {
        if (address.isAnyLocalAddress() || address.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(address) != null;
        }
        catch (SocketException e) {
            return false;
        }
    }
}

