/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.geoip.libs.jackson.databind.ser.std;

import com.earth2me.essentials.geoip.libs.jackson.core.JsonGenerator;
import com.earth2me.essentials.geoip.libs.jackson.databind.JavaType;
import com.earth2me.essentials.geoip.libs.jackson.databind.JsonMappingException;
import com.earth2me.essentials.geoip.libs.jackson.databind.SerializerProvider;
import com.earth2me.essentials.geoip.libs.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.earth2me.essentials.geoip.libs.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.earth2me.essentials.geoip.libs.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.earth2me.essentials.geoip.libs.jackson.databind.ser.std.StdScalarSerializer;
import com.earth2me.essentials.geoip.libs.jackson.databind.util.ByteBufferBackedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferSerializer
extends StdScalarSerializer<ByteBuffer> {
    public ByteBufferSerializer() {
        super(ByteBuffer.class);
    }

    @Override
    public void serialize(ByteBuffer bbuf, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (bbuf.hasArray()) {
            gen.writeBinary(bbuf.array(), 0, bbuf.limit());
            return;
        }
        ByteBuffer copy = bbuf.asReadOnlyBuffer();
        if (copy.position() > 0) {
            copy.rewind();
        }
        ByteBufferBackedInputStream in = new ByteBufferBackedInputStream(copy);
        gen.writeBinary(in, copy.remaining());
        in.close();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

