/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.geoip.libs.jackson.databind.ser.std;

import com.earth2me.essentials.geoip.libs.jackson.annotation.JsonFormat;
import com.earth2me.essentials.geoip.libs.jackson.core.JsonGenerator;
import com.earth2me.essentials.geoip.libs.jackson.core.JsonParser;
import com.earth2me.essentials.geoip.libs.jackson.databind.BeanProperty;
import com.earth2me.essentials.geoip.libs.jackson.databind.JavaType;
import com.earth2me.essentials.geoip.libs.jackson.databind.JsonMappingException;
import com.earth2me.essentials.geoip.libs.jackson.databind.JsonNode;
import com.earth2me.essentials.geoip.libs.jackson.databind.JsonSerializer;
import com.earth2me.essentials.geoip.libs.jackson.databind.SerializerProvider;
import com.earth2me.essentials.geoip.libs.jackson.databind.annotation.JacksonStdImpl;
import com.earth2me.essentials.geoip.libs.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.earth2me.essentials.geoip.libs.jackson.databind.ser.ContextualSerializer;
import com.earth2me.essentials.geoip.libs.jackson.databind.ser.std.StdScalarSerializer;
import com.earth2me.essentials.geoip.libs.jackson.databind.ser.std.ToStringSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;

@JacksonStdImpl
public class NumberSerializer
extends StdScalarSerializer<Number>
implements ContextualSerializer {
    public static final NumberSerializer instance = new NumberSerializer((Class<? extends Number>)Number.class);
    protected final boolean _isInt;

    public NumberSerializer(Class<? extends Number> rawType) {
        super(rawType, false);
        this._isInt = rawType == BigInteger.class;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format = this.findFormatOverrides(prov, property, this.handledType());
        if (format != null) {
            switch (format.getShape()) {
                case STRING: {
                    return ToStringSerializer.instance;
                }
            }
        }
        return this;
    }

    @Override
    public void serialize(Number value, JsonGenerator g, SerializerProvider provider) throws IOException {
        if (value instanceof BigDecimal) {
            g.writeNumber((BigDecimal)value);
        } else if (value instanceof BigInteger) {
            g.writeNumber((BigInteger)value);
        } else if (value instanceof Long) {
            g.writeNumber(value.longValue());
        } else if (value instanceof Double) {
            g.writeNumber(value.doubleValue());
        } else if (value instanceof Float) {
            g.writeNumber(value.floatValue());
        } else if (value instanceof Integer || value instanceof Byte || value instanceof Short) {
            g.writeNumber(value.intValue());
        } else {
            g.writeNumber(value.toString());
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode(this._isInt ? "integer" : "number", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        if (this._isInt) {
            this.visitIntFormat(visitor, typeHint, JsonParser.NumberType.BIG_INTEGER);
        } else {
            Class h = this.handledType();
            if (h == BigDecimal.class) {
                this.visitFloatFormat(visitor, typeHint, JsonParser.NumberType.BIG_DECIMAL);
            } else {
                visitor.expectNumberFormat(typeHint);
            }
        }
    }
}

