/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.geoip.libs.jackson.databind.ser.std;

import com.earth2me.essentials.geoip.libs.jackson.core.JsonGenerator;
import com.earth2me.essentials.geoip.libs.jackson.core.JsonToken;
import com.earth2me.essentials.geoip.libs.jackson.core.type.WritableTypeId;
import com.earth2me.essentials.geoip.libs.jackson.databind.JavaType;
import com.earth2me.essentials.geoip.libs.jackson.databind.JsonMappingException;
import com.earth2me.essentials.geoip.libs.jackson.databind.JsonNode;
import com.earth2me.essentials.geoip.libs.jackson.databind.SerializerProvider;
import com.earth2me.essentials.geoip.libs.jackson.databind.annotation.JacksonStdImpl;
import com.earth2me.essentials.geoip.libs.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.earth2me.essentials.geoip.libs.jackson.databind.jsontype.TypeSerializer;
import com.earth2me.essentials.geoip.libs.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

@JacksonStdImpl
public class ToStringSerializer
extends StdSerializer<Object> {
    public static final ToStringSerializer instance = new ToStringSerializer();

    public ToStringSerializer() {
        super(Object.class);
    }

    public ToStringSerializer(Class<?> handledType) {
        super(handledType, false);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Object value) {
        return value.toString().isEmpty();
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeString(value.toString());
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value, JsonToken.VALUE_STRING));
        this.serialize(value, g, provider);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }
}

