/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.block;

import elucent.eidolon.block.BlockBase;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CandlestickBlock
extends BlockBase {
    public static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", d -> d != Direction.DOWN);
    protected static final VoxelShape UP_SHAPE = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)14.0, (double)10.0);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.func_208617_a((double)5.5, (double)3.0, (double)11.0, (double)10.5, (double)16.0, (double)16.0), Block.func_208617_a((double)5.5, (double)3.0, (double)0.0, (double)10.5, (double)16.0, (double)5.0), Block.func_208617_a((double)11.0, (double)3.0, (double)5.5, (double)16.0, (double)16.0, (double)10.5), Block.func_208617_a((double)0.0, (double)3.0, (double)5.5, (double)5.0, (double)16.0, (double)10.5)};

    public CandlestickBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public static VoxelShape getShapeForState(BlockState state) {
        Direction dir = (Direction)state.func_177229_b((Property)FACING);
        if (dir == Direction.UP) {
            return UP_SHAPE;
        }
        return SHAPES[dir.ordinal() - 2];
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return CandlestickBlock.getShapeForState(state);
    }

    @Override
    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        return blockstate.func_224755_d((IBlockReader)worldIn, blockpos, direction);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        if (direction == Direction.UP) {
            return facing == Direction.DOWN && !this.func_196260_a(state, (IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(state, facing, facingState, worldIn, currentPos, facingPos);
        }
        return facing.func_176734_d() == state.func_177229_b((Property)FACING) && !state.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : state;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction[] adirection;
        BlockState blockstate = this.func_176223_P();
        World iworldreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        for (Direction direction : adirection = context.func_196009_e()) {
            Direction direction1;
            if (direction == Direction.UP || !(blockstate = (BlockState)blockstate.func_206870_a((Property)FACING, (Comparable)(direction1 = direction.func_176734_d()))).func_196955_c((IWorldReader)iworldreader, blockpos)) continue;
            return blockstate;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World worldIn, BlockPos pos, Random rand) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 0.925;
        double d2 = (double)pos.func_177952_p() + 0.5;
        if (direction != Direction.UP) {
            d0 -= 0.3 * (double)direction.func_82601_c();
            d1 += 0.125;
            d2 -= 0.3 * (double)direction.func_82599_e();
        }
        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0, d1, d2, 0.0, 0.0, 0.0);
        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return state.func_177229_b((Property)FACING) != Direction.UP ? (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING))) : state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_177229_b((Property)FACING) != Direction.UP ? state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING))) : state;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }
}

