/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.capability;

import elucent.eidolon.capability.IReputation;
import elucent.eidolon.capability.ReputationEntry;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;

public class ReputationImpl
implements IReputation {
    Map<UUID, Map<ResourceLocation, ReputationEntry>> reputationMap = new HashMap<UUID, Map<ResourceLocation, ReputationEntry>>();
    Map<UUID, Long> prayerTimes = new HashMap<UUID, Long>();

    @Override
    public double getReputation(UUID player, ResourceLocation deity) {
        return this.getReputationMap((UUID)player).computeIfAbsent((ResourceLocation)deity, (Function<ResourceLocation, ReputationEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getReputation$0(net.minecraft.util.ResourceLocation ), (Lnet/minecraft/util/ResourceLocation;)Lelucent/eidolon/capability/ReputationEntry;)()).reputation;
    }

    @Override
    public void addReputation(UUID player, ResourceLocation deity, double amount) {
        ReputationEntry entry = this.getReputationMap(player).computeIfAbsent(deity, k -> new ReputationEntry());
        if (entry.lock == null) {
            entry.reputation += amount;
        }
    }

    @Override
    public void subtractReputation(UUID player, ResourceLocation deity, double amount) {
        ReputationEntry entry = this.getReputationMap(player).computeIfAbsent(deity, k -> new ReputationEntry());
        entry.reputation = Math.max(0.0, entry.reputation - amount);
    }

    @Override
    public void setReputation(UUID player, ResourceLocation deity, double amount) {
        ReputationEntry entry = this.getReputationMap(player).computeIfAbsent(deity, k -> new ReputationEntry());
        if (entry.lock == null || amount < 0.0) {
            entry.reputation = amount;
        }
    }

    @Override
    public boolean isLocked(UUID player, ResourceLocation deity) {
        return this.getReputationMap((UUID)player).computeIfAbsent((ResourceLocation)deity, (Function<ResourceLocation, ReputationEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$isLocked$4(net.minecraft.util.ResourceLocation ), (Lnet/minecraft/util/ResourceLocation;)Lelucent/eidolon/capability/ReputationEntry;)()).lock != null;
    }

    @Override
    public void lock(UUID player, ResourceLocation deity, ResourceLocation key) {
        this.getReputationMap((UUID)player).computeIfAbsent((ResourceLocation)deity, (Function<ResourceLocation, ReputationEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$lock$5(net.minecraft.util.ResourceLocation ), (Lnet/minecraft/util/ResourceLocation;)Lelucent/eidolon/capability/ReputationEntry;)()).lock = key;
    }

    @Override
    public boolean unlock(UUID player, ResourceLocation deity, ResourceLocation key) {
        ReputationEntry entry = this.getReputationMap(player).computeIfAbsent(deity, k -> new ReputationEntry());
        if (entry.lock != null && entry.lock.equals((Object)key)) {
            entry.lock = null;
            return true;
        }
        return false;
    }

    @Override
    public void pray(UUID player, long time) {
        this.getPrayerTimes().put(player, time);
    }

    @Override
    public boolean canPray(UUID player, long time) {
        return !this.getPrayerTimes().containsKey(player) || this.getPrayerTimes().get(player) < time - 21000L;
    }

    @Override
    public Map<UUID, Long> getPrayerTimes() {
        return this.prayerTimes;
    }

    @Override
    public Map<UUID, Map<ResourceLocation, ReputationEntry>> getReputationMap() {
        return this.reputationMap;
    }

    private static /* synthetic */ ReputationEntry lambda$lock$5(ResourceLocation k) {
        return new ReputationEntry();
    }

    private static /* synthetic */ ReputationEntry lambda$isLocked$4(ResourceLocation k) {
        return new ReputationEntry();
    }

    private static /* synthetic */ ReputationEntry lambda$getReputation$0(ResourceLocation k) {
        return new ReputationEntry();
    }
}

