/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.codex;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import elucent.eidolon.ClientEvents;
import elucent.eidolon.Registry;
import elucent.eidolon.capability.IKnowledge;
import elucent.eidolon.capability.KnowledgeProvider;
import elucent.eidolon.codex.Chapter;
import elucent.eidolon.codex.CodexGui;
import elucent.eidolon.codex.Page;
import elucent.eidolon.spell.Sign;
import elucent.eidolon.util.ColorUtil;
import elucent.eidolon.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SignIndexPage
extends Page {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("eidolon", "textures/gui/codex_sign_index_page.png");
    SignEntry[] entries;

    public SignIndexPage(SignEntry ... pages) {
        super(BACKGROUND);
        this.entries = pages;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean click(CodexGui gui, int x, int y, int mouseX, int mouseY) {
        ClientPlayerEntity entity = Minecraft.func_71410_x().field_71439_g;
        IKnowledge knowledge = (IKnowledge)entity.getCapability(KnowledgeProvider.CAPABILITY, null).resolve().get();
        for (int i = 0; i < this.entries.length; ++i) {
            int xx = x + 8 + i % 2 * 56;
            int yy = y + 4 + i / 2 * 52;
            if (mouseX >= xx + 38 && mouseY >= yy + 38 && mouseX <= xx + 50 && mouseY <= yy + 50) {
                gui.changeChapter(this.entries[i].chapter);
                Minecraft.func_71410_x().field_71439_g.func_213823_a(SoundEvents.field_187909_gi, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                return true;
            }
            if (!knowledge.knowsSign(this.entries[i].sign) || mouseX < xx || mouseX > xx + 48 || mouseY < yy || mouseY > yy + 48) continue;
            gui.addToChant(this.entries[i].sign);
            entity.func_213823_a((SoundEvent)Registry.SELECT_SIGN.get(), SoundCategory.NEUTRAL, 0.5f, entity.field_70170_p.field_73012_v.nextFloat() * 0.25f + 0.75f);
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    static void colorBlit(MatrixStack mStack, int x, int y, int uOffset, int vOffset, int width, int height, int textureWidth, int textureHeight, int color) {
        Matrix4f matrix = mStack.func_227866_c_().func_227870_a_();
        int maxX = x + width;
        int maxY = y + height;
        float minU = (float)uOffset / (float)textureWidth;
        float minV = (float)vOffset / (float)textureHeight;
        float maxU = minU + (float)width / (float)textureWidth;
        float maxV = minV + (float)height / (float)textureHeight;
        int r = ColorUtil.getRed(color);
        int g = ColorUtil.getGreen(color);
        int b = ColorUtil.getBlue(color);
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_227888_a_(matrix, (float)x, (float)maxY, 0.0f).func_225583_a_(minU, maxV).func_225586_a_(r, g, b, 255).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)maxX, (float)maxY, 0.0f).func_225583_a_(maxU, maxV).func_225586_a_(r, g, b, 255).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)maxX, (float)y, 0.0f).func_225583_a_(maxU, minV).func_225586_a_(r, g, b, 255).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x, (float)y, 0.0f).func_225583_a_(minU, minV).func_225586_a_(r, g, b, 255).func_181675_d();
        bufferbuilder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(CodexGui gui, MatrixStack mStack, int x, int y, int mouseX, int mouseY) {
        ClientPlayerEntity entity = Minecraft.func_71410_x().field_71439_g;
        IKnowledge knowledge = (IKnowledge)entity.getCapability(KnowledgeProvider.CAPABILITY, null).resolve().get();
        for (int i = 0; i < this.entries.length; ++i) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(BACKGROUND);
            int xx = x + 8 + i % 2 * 56;
            int yy = y + 4 + i / 2 * 52;
            Sign sign = this.entries[i].sign;
            boolean hover = knowledge.knowsSign(sign) && mouseX >= xx && mouseX <= xx + 48 && mouseY >= yy && mouseY <= yy + 48;
            boolean infoHover = mouseX >= xx + 38 && mouseY >= yy + 38 && mouseX <= xx + 50 && mouseY <= yy + 50;
            gui.func_238474_b_(mStack, xx, yy, knowledge.knowsSign(this.entries[i].sign) ? 128 : 176, 0, 48, 48);
            if (!knowledge.knowsSign(sign)) continue;
            Tessellator tess = Tessellator.func_178181_a();
            RenderSystem.enableBlend();
            RenderSystem.alphaFunc((int)518, (float)0.00390625f);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            if (hover && !infoHover) {
                mStack.func_227860_a_();
                mStack.func_227861_a_((double)(xx + 24), (double)(yy + 24), 0.0);
                mStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(ClientEvents.getClientTicks() * 1.5f));
                SignIndexPage.colorBlit(mStack, -18, -18, 128, 48, 36, 36, 256, 256, sign.getColor());
                mStack.func_227865_b_();
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            for (int j = 0; j < (hover && !infoHover ? 2 : 1); ++j) {
                RenderUtil.litQuad(mStack, (IRenderTypeBuffer)IRenderTypeBuffer.func_228455_a_((BufferBuilder)tess.func_178180_c()), xx + 12, yy + 12, 24.0, 24.0, sign.getRed(), sign.getGreen(), sign.getBlue(), (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(sign.getSprite()));
                tess.func_78381_a();
            }
            RenderSystem.defaultAlphaFunc();
            RenderSystem.disableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(BACKGROUND);
            gui.func_238474_b_(mStack, xx + 38, yy + 38, infoHover ? 188 : 176, 48, 12, 14);
            if (!infoHover) continue;
            gui.func_238652_a_(mStack, (ITextComponent)new TranslationTextComponent("eidolon.codex.sign_suffix", new Object[]{new TranslationTextComponent(sign.getRegistryName().func_110624_b() + ".sign." + sign.getRegistryName().func_110623_a())}), mouseX, mouseY);
        }
    }

    public static class SignEntry {
        Chapter chapter;
        Sign sign;

        public SignEntry(Chapter chapter, Sign sign) {
            this.chapter = chapter;
            this.sign = sign;
        }
    }
}

